/*
 * Decompiled with CFR 0.152.
 */
package com.enchantedwisp.torchesbt.api;

import com.enchantedwisp.torchesbt.RealisticTorchesBT;
import com.enchantedwisp.torchesbt.core.BurnableRegistry;
import com.enchantedwisp.torchesbt.core.burn.BurnTimeUtils;
import com.enchantedwisp.torchesbt.core.burn.Burnable;
import com.enchantedwisp.torchesbt.core.ignition.IgnitionHandler;
import com.enchantedwisp.torchesbt.mixinaccess.ICampfireBurnAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class BurnTime {
    private static final List<Consumer<class_1657>> PLAYER_ITEM_TICK_HANDLERS = new ArrayList<Consumer<class_1657>>();

    public static long getBurnTime(class_1799 stack) {
        if (!BurnableRegistry.isBurnableItem(stack.method_7909())) {
            return 0L;
        }
        return BurnTimeUtils.getCurrentBurnTime(stack);
    }

    public static void setBurnTime(class_1799 stack, long burnTime) {
        if (!BurnableRegistry.isBurnableItem(stack.method_7909())) {
            return;
        }
        BurnTimeUtils.setCurrentBurnTime(stack, burnTime);
    }

    public static long getBurnTime(class_1937 world, class_2338 pos) {
        class_2586 entity = world.method_8321(pos);
        if (entity == null || !BurnableRegistry.isBurnableBlock(world.method_8320(pos).method_26204())) {
            return 0L;
        }
        if (entity instanceof ICampfireBurnAccessor) {
            ICampfireBurnAccessor accessor = (ICampfireBurnAccessor)entity;
            return accessor.torchesbt_getBurnTime();
        }
        return BurnTimeUtils.getCurrentBurnTime(entity);
    }

    public static void setBurnTime(class_1937 world, class_2338 pos, long burnTime) {
        class_2586 entity = world.method_8321(pos);
        if (entity == null || !BurnableRegistry.isBurnableBlock(world.method_8320(pos).method_26204())) {
            return;
        }
        long clamped = Math.max(0L, Math.min(burnTime, BurnableRegistry.getBurnTime(world.method_8320(pos).method_26204())));
        if (entity instanceof ICampfireBurnAccessor) {
            ICampfireBurnAccessor accessor = (ICampfireBurnAccessor)entity;
            accessor.torchesbt_setBurnTime(clamped);
        } else {
            ((Burnable)entity).setRemainingBurnTime(clamped);
        }
        if (clamped <= 0L) {
            world.method_8413(pos, world.method_8320(pos), world.method_8320(pos), 3);
        }
    }

    public static class_1799 igniteItem(class_1799 stack, long burnTime) {
        class_1792 litItem = BurnableRegistry.getLitItem(stack.method_7909());
        if (litItem == null) {
            return stack;
        }
        class_1799 litStack = new class_1799((class_1935)litItem, stack.method_7947());
        BurnTime.setBurnTime(litStack, burnTime);
        return litStack;
    }

    public static boolean igniteBlock(class_1937 world, class_2338 pos, long burnTime) {
        class_2680 state = world.method_8320(pos);
        class_2248 litBlock = BurnableRegistry.getLitBlock(state.method_26204());
        if (litBlock == null || litBlock == state.method_26204()) {
            return false;
        }
        class_2680 newState = IgnitionHandler.copyProperties(state, litBlock.method_9564());
        world.method_8652(pos, newState, 3);
        BurnTime.setBurnTime(world, pos, burnTime);
        return true;
    }

    public static void registerPlayerItemTickHandler(Consumer<class_1657> handler) {
        PLAYER_ITEM_TICK_HANDLERS.add(handler);
    }

    public static void runPlayerItemTickHandlers(class_1657 player) {
        for (Consumer<class_1657> handler : PLAYER_ITEM_TICK_HANDLERS) {
            try {
                handler.accept(player);
            }
            catch (Exception e) {
                RealisticTorchesBT.LOGGER.warn("Error in player item tick handler", (Throwable)e);
            }
        }
    }
}

