/*
 * Decompiled with CFR 0.152.
 */
package com.enchantedwisp.torchesbt.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuelTypeAPI {
    public static final String MOD_ID = "torchesbt";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"torchesbt");
    private static final Map<class_2960, FuelType> FUEL_TYPES = new HashMap<class_2960, FuelType>();

    public static FuelType registerFuelType(class_2960 id) {
        if (FUEL_TYPES.containsKey(id)) {
            LOGGER.warn("Fuel type {} already registered, returning existing instance", (Object)id);
            return FUEL_TYPES.get(id);
        }
        FuelType fuelType = new FuelType(id);
        FUEL_TYPES.put(id, fuelType);
        LOGGER.info("Registered fuel type {}", (Object)id);
        return fuelType;
    }

    public static FuelType getFuelType(class_2960 id) {
        return FUEL_TYPES.get(id);
    }

    public static long getFuelBurnTime(FuelType fuelType, class_2960 itemId) {
        Integer seconds = fuelType.getFuelMap().get(itemId);
        return seconds != null ? (long)seconds.intValue() * 20L : 0L;
    }

    public static Iterable<class_2960> getFuelTypeIds() {
        return FUEL_TYPES.keySet();
    }

    public static void addFuelItem(FuelType fuelType, class_1792 item, int burnTimeSeconds) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        if (fuelType.getFuelMap().containsKey(itemId)) {
            LOGGER.warn("Item {} already registered as fuel for {}, overwriting", (Object)itemId, (Object)fuelType.getId());
        }
        fuelType.getFuelMap().put(itemId, burnTimeSeconds);
        LOGGER.debug("Added fuel item {} for {} with {} seconds", new Object[]{itemId, fuelType.getId(), burnTimeSeconds});
    }

    public static void addFuelTag(FuelType fuelType, class_6862<class_1792> tag, int burnTimeSeconds) {
        Optional entryList = class_7923.field_41178.method_40266(tag);
        if (entryList.isPresent()) {
            ((class_6885.class_6888)entryList.get()).forEach(entry -> {
                class_2960 entryId = class_7923.field_41178.method_10221((Object)((class_1792)entry.comp_349()));
                if (fuelType.getFuelMap().containsKey(entryId)) {
                    LOGGER.warn("Item {} from tag {} already registered for {}, overwriting", new Object[]{entryId, tag.comp_327(), fuelType.getId()});
                }
                fuelType.getFuelMap().put(entryId, burnTimeSeconds);
                LOGGER.debug("Added fuel item {} from tag {} for {} with {} seconds", new Object[]{entryId, tag.comp_327(), fuelType.getId(), burnTimeSeconds});
            });
        } else {
            LOGGER.warn("Tag {} is empty or invalid for fuel type {}", (Object)tag.comp_327(), (Object)fuelType.getId());
        }
    }

    public static void clear() {
        for (FuelType type : FUEL_TYPES.values()) {
            type.getFuelMap().clear();
        }
        LOGGER.info("Cleared all fuel type contents");
    }

    public static class FuelType {
        private final class_2960 id;
        private final Map<class_2960, Integer> fuelMap;

        public FuelType(class_2960 id) {
            this.id = id;
            this.fuelMap = new HashMap<class_2960, Integer>();
        }

        public class_2960 getId() {
            return this.id;
        }

        public Map<class_2960, Integer> getFuelMap() {
            return this.fuelMap;
        }
    }
}

