/*
 * Decompiled with CFR 0.152.
 */
package com.enchantedwisp.torchesbt.blockentity;

import com.enchantedwisp.torchesbt.blockentity.ModBlockEntities;
import com.enchantedwisp.torchesbt.core.BurnableRegistry;
import com.enchantedwisp.torchesbt.core.burn.BurnTimeUtils;
import com.enchantedwisp.torchesbt.core.burn.Burnable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3486;

public class LanternBlockEntity
extends class_2586
implements Burnable {
    private static final String REMAINING_KEY = "remaining_burn";
    private long remainingBurnTime = this.getMaxBurnTime();

    public LanternBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.LANTERN_BLOCK_ENTITY, pos, state);
    }

    @Override
    public long getMaxBurnTime() {
        return BurnableRegistry.getBurnTime(this.method_11010().method_26204());
    }

    @Override
    public long getRemainingBurnTime() {
        return this.remainingBurnTime;
    }

    @Override
    public void setRemainingBurnTime(long time) {
        this.remainingBurnTime = Math.max(0L, Math.min(time, this.getMaxBurnTime()));
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    @Override
    public void tickBurn(class_1937 world, boolean isBlock) {
        if (this.remainingBurnTime <= 0L) {
            return;
        }
        boolean isRaining = isBlock && BurnTimeUtils.isActuallyRainingAt(world, this.field_11867);
        boolean isSubmerged = world.method_8316(this.field_11867).method_15767(class_3486.field_15517);
        double rainMult = this.getRainMultiplier();
        double waterMult = this.getWaterMultiplier();
        if (isSubmerged && waterMult == 10.0) {
            this.setRemainingBurnTime(0L);
            return;
        }
        double effectiveMultiplier = 1.0;
        if (isRaining) {
            effectiveMultiplier = Math.max(effectiveMultiplier, rainMult);
        }
        if (isSubmerged && waterMult > 0.0) {
            effectiveMultiplier = Math.max(effectiveMultiplier, waterMult);
        }
        long reduction = (long)Math.ceil(effectiveMultiplier);
        this.setRemainingBurnTime(this.remainingBurnTime - reduction);
    }

    @Override
    public double getRainMultiplier() {
        return BurnableRegistry.getRainMultiplier(this.method_11010().method_26204());
    }

    @Override
    public double getWaterMultiplier() {
        return BurnableRegistry.getWaterMultiplier(this.method_11010().method_26204());
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.remainingBurnTime = nbt.method_10537(REMAINING_KEY);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10544(REMAINING_KEY, this.remainingBurnTime);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }
}

