/*
 * Decompiled with CFR 0.152.
 */
package com.enchantedwisp.torchesbt.compat;

import com.enchantedwisp.torchesbt.RealisticTorchesBT;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.slf4j.Logger;

public class CompatResourceLoader {
    private static final Logger LOGGER = RealisticTorchesBT.LOGGER;
    private static final ModCompat[] COMPAT_MODS = new ModCompat[]{new ModCompat("chipped", "chipped_compat", "Chipped"), new ModCompat("trinkets", "trinkets_compat", "Trinkets")};

    public static void register() {
        ModContainer container = FabricLoader.getInstance().getModContainer("torchesbt").orElse(null);
        if (container == null) {
            LOGGER.warn("[Compat] Could not find mod container, skipping all compatibility resource packs");
            return;
        }
        for (ModCompat mod : COMPAT_MODS) {
            if (!FabricLoader.getInstance().isModLoaded(mod.modId)) continue;
            boolean success = ResourceManagerHelper.registerBuiltinResourcePack((class_2960)mod.getPackId(), (ModContainer)container, (class_2561)mod.getDisplayName(), (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
            if (success) {
                LOGGER.info("[Compat] {} - Resource pack for RealisticTorchesBT registered!", (Object)mod.packDisplayName);
                continue;
            }
            LOGGER.warn("[Compat] Failed to register {} resource pack!", (Object)mod.packDisplayName);
        }
    }

    private record ModCompat(String modId, String packName, String packDisplayName) {
        class_2960 getPackId() {
            return new class_2960("torchesbt", this.packName);
        }

        class_2561 getDisplayName() {
            return class_2561.method_43470((String)(this.packDisplayName + " Compat for RealisticTorchesBT"));
        }
    }
}

