/*
 * Decompiled with CFR 0.152.
 */
package com.enchantedwisp.torchesbt.compat.chipped;

import com.enchantedwisp.torchesbt.RealisticTorchesBT;
import com.enchantedwisp.torchesbt.compat.chipped.block.ChippedUnlitLanternBlock;
import com.enchantedwisp.torchesbt.compat.chipped.block.ChippedUnlitTorchBlock;
import com.enchantedwisp.torchesbt.compat.chipped.block.ChippedUnlitWallTorchBlock;
import com.enchantedwisp.torchesbt.compat.chipped.block.SpecialUnlitLanternBlock;
import com.enchantedwisp.torchesbt.compat.chipped.blockentity.ChippedModBlockEntities;
import com.enchantedwisp.torchesbt.compat.chipped.item.ChippedSpecialUnlitLanternItem;
import com.enchantedwisp.torchesbt.compat.chipped.item.ChippedUnlitLanternItem;
import com.enchantedwisp.torchesbt.compat.chipped.item.ChippedUnlitTorchItem;
import com.enchantedwisp.torchesbt.core.BurnableRegistry;
import com.enchantedwisp.torchesbt.core.DefaultFuelTypes;
import com.enchantedwisp.torchesbt.util.ConfigCache;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public class ChippedRegistryHandler {
    private static final String[] CHIPPED_LANTERNS = new String[]{"blue_paper", "burning_coal", "checkered_iron", "dark_blue_paper", "ender", "green_paper", "iron_bowl", "purple_paper", "red_paper", "small_green", "white_paper", "wooden_cage", "wrought_iron", "yellow_tube"};
    private static final String[] SPECIAL_LANTERNS = new String[]{"big", "donut", "tall", "wide"};
    private static final String[] CHIPPED_TORCHES = new String[]{"acacia", "birch", "crimson", "dark_oak", "glow", "iron", "jungle", "spruce", "warped"};
    private static final List<class_2248> UNLIT_LANTERN_BLOCKS = new ArrayList<class_2248>();
    private static final List<class_1792> UNLIT_LANTERN_ITEMS = new ArrayList<class_1792>();
    private static final List<class_2248> UNLIT_TORCH_BLOCKS = new ArrayList<class_2248>();
    private static final List<class_1792> UNLIT_TORCH_ITEMS = new ArrayList<class_1792>();

    public static void register() {
        for (String variant : CHIPPED_LANTERNS) {
            ChippedRegistryHandler.registerLantern(variant, false);
        }
        for (String variant : SPECIAL_LANTERNS) {
            ChippedRegistryHandler.registerLantern(variant, true);
        }
        for (String variant : CHIPPED_TORCHES) {
            ChippedRegistryHandler.registerTorch(variant);
        }
        RegistryEntryAddedCallback.event((class_2378)class_7923.field_41175).register((rawId, id, block) -> {
            if (id.method_12836().equals("chipped")) {
                for (String variant : SPECIAL_LANTERNS) {
                    if (!id.method_12832().equals(variant + "_lantern")) continue;
                    RealisticTorchesBT.LOGGER.info("[Compat] Detected Chipped special lantern: {}", (Object)id);
                    ChippedModBlockEntities.onLanternDetected(variant, block);
                }
            }
        });
        for (String variant : SPECIAL_LANTERNS) {
            class_2960 id2 = class_2960.method_43902((String)"chipped", (String)(variant + "_lantern"));
            if (!class_7923.field_41175.method_10250(id2)) continue;
            class_2248 block2 = (class_2248)class_7923.field_41175.method_10223(id2);
            RealisticTorchesBT.LOGGER.info("[Compat] Found existing Chipped lantern at startup: {}", (Object)id2);
            ChippedModBlockEntities.onLanternDetected(variant, block2);
        }
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(entries -> {
            UNLIT_LANTERN_ITEMS.forEach(arg_0 -> ((FabricItemGroupEntries)entries).method_45421(arg_0));
            UNLIT_TORCH_ITEMS.forEach(arg_0 -> ((FabricItemGroupEntries)entries).method_45421(arg_0));
        });
        RealisticTorchesBT.LOGGER.info("[Compat] Chipped - Registered {} Chipped unlit items and blocks", (Object)(UNLIT_LANTERN_ITEMS.size() + UNLIT_TORCH_ITEMS.size() * 2));
    }

    private static void registerLantern(String variant, boolean isSpecial) {
        Object unlitBlock;
        if (isSpecial) {
            class_265 eastShape;
            unlitBlock = new SpecialUnlitLanternBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_16541), eastShape, switch (variant) {
                case "tall" -> eastShape = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0);
                case "big", "wide" -> eastShape = class_2248.method_9541((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
                default -> {
                    eastShape = SpecialUnlitLanternBlock.DEFAULT_EAST_SHAPE;
                    yield SpecialUnlitLanternBlock.DEFAULT_NORTH_SHAPE;
                }
            });
        } else {
            unlitBlock = new ChippedUnlitLanternBlock();
        }
        class_2960 unlitBlockId = class_2960.method_43902((String)"torchesbt", (String)("chipped/unlit_" + variant + "_lantern"));
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)unlitBlockId, (Object)unlitBlock);
        UNLIT_LANTERN_BLOCKS.add((class_2248)unlitBlock);
        class_1747 unlitItem = isSpecial ? new ChippedSpecialUnlitLanternItem((class_2248)unlitBlock, new class_1792.class_1793()) : new ChippedUnlitLanternItem((class_2248)unlitBlock, new class_1792.class_1793());
        class_2960 unlitItemId = class_2960.method_43902((String)"torchesbt", (String)("chipped/unlit_" + variant + "_lantern"));
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)unlitItemId, (Object)unlitItem);
        UNLIT_LANTERN_ITEMS.add((class_1792)unlitItem);
        RealisticTorchesBT.LOGGER.debug("Registered lantern: {} (unlit block: {}, unlit item: {})", new Object[]{variant, unlitBlockId, unlitItemId});
    }

    private static void registerTorch(String variant) {
        ChippedUnlitTorchBlock unlitTorchBlock = new ChippedUnlitTorchBlock(variant);
        class_2960 unlitTorchBlockId = class_2960.method_43902((String)"torchesbt", (String)("chipped/unlit_" + variant + "_torch"));
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)unlitTorchBlockId, (Object)((Object)unlitTorchBlock));
        UNLIT_TORCH_BLOCKS.add((class_2248)unlitTorchBlock);
        ChippedUnlitWallTorchBlock unlitWallTorchBlock = new ChippedUnlitWallTorchBlock(variant);
        class_2960 unlitWallTorchBlockId = class_2960.method_43902((String)"torchesbt", (String)("chipped/unlit_" + variant + "_wall_torch"));
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)unlitWallTorchBlockId, (Object)((Object)unlitWallTorchBlock));
        UNLIT_TORCH_BLOCKS.add((class_2248)unlitWallTorchBlock);
        ChippedUnlitTorchItem unlitItem = new ChippedUnlitTorchItem(unlitTorchBlock, new class_1792.class_1793(), variant);
        class_2960 unlitItemId = class_2960.method_43902((String)"torchesbt", (String)("chipped/unlit_" + variant + "_torch"));
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)unlitItemId, (Object)((Object)unlitItem));
        UNLIT_TORCH_ITEMS.add((class_1792)unlitItem);
        RealisticTorchesBT.LOGGER.debug("Registered torch: {} (unlit torch: {}, unlit wall torch: {}, unlit item: {})", new Object[]{variant, unlitTorchBlockId, unlitWallTorchBlockId, unlitItemId});
    }

    public static void registerBurnables() {
        class_2248 unlitBlock;
        class_2248 litBlock;
        class_1792 unlitItem;
        class_1792 litItem;
        for (String variant : CHIPPED_LANTERNS) {
            litItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_43902((String)"chipped", (String)(variant + "_lantern")));
            unlitItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_43902((String)"torchesbt", (String)("chipped/unlit_" + variant + "_lantern")));
            litBlock = (class_2248)class_7923.field_41175.method_10223(class_2960.method_43902((String)"chipped", (String)(variant + "_lantern")));
            unlitBlock = (class_2248)class_7923.field_41175.method_10223(class_2960.method_43902((String)"torchesbt", (String)("chipped/unlit_" + variant + "_lantern")));
            BurnableRegistry.registerBurnableItem(litItem, unlitItem, ConfigCache.getLanternBurnTime(), ConfigCache.getRainLanternMultiplier(), ConfigCache.getWaterLanternMultiplier(), ConfigCache.isAllowLanternTick());
            BurnableRegistry.registerBurnableBlock(litBlock, unlitBlock, ConfigCache.getLanternBurnTime(), ConfigCache.getRainLanternMultiplier(), ConfigCache.getWaterLanternMultiplier(), true, DefaultFuelTypes.LANTERN, ConfigCache.isAllowLanternTick());
            RealisticTorchesBT.LOGGER.debug("Registered Chipped lantern: {} (unlit block: {}, unlit item: {})", new Object[]{variant, class_7923.field_41175.method_10221((Object)unlitBlock), class_7923.field_41178.method_10221((Object)unlitItem)});
        }
        for (String variant : SPECIAL_LANTERNS) {
            litItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_43902((String)"chipped", (String)(variant + "_lantern")));
            unlitItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_43902((String)"torchesbt", (String)("chipped/unlit_" + variant + "_lantern")));
            litBlock = (class_2248)class_7923.field_41175.method_10223(class_2960.method_43902((String)"chipped", (String)(variant + "_lantern")));
            unlitBlock = (class_2248)class_7923.field_41175.method_10223(class_2960.method_43902((String)"torchesbt", (String)("chipped/unlit_" + variant + "_lantern")));
            BurnableRegistry.registerBurnableItem(litItem, unlitItem, ConfigCache.getLanternBurnTime(), ConfigCache.getRainLanternMultiplier(), ConfigCache.getWaterLanternMultiplier(), ConfigCache.isAllowLanternTick());
            BurnableRegistry.registerBurnableBlock(litBlock, unlitBlock, ConfigCache.getLanternBurnTime(), ConfigCache.getRainLanternMultiplier(), ConfigCache.getWaterLanternMultiplier(), true, DefaultFuelTypes.LANTERN, ConfigCache.isAllowLanternTick());
            RealisticTorchesBT.LOGGER.debug("Registered Chipped special lantern: {} (unlit block: {}, unlit item: {})", new Object[]{variant, class_7923.field_41175.method_10221((Object)unlitBlock), class_7923.field_41178.method_10221((Object)unlitItem)});
        }
        for (String variant : CHIPPED_TORCHES) {
            litItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_43902((String)"chipped", (String)(variant + "_torch")));
            unlitItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_43902((String)"torchesbt", (String)("chipped/unlit_" + variant + "_torch")));
            class_2248 litTorchBlock = (class_2248)class_7923.field_41175.method_10223(class_2960.method_43902((String)"chipped", (String)(variant + "_torch")));
            class_2248 unlitTorchBlock = (class_2248)class_7923.field_41175.method_10223(class_2960.method_43902((String)"torchesbt", (String)("chipped/unlit_" + variant + "_torch")));
            class_2248 litWallTorchBlock = (class_2248)class_7923.field_41175.method_10223(class_2960.method_43902((String)"chipped", (String)(variant + "_wall_torch")));
            class_2248 unlitWallTorchBlock = (class_2248)class_7923.field_41175.method_10223(class_2960.method_43902((String)"torchesbt", (String)("chipped/unlit_" + variant + "_wall_torch")));
            BurnableRegistry.registerBurnableItem(litItem, unlitItem, ConfigCache.getTorchBurnTime(), ConfigCache.getRainTorchMultiplier(), ConfigCache.getWaterTorchMultiplier(), ConfigCache.isAllowTorchTick());
            BurnableRegistry.registerBurnableBlock(litTorchBlock, unlitTorchBlock, ConfigCache.getTorchBurnTime(), ConfigCache.getRainTorchMultiplier(), ConfigCache.getWaterTorchMultiplier(), true, DefaultFuelTypes.TORCH, ConfigCache.isAllowTorchTick());
            BurnableRegistry.registerBurnableBlock(litWallTorchBlock, unlitWallTorchBlock, ConfigCache.getTorchBurnTime(), ConfigCache.getRainTorchMultiplier(), ConfigCache.getWaterTorchMultiplier(), true, DefaultFuelTypes.TORCH, ConfigCache.isAllowTorchTick());
            RealisticTorchesBT.LOGGER.debug("Registered Chipped torch: {} (unlit torch: {}, unlit wall torch: {}, unlit item: {})", new Object[]{variant, class_7923.field_41175.method_10221((Object)unlitTorchBlock), class_7923.field_41175.method_10221((Object)unlitWallTorchBlock), class_7923.field_41178.method_10221((Object)unlitItem)});
        }
        BurnableRegistry.snapshotCounts("[Compat] Chipped - ");
        BurnableRegistry.logSource("[Compat] Chipped - ", RealisticTorchesBT.LOGGER);
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerRenderLayers() {
        for (class_2248 lantern : UNLIT_LANTERN_BLOCKS) {
            class_2960 id = class_7923.field_41175.method_10221((Object)lantern);
            if (id.method_12832().contains("small_green") || id.method_12832().contains("ender") || id.method_12832().contains("yellow_tube")) {
                BlockRenderLayerMap.INSTANCE.putBlock(lantern, class_1921.method_23583());
                continue;
            }
            BlockRenderLayerMap.INSTANCE.putBlock(lantern, class_1921.method_23581());
        }
        for (class_2248 torch : UNLIT_TORCH_BLOCKS) {
            BlockRenderLayerMap.INSTANCE.putBlock(torch, class_1921.method_23581());
        }
    }
}

