/*
 * Decompiled with CFR 0.152.
 */
package com.enchantedwisp.torchesbt.compat.trinkets;

import com.enchantedwisp.torchesbt.api.BurnTickEvents;
import com.enchantedwisp.torchesbt.api.BurnTime;
import com.enchantedwisp.torchesbt.core.BurnableRegistry;
import com.enchantedwisp.torchesbt.core.burn.BurnTimeUtils;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3486;
import net.minecraft.class_3545;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrinketBurnHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"TrinketBurnHandler");

    public static void register() {
        BurnTime.registerPlayerItemTickHandler(TrinketBurnHandler::tickTrinkets);
    }

    public static void tickTrinkets(class_1657 player) {
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(component -> {
            for (class_3545 slot : component.getAllEquipped()) {
                class_1799 stack = (class_1799)slot.method_15441();
                SlotReference slotRef = (SlotReference)slot.method_15442();
                if (!BurnableRegistry.isBurnableItem(stack.method_7909())) continue;
                long burnTime = BurnTimeUtils.getCurrentBurnTime(stack);
                if (burnTime <= 0L) {
                    TrinketBurnHandler.extinguishTrinket(player, component, slotRef, stack);
                    continue;
                }
                class_1937 world = player.method_37908();
                boolean isRaining = BurnTimeUtils.isActuallyRainingAt(world, player.method_24515());
                boolean isSubmerged = player.method_5777(class_3486.field_15517);
                double rainMult = BurnableRegistry.getRainMultiplier(stack.method_7909());
                double waterMult = BurnableRegistry.getWaterMultiplier(stack.method_7909());
                double effectiveMultiplier = 1.0;
                if (isRaining) {
                    effectiveMultiplier = Math.max(effectiveMultiplier, rainMult);
                }
                if (isSubmerged && waterMult > 0.0) {
                    effectiveMultiplier = Math.max(effectiveMultiplier, waterMult);
                }
                long baseDecrement = (long)Math.ceil(effectiveMultiplier);
                BurnTickEvents.PlayerHeldContext heldContext = new BurnTickEvents.PlayerHeldContext(player, stack, baseDecrement);
                long finalDecrement = ((BurnTickEvents.PlayerHeld)BurnTickEvents.PLAYER_HELD.invoker()).onTick(heldContext, baseDecrement);
                BurnTimeUtils.setCurrentBurnTime(stack, Math.max(0L, burnTime -= finalDecrement));
                if (burnTime > 0L) continue;
                TrinketBurnHandler.extinguishTrinket(player, component, slotRef, stack);
            }
        });
    }

    private static void extinguishTrinket(class_1657 player, TrinketComponent component, SlotReference slotRef, class_1799 stack) {
        class_1799 unlit = new class_1799((class_1935)Objects.requireNonNull(BurnableRegistry.getUnlitItem(stack.method_7909())), stack.method_7947());
        String group = slotRef.inventory().getSlotType().getGroup();
        String slotName = slotRef.inventory().getSlotType().getName();
        ((TrinketInventory)((Map)component.getInventory().get(group)).get(slotName)).method_5447(slotRef.index(), unlit);
        LOGGER.debug("Extinguished trinket item in slot {}/{} for player {}", new Object[]{group, slotName, player.method_5477().getString()});
    }
}

