/*
 * Decompiled with CFR 0.152.
 */
package com.enchantedwisp.torchesbt.config;

import com.enchantedwisp.torchesbt.RealisticTorchesBT;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="torchesbt")
public class RealisticTorchesBTConfig
implements ConfigData {
    @Comment(value="Enable dynamic lighting support (ignores whether a mod is installed). Default: false")
    @ConfigEntry.Gui.PrefixText
    public boolean enableDynamicLights = false;
    @Comment(value="Allow refueling items in slots. Default: true")
    @ConfigEntry.Gui.PrefixText
    public boolean allowInventoryRefueling = true;
    @Comment(value="Allow torches to tick, causing them to burn out over time. Default: true")
    @ConfigEntry.Gui.PrefixText
    public boolean allowTorchTick = true;
    @Comment(value="Allow lanterns to tick, causing them to burn out over time. Default: true")
    @ConfigEntry.Gui.PrefixText
    public boolean allowLanternTick = true;
    @Comment(value="Allow campfire to tick, causing them to burn out over time. Default: true")
    @ConfigEntry.Gui.PrefixText
    public boolean allowCampfireTick = true;
    @Comment(value="Burn time for torches. Default: 40 Max: 3600")
    @ConfigEntry.Gui.PrefixText
    @ConfigEntry.BoundedDiscrete(min=5L, max=3600L)
    public int torchBurnTime = 40;
    @Comment(value="Burn time for lanterns. Default: 60 Max: 3600")
    @ConfigEntry.BoundedDiscrete(min=5L, max=3600L)
    public int lanternBurnTime = 60;
    @Comment(value="Burn time for campfires. Default: 100 Max: 3600")
    @ConfigEntry.BoundedDiscrete(min=5L, max=3600L)
    public int campfireBurnTime = 100;
    @Comment(value="If true, rain affects Burn Time on burnables. Default: true")
    @ConfigEntry.Gui.PrefixText
    public boolean enableRainExtinguish = true;
    @Comment(value="Burn time multiplier for torches in rain. Default: 10.0 (10x faster) Max: 10x")
    public double rainTorchMultiplier = 10.0;
    @Comment(value="Burn time multiplier for campfires in rain. Default: 8.5 (8.5x faster) Max: 10x")
    public double rainCampfireMultiplier = 8.5;
    @Comment(value="Burn time multiplier for lanterns in rain. Default: 4.5 (4.5x faster) Max: 10x")
    public double rainLanternMultiplier = 4.5;
    @Comment(value="Burn time multiplier for torches in water. Default: 7.5 (7.5x faster) Max: 10x instant extinguish")
    public double waterTorchMultiplier = 10.0;
    @Comment(value="Burn time multiplier for lanterns in water. Default: 7.5 (7.5x faster) Max: 10x instant extinguish")
    public double waterLanternMultiplier = 7.5;
    @Comment(value="Burn time multiplier for campfires in water. Default: 7.5 (7.5x faster) Max: 10x instant extinguish")
    public double waterCampfireMultiplier = 10.0;

    public void validatePostLoad() {
        if (this.lanternBurnTime < 5 || this.lanternBurnTime > 3600) {
            RealisticTorchesBT.LOGGER.warn("Correcting torchBurnTime: {} to {}. Must be between 5 and 3600", (Object)this.lanternBurnTime, (Object)Math.max(5, Math.min(3600, this.lanternBurnTime)));
            this.lanternBurnTime = Math.max(5, Math.min(3600, this.lanternBurnTime));
        }
        if (this.campfireBurnTime < 5 || this.campfireBurnTime > 3600) {
            RealisticTorchesBT.LOGGER.warn("Correcting torchBurnTime: {} to {}. Must be between 5 and 3600", (Object)this.campfireBurnTime, (Object)Math.max(5, Math.min(3600, this.campfireBurnTime)));
            this.campfireBurnTime = Math.max(5, Math.min(3600, this.campfireBurnTime));
        }
        if (this.rainTorchMultiplier < 1.0 || this.rainTorchMultiplier > 10.0) {
            RealisticTorchesBT.LOGGER.warn("Correcting rainTorchMultiplier: {} to {}. Must be between 1.0 and 10.0.", (Object)this.rainTorchMultiplier, (Object)Math.max(1.0, Math.min(10.0, this.rainTorchMultiplier)));
            this.rainTorchMultiplier = Math.max(1.0, Math.min(10.0, this.rainTorchMultiplier));
        }
        if (this.rainCampfireMultiplier < 1.0 || this.rainCampfireMultiplier > 10.0) {
            RealisticTorchesBT.LOGGER.warn("Correcting rainCampfireMultiplier: {} to {}. Must be between 1.0 and 10.0.", (Object)this.rainCampfireMultiplier, (Object)Math.max(1.0, Math.min(10.0, this.rainCampfireMultiplier)));
            this.rainCampfireMultiplier = Math.max(1.0, Math.min(10.0, this.rainCampfireMultiplier));
        }
        if (this.rainLanternMultiplier < 1.0 || this.rainLanternMultiplier > 10.0) {
            RealisticTorchesBT.LOGGER.warn("Correcting rainLanternMultiplier: {} to {}. Must be between 1.0 and 10.0.", (Object)this.rainLanternMultiplier, (Object)Math.max(1.0, Math.min(10.0, this.rainLanternMultiplier)));
            this.rainLanternMultiplier = Math.max(1.0, Math.min(10.0, this.rainLanternMultiplier));
        }
        if (this.waterTorchMultiplier < 1.0 || this.waterTorchMultiplier > 10.0) {
            RealisticTorchesBT.LOGGER.warn("Correcting waterTorchMultiplier: {} to {}. Must be between 1.0 and 10.0.", (Object)this.waterTorchMultiplier, (Object)Math.max(1.0, Math.min(10.0, this.waterTorchMultiplier)));
            this.waterTorchMultiplier = Math.max(1.0, Math.min(10.0, this.waterTorchMultiplier));
        }
        if (this.waterLanternMultiplier < 1.0 || this.waterLanternMultiplier > 10.0) {
            RealisticTorchesBT.LOGGER.warn("Correcting waterLanternMultiplier: {} to {}. Must be between 1.0 and 10.0.", (Object)this.waterLanternMultiplier, (Object)Math.max(1.0, Math.min(10.0, this.waterLanternMultiplier)));
            this.waterLanternMultiplier = Math.max(1.0, Math.min(10.0, this.waterLanternMultiplier));
        }
        if (this.waterCampfireMultiplier < 1.0 || this.waterCampfireMultiplier > 10.0) {
            RealisticTorchesBT.LOGGER.warn("Correcting waterCampfireMultiplier: {} to {}. Must be between 1.0 and 10.0.", (Object)this.waterCampfireMultiplier, (Object)Math.max(1.0, Math.min(10.0, this.waterCampfireMultiplier)));
            this.waterCampfireMultiplier = Math.max(1.0, Math.min(10.0, this.waterCampfireMultiplier));
        }
    }
}

