/*
 * Decompiled with CFR 0.152.
 */
package com.enchantedwisp.torchesbt.core;

import com.enchantedwisp.torchesbt.RealisticTorchesBT;
import com.enchantedwisp.torchesbt.api.FuelTypeAPI;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class BurnableRegistry {
    private static final Logger LOGGER = RealisticTorchesBT.LOGGER;
    private static final Map<class_1792, BurnableItemEntry> BURNABLE_ITEMS = new HashMap<class_1792, BurnableItemEntry>();
    private static final Map<class_2248, BurnableBlockEntry> BURNABLE_BLOCKS = new HashMap<class_2248, BurnableBlockEntry>();
    private static final Map<String, Integer> SOURCE_ITEM_COUNTS = new HashMap<String, Integer>();
    private static final Map<String, Integer> SOURCE_BLOCK_COUNTS = new HashMap<String, Integer>();

    public static int getBurnableItemsCount() {
        return BURNABLE_ITEMS.size();
    }

    public static int getBurnableBlocksCount() {
        return BURNABLE_BLOCKS.size();
    }

    public static void snapshotCounts(String source) {
        SOURCE_ITEM_COUNTS.put(source, BurnableRegistry.getBurnableItemsCount());
        SOURCE_BLOCK_COUNTS.put(source, BurnableRegistry.getBurnableBlocksCount());
    }

    public static void logSource(String source, Logger logger) {
        int items = SOURCE_ITEM_COUNTS.getOrDefault(source, 0);
        int blocks = SOURCE_BLOCK_COUNTS.getOrDefault(source, 0);
        logger.info("{} burnables registered: {} items, {} blocks", new Object[]{source, items, blocks});
    }

    public static void registerBurnableItem(class_1792 litItem, class_1792 unlitItem, long burnTime, double rainMultiplier, double waterMultiplier, boolean enableTicking) {
        BURNABLE_ITEMS.put(litItem, new BurnableItemEntry(litItem, unlitItem, burnTime, rainMultiplier, waterMultiplier, enableTicking));
        LOGGER.debug("Registered burnable item: {} (unlit: {}, ticking: {})", new Object[]{class_7923.field_41178.method_10221((Object)litItem), class_7923.field_41178.method_10221((Object)unlitItem), enableTicking});
    }

    public static void registerBurnableBlock(class_2248 litBlock, class_2248 unlitBlock, long burnTime, double rainMultiplier, double waterMultiplier, boolean hasBlockEntity, FuelTypeAPI.FuelType fuelType, boolean enableTicking) {
        BURNABLE_BLOCKS.put(litBlock, new BurnableBlockEntry(litBlock, unlitBlock, burnTime, rainMultiplier, waterMultiplier, hasBlockEntity, fuelType, enableTicking));
        LOGGER.debug("Registered burnable block: {} (unlit: {}, fuelType: {}, ticking: {})", new Object[]{class_7923.field_41175.method_10221((Object)litBlock), class_7923.field_41175.method_10221((Object)unlitBlock), fuelType != null ? fuelType.getId() : "null", enableTicking});
    }

    public static boolean isBurnableItem(class_1792 item) {
        return BURNABLE_ITEMS.containsKey(item);
    }

    public static boolean isBurnableBlock(class_2248 block) {
        return BURNABLE_BLOCKS.containsKey(block);
    }

    public static class_1792 getUnlitItem(class_1792 litItem) {
        BurnableItemEntry entry = BURNABLE_ITEMS.get(litItem);
        return entry != null ? entry.unlitItem() : null;
    }

    public static class_1792 getLitItem(class_1792 unlitItem) {
        return BURNABLE_ITEMS.values().stream().filter(entry -> entry.unlitItem() == unlitItem).map(BurnableItemEntry::litItem).findFirst().orElse(null);
    }

    public static class_2248 getUnlitBlock(class_2248 litBlock) {
        BurnableBlockEntry entry = BURNABLE_BLOCKS.get(litBlock);
        return entry != null ? entry.unlitBlock() : null;
    }

    public static class_2248 getLitBlock(class_2248 unlitBlock) {
        return BURNABLE_BLOCKS.values().stream().filter(entry -> entry.unlitBlock() == unlitBlock).map(BurnableBlockEntry::litBlock).findFirst().orElse(null);
    }

    public static long getBurnTime(class_1792 item) {
        BurnableItemEntry entry = BURNABLE_ITEMS.get(item);
        return entry != null ? entry.burnTime() : 0L;
    }

    public static long getBurnTime(class_2248 block) {
        BurnableBlockEntry entry = BURNABLE_BLOCKS.get(block);
        return entry != null ? entry.burnTime() : 0L;
    }

    public static double getRainMultiplier(class_1792 item) {
        BurnableItemEntry entry = BURNABLE_ITEMS.get(item);
        return entry != null ? entry.rainMultiplier() : 1.0;
    }

    public static double getRainMultiplier(class_2248 block) {
        BurnableBlockEntry entry = BURNABLE_BLOCKS.get(block);
        return entry != null ? entry.rainMultiplier() : 1.0;
    }

    public static double getWaterMultiplier(class_1792 item) {
        BurnableItemEntry entry = BURNABLE_ITEMS.get(item);
        return entry != null ? entry.waterMultiplier() : 1.0;
    }

    public static double getWaterMultiplier(class_2248 block) {
        BurnableBlockEntry entry = BURNABLE_BLOCKS.get(block);
        return entry != null ? entry.waterMultiplier() : 1.0;
    }

    public static boolean hasBlockEntity(class_2248 block) {
        BurnableBlockEntry entry = BURNABLE_BLOCKS.get(block);
        return entry != null && entry.hasBlockEntity();
    }

    public static boolean isTickingEnabled(class_1792 item) {
        BurnableItemEntry entry = BURNABLE_ITEMS.get(item);
        return entry != null && entry.enableTicking();
    }

    public static boolean isTickingEnabled(class_2248 block) {
        BurnableBlockEntry entry = BURNABLE_BLOCKS.get(block);
        return entry != null && entry.enableTicking();
    }

    public static FuelTypeAPI.FuelType getFuelType(class_2248 block) {
        BurnableBlockEntry entry = BURNABLE_BLOCKS.get(block);
        return entry != null ? entry.fuelType() : null;
    }

    public record BurnableItemEntry(class_1792 litItem, class_1792 unlitItem, long burnTime, double rainMultiplier, double waterMultiplier, boolean enableTicking) {
    }

    public record BurnableBlockEntry(class_2248 litBlock, class_2248 unlitBlock, long burnTime, double rainMultiplier, double waterMultiplier, boolean hasBlockEntity, FuelTypeAPI.FuelType fuelType, boolean enableTicking) {
    }
}

