/*
 * Decompiled with CFR 0.152.
 */
package com.enchantedwisp.torchesbt.core.burn;

import com.enchantedwisp.torchesbt.RealisticTorchesBT;
import com.enchantedwisp.torchesbt.api.BurnTickEvents;
import com.enchantedwisp.torchesbt.api.BurnTime;
import com.enchantedwisp.torchesbt.core.BurnableRegistry;
import com.enchantedwisp.torchesbt.core.burn.BurnTimeUtils;
import com.enchantedwisp.torchesbt.core.burn.Burnable;
import com.enchantedwisp.torchesbt.core.ignition.IgnitionHandler;
import com.enchantedwisp.torchesbt.mixinaccess.ICampfireBurnAccessor;
import com.enchantedwisp.torchesbt.util.ConfigCache;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3486;
import net.minecraft.class_3922;
import org.slf4j.Logger;

public class BurnTimeManager {
    private static final Logger LOGGER = RealisticTorchesBT.LOGGER;
    private static final int ITEM_UPDATE_INTERVAL = 5;
    private static final int SCAN_RADIUS = 32;
    private static final int SCAN_VERTICAL = 8;

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (server.method_3780() % 5 != 0) {
                return;
            }
            for (class_1657 player : server.method_3760().method_14571()) {
                BurnTimeManager.processPlayerItems(player);
                BurnTimeManager.processNearbyBurnables(player);
            }
        });
        LOGGER.info("Registered burn time tick handler");
    }

    private static void processPlayerItems(class_1657 player) {
        if (player.method_37908().field_9236) {
            return;
        }
        for (class_1268 hand : class_1268.values()) {
            class_1799 stack = player.method_5998(hand);
            if (!BurnableRegistry.isBurnableItem(stack.method_7909()) || !ConfigCache.isDynamicLightsEnabled()) continue;
            long burnTime = BurnTimeUtils.getCurrentBurnTime(stack);
            if (burnTime <= 0L) {
                BurnTimeManager.extinguishPlayerItem(player, hand, stack);
                continue;
            }
            if (!BurnableRegistry.isTickingEnabled(stack.method_7909())) continue;
            class_1937 world = player.method_37908();
            class_2338 pos = player.method_24515();
            boolean isRaining = BurnTimeUtils.isActuallyRainingAt(world, pos);
            boolean isSubmerged = player.method_5777(class_3486.field_15517);
            double rainMult = BurnableRegistry.getRainMultiplier(stack.method_7909());
            double waterMult = BurnableRegistry.getWaterMultiplier(stack.method_7909());
            if (isSubmerged && waterMult == 10.0) {
                burnTime = 0L;
                LOGGER.debug("Instantly extinguished held item due to water submersion (multiplier=10)");
            } else {
                double effectiveMultiplier = 1.0;
                if (isRaining) {
                    effectiveMultiplier = Math.max(effectiveMultiplier, rainMult);
                }
                if (isSubmerged && waterMult > 0.0) {
                    effectiveMultiplier = Math.max(effectiveMultiplier, waterMult);
                }
                long baseDecrement = (long)Math.ceil(effectiveMultiplier);
                BurnTickEvents.PlayerHeldContext heldContext = new BurnTickEvents.PlayerHeldContext(player, stack, baseDecrement);
                long finalDecrement = ((BurnTickEvents.PlayerHeld)BurnTickEvents.PLAYER_HELD.invoker()).onTick(heldContext, baseDecrement);
                burnTime -= finalDecrement;
            }
            BurnTimeUtils.setCurrentBurnTime(stack, Math.max(0L, burnTime));
            if (burnTime > 0L) continue;
            BurnTimeManager.extinguishPlayerItem(player, hand, stack);
        }
        BurnTime.runPlayerItemTickHandlers(player);
    }

    private static void extinguishPlayerItem(class_1657 player, class_1268 hand, class_1799 stack) {
        class_1799 unlit = new class_1799((class_1935)Objects.requireNonNull(BurnableRegistry.getUnlitItem(stack.method_7909())), stack.method_7947());
        player.method_6122(hand, unlit);
    }

    private static void processNearbyBurnables(class_1657 player) {
        class_1937 world = player.method_37908();
        if (world.field_9236) {
            return;
        }
        class_2338 pos = player.method_24515();
        class_238 scanBox = new class_238(pos).method_1009(32.0, 8.0, 32.0);
        for (class_2338 blockPos : class_2338.method_10097((class_2338)pos.method_10069(-32, -8, -32), (class_2338)pos.method_10069(32, 8, 32))) {
            class_2680 state = world.method_8320(blockPos);
            class_2248 block = state.method_26204();
            class_2586 entity = world.method_8321(blockPos);
            if (entity instanceof Burnable) {
                Burnable burnable = (Burnable)entity;
                BurnTimeManager.tickBurnableBlock(world, blockPos, state, block, burnable);
                continue;
            }
            if (!(entity instanceof ICampfireBurnAccessor)) continue;
            ICampfireBurnAccessor campfire = (ICampfireBurnAccessor)entity;
            BurnTimeManager.tickCampfire(world, blockPos, state, campfire);
        }
        List items = world.method_8390(class_1542.class, scanBox, e -> BurnableRegistry.isBurnableItem(e.method_6983().method_7909()));
        for (class_1542 itemEntity : items) {
            if (!ConfigCache.isDynamicLightsEnabled()) continue;
            class_1799 stack = itemEntity.method_6983();
            long burnTime = BurnTimeUtils.getCurrentBurnTime(stack);
            if (burnTime <= 0L) {
                class_1799 unlit = new class_1799((class_1935)Objects.requireNonNull(BurnableRegistry.getUnlitItem(stack.method_7909())), stack.method_7947());
                itemEntity.method_6979(unlit);
                continue;
            }
            if (!BurnableRegistry.isTickingEnabled(stack.method_7909())) continue;
            boolean isRaining = BurnTimeUtils.isActuallyRainingAt(world, itemEntity.method_24515());
            boolean isSubmerged = itemEntity.method_5777(class_3486.field_15517);
            double rainMult = BurnableRegistry.getRainMultiplier(stack.method_7909());
            double waterMult = BurnableRegistry.getWaterMultiplier(stack.method_7909());
            if (isSubmerged && waterMult == 10.0) {
                burnTime = 0L;
                LOGGER.debug("Instantly extinguished dropped item due to water submersion (multiplier=10)");
            } else {
                double effectiveMultiplier = 1.0;
                if (isRaining) {
                    effectiveMultiplier = Math.max(effectiveMultiplier, rainMult);
                }
                if (isSubmerged && waterMult > 0.0) {
                    effectiveMultiplier = Math.max(effectiveMultiplier, waterMult);
                }
                long baseDecrement = (long)Math.ceil(effectiveMultiplier);
                BurnTickEvents.DroppedItemContext itemContext = new BurnTickEvents.DroppedItemContext(itemEntity, stack, baseDecrement);
                long finalDecrement = ((BurnTickEvents.DroppedItem)BurnTickEvents.DROPPED_ITEM.invoker()).onTick(itemContext, baseDecrement);
                burnTime -= finalDecrement;
            }
            BurnTimeUtils.setCurrentBurnTime(stack, Math.max(0L, burnTime));
            itemEntity.method_6979(stack);
            if (burnTime > 0L) continue;
            class_1799 unlit = new class_1799((class_1935)Objects.requireNonNull(BurnableRegistry.getUnlitItem(stack.method_7909())), stack.method_7947());
            itemEntity.method_6979(unlit);
        }
    }

    private static void tickBurnableBlock(class_1937 world, class_2338 pos, class_2680 state, class_2248 block, Burnable burnable) {
        long burnTime = burnable.getRemainingBurnTime();
        if (burnTime <= 0L) {
            class_2248 unlit = BurnableRegistry.getUnlitBlock(state.method_26204());
            if (unlit != null && unlit != state.method_26204()) {
                class_2680 newState = IgnitionHandler.copyProperties(state, unlit.method_9564());
                world.method_8652(pos, newState, 3);
                LOGGER.debug("Extinguished {} at {}", (Object)unlit, (Object)pos);
            }
            return;
        }
        if (!BurnableRegistry.isTickingEnabled(block)) {
            return;
        }
        long baseDecrement = (long)Math.ceil(burnable.getRainMultiplier() * (BurnTimeUtils.isActuallyRainingAt(world, pos) ? 1.0 : 0.0) + burnable.getWaterMultiplier() * (world.method_8316(pos).method_15767(class_3486.field_15517) ? 1.0 : 0.0));
        if (baseDecrement == 0L) {
            baseDecrement = 1L;
        }
        BurnTickEvents.BlockContext blockContext = new BurnTickEvents.BlockContext(world, pos, baseDecrement);
        long finalDecrement = ((BurnTickEvents.Block)BurnTickEvents.BLOCK.invoker()).onTick(blockContext, baseDecrement);
        burnable.setRemainingBurnTime(burnTime - finalDecrement);
    }

    private static void tickCampfire(class_1937 world, class_2338 pos, class_2680 state, ICampfireBurnAccessor campfire) {
        long burnTime = campfire.torchesbt_getBurnTime();
        if (burnTime > 0L) {
            if (!BurnableRegistry.isTickingEnabled(class_2246.field_17350)) {
                return;
            }
            boolean isRaining = BurnTimeUtils.isActuallyRainingAt(world, pos);
            boolean isSubmerged = world.method_8316(pos).method_15767(class_3486.field_15517);
            double rainMult = BurnableRegistry.getRainMultiplier(class_2246.field_17350);
            double waterMult = BurnableRegistry.getWaterMultiplier(class_2246.field_17350);
            if (isSubmerged && waterMult == 10.0) {
                burnTime = 0L;
                LOGGER.debug("Instantly extinguished campfire at {} due to water submersion (multiplier=10)", (Object)pos);
            } else {
                double effectiveMultiplier = 1.0;
                if (isRaining) {
                    effectiveMultiplier = Math.max(effectiveMultiplier, rainMult);
                }
                if (isSubmerged && waterMult > 0.0) {
                    effectiveMultiplier = Math.max(effectiveMultiplier, waterMult);
                }
                long baseDecrement = (long)Math.ceil(effectiveMultiplier);
                BurnTickEvents.BlockContext blockContext = new BurnTickEvents.BlockContext(world, pos, baseDecrement);
                long finalDecrement = ((BurnTickEvents.Block)BurnTickEvents.BLOCK.invoker()).onTick(blockContext, baseDecrement);
                burnTime -= finalDecrement;
            }
            campfire.torchesbt_setBurnTime(Math.max(0L, burnTime));
        }
        if (burnTime <= 0L && ((Boolean)state.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(false)), 3);
        }
        if (!world.field_9236) {
            world.method_8413(pos, state, state, 3);
        }
    }

    public static void setBurnTimeOnPlacement(class_1937 world, class_2338 pos, class_2586 entity, class_1799 stack, long defaultBurnTime) {
        long burnTime = BurnTimeUtils.getCurrentBurnTime(stack);
        if (burnTime <= 0L) {
            burnTime = defaultBurnTime;
        }
        if (entity instanceof Burnable) {
            Burnable burnable = (Burnable)entity;
            burnable.setRemainingBurnTime(burnTime);
        } else if (entity instanceof ICampfireBurnAccessor) {
            ICampfireBurnAccessor campfire = (ICampfireBurnAccessor)entity;
            campfire.torchesbt_setBurnTime(burnTime);
        }
    }
}

