/*
 * Decompiled with CFR 0.152.
 */
package com.enchantedwisp.torchesbt.core.burn;

import com.enchantedwisp.torchesbt.core.BurnableRegistry;
import com.enchantedwisp.torchesbt.core.burn.Burnable;
import com.enchantedwisp.torchesbt.mixinaccess.ICampfireBurnAccessor;
import com.enchantedwisp.torchesbt.util.ConfigCache;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3486;

public class BurnTimeUtils {
    public static final String BURN_TIME_KEY = "remaining_burn";

    public static long getMaxBurnTime(class_1799 stack) {
        return BurnableRegistry.getBurnTime(stack.method_7909());
    }

    public static long getCurrentBurnTime(class_1799 stack) {
        return stack.method_7985() && Objects.requireNonNull(stack.method_7969()).method_10545(BURN_TIME_KEY) ? stack.method_7969().method_10537(BURN_TIME_KEY) : BurnTimeUtils.getMaxBurnTime(stack);
    }

    public static void setCurrentBurnTime(class_1799 stack, long burnTime) {
        stack.method_7948().method_10544(BURN_TIME_KEY, Math.min(burnTime, BurnTimeUtils.getMaxBurnTime(stack)));
    }

    public static long getCurrentBurnTime(class_2586 entity) {
        if (entity instanceof Burnable) {
            Burnable burnable = (Burnable)entity;
            return burnable.getRemainingBurnTime();
        }
        if (entity instanceof ICampfireBurnAccessor) {
            ICampfireBurnAccessor accessor = (ICampfireBurnAccessor)entity;
            return accessor.torchesbt_getBurnTime();
        }
        return 0L;
    }

    public static boolean isActuallyRainingAt(class_1937 world, class_2338 pos) {
        if (world.method_8316(pos).method_15767(class_3486.field_15517)) {
            return false;
        }
        class_1959 biome = (class_1959)world.method_23753(pos).comp_349();
        class_1959.class_1963 precipitation = biome.method_48162(pos);
        return ConfigCache.isRainExtinguishEnabled() && world.method_8419() && world.method_8311(pos) && (precipitation == class_1959.class_1963.field_9382 || precipitation == class_1959.class_1963.field_9383);
    }
}

