/*
 * Decompiled with CFR 0.152.
 */
package com.enchantedwisp.torchesbt.core.fuel;

import com.enchantedwisp.torchesbt.RealisticTorchesBT;
import com.enchantedwisp.torchesbt.api.FuelTypeAPI;
import com.enchantedwisp.torchesbt.core.BurnableRegistry;
import com.enchantedwisp.torchesbt.core.burn.Burnable;
import com.enchantedwisp.torchesbt.core.ignition.ReignitionHandler;
import com.enchantedwisp.torchesbt.mixinaccess.ICampfireBurnAccessor;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3922;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class FuelHandler {
    private static final Logger LOGGER = RealisticTorchesBT.LOGGER;

    public static void register() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (world.field_9236) {
                return class_1269.field_5811;
            }
            class_1799 stack = player.method_5998(hand);
            class_2338 pos = hitResult.method_17777();
            class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
            class_2586 entity = world.method_8321(pos);
            class_2248 block = world.method_8320(pos).method_26204();
            if (BurnableRegistry.isBurnableBlock(block)) {
                boolean isCampfire = block == class_2246.field_17350;
                boolean isLit = isCampfire ? (Boolean)world.method_8320(pos).method_11654((class_2769)class_3922.field_17352) : true;
                FuelTypeAPI.FuelType fuelType = BurnableRegistry.getFuelType(block);
                if (isLit && fuelType != null && fuelType.getFuelMap().containsKey(itemId)) {
                    long current;
                    long added = FuelTypeAPI.getFuelBurnTime(fuelType, itemId);
                    if (entity instanceof Burnable) {
                        Burnable burnable = (Burnable)entity;
                        current = burnable.getRemainingBurnTime();
                        burnable.setRemainingBurnTime(current + added);
                    } else if (entity instanceof ICampfireBurnAccessor) {
                        ICampfireBurnAccessor accessor = (ICampfireBurnAccessor)entity;
                        current = accessor.torchesbt_getBurnTime();
                        accessor.torchesbt_setBurnTime(current + added);
                        entity.method_5431();
                    } else {
                        return class_1269.field_5811;
                    }
                    world.method_8396(null, pos, class_3417.field_15145, class_3419.field_15245, 1.0f, 1.0f);
                    ReignitionHandler.consumeFuel(stack, player, hand);
                    LOGGER.debug("Fueled block {} at {} by {} using {}, {} -> {}", new Object[]{block, pos, player.method_5477().getString(), stack.method_7909(), current, current + added});
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_5811;
        });
    }
}

