/*
 * Decompiled with CFR 0.152.
 */
package com.enchantedwisp.torchesbt.core.fuel;

import com.enchantedwisp.torchesbt.RealisticTorchesBT;
import com.enchantedwisp.torchesbt.api.FuelTypeAPI;
import com.enchantedwisp.torchesbt.core.CustomFuelTypes;
import com.enchantedwisp.torchesbt.core.DefaultFuelTypes;
import com.enchantedwisp.torchesbt.util.JsonLoader;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.slf4j.Logger;

public class FuelTypeLoader {
    private static final Logger LOGGER = RealisticTorchesBT.LOGGER;
    private static boolean serverStarting = true;

    private static void reset() {
        JsonLoader.IGNITERS.clear();
        FuelTypeAPI.clear();
        LOGGER.debug("Reset fuel and igniter registries");
    }

    private static void loadAll(class_3300 manager) {
        JsonLoader.loadJsonFiles(manager, "ignite", JsonLoader.IGNITERS, "ignite_amount");
        JsonLoader.loadJsonFiles(manager, "fuel/torch", DefaultFuelTypes.TORCH.getFuelMap(), "add_time");
        JsonLoader.loadJsonFiles(manager, "fuel/lantern", DefaultFuelTypes.LANTERN.getFuelMap(), "add_time");
        JsonLoader.loadJsonFiles(manager, "fuel/campfire", DefaultFuelTypes.CAMPFIRE.getFuelMap(), "add_time");
        CustomFuelTypes.load(manager);
    }

    public static void register() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            class_3300 manager = server.method_34864();
            LOGGER.info("Server starting, loading fuels and igniters");
            FuelTypeLoader.reset();
            FuelTypeLoader.loadAll(manager);
            LOGGER.info("Finished loading all fuels and igniters");
        });
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){
            private final class_2960 RELOAD_ID = new class_2960("torchesbt", "json_loader");

            public class_2960 getFabricId() {
                return this.RELOAD_ID;
            }

            public void method_14491(class_3300 manager) {
                if (serverStarting) {
                    serverStarting = false;
                    return;
                }
                LOGGER.info("Reloading fuels and igniters");
                FuelTypeLoader.reset();
                FuelTypeLoader.loadAll(manager);
                LOGGER.info("Finished reloading all fuels and igniters");
            }
        });
        LOGGER.info("Registered fuel type loader");
    }

    private FuelTypeLoader() {
    }
}

