/*
 * Decompiled with CFR 0.152.
 */
package com.enchantedwisp.torchesbt.core.fuel;

import com.enchantedwisp.torchesbt.RealisticTorchesBT;
import com.enchantedwisp.torchesbt.api.FuelTypeAPI;
import com.enchantedwisp.torchesbt.core.BurnableRegistry;
import com.enchantedwisp.torchesbt.core.burn.BurnTimeUtils;
import com.enchantedwisp.torchesbt.util.ConfigCache;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class ItemFuelHandler {
    private static final Logger LOGGER = RealisticTorchesBT.LOGGER;

    public static void register() {
        LOGGER.info("Registered item fuel handler");
    }

    public static void handleRefuel(class_1657 player, int handlerSlotId, class_1799 fuelStack) {
        if (player.method_37908().field_9236) {
            return;
        }
        if (!ConfigCache.allowInventoryRefueling()) {
            LOGGER.debug("Inventory refueling disabled in config, ignoring refuel request");
            return;
        }
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_1703 screenHandler = serverPlayer.field_7512;
        if (handlerSlotId < 0 || handlerSlotId >= screenHandler.field_7761.size()) {
            return;
        }
        class_1735 slot = screenHandler.method_7611(handlerSlotId);
        class_1799 targetStack = slot.method_7677();
        if (targetStack.method_7960() || !BurnableRegistry.isBurnableItem(targetStack.method_7909())) {
            return;
        }
        if (targetStack.method_7947() > 1) {
            return;
        }
        class_2960 fuelItemId = class_7923.field_41178.method_10221((Object)fuelStack.method_7909());
        FuelTypeAPI.FuelType fuelType = BurnableRegistry.getFuelType(class_2248.method_9503((class_1792)targetStack.method_7909()));
        if (fuelType == null || !fuelType.getFuelMap().containsKey(fuelItemId)) {
            return;
        }
        long currentBurnTime = BurnTimeUtils.getCurrentBurnTime(targetStack);
        long maxBurnTime = BurnableRegistry.getBurnTime(targetStack.method_7909());
        long addedBurnTime = FuelTypeAPI.getFuelBurnTime(fuelType, fuelItemId);
        long newBurnTime = Math.min(currentBurnTime + addedBurnTime, maxBurnTime);
        if (newBurnTime == currentBurnTime) {
            return;
        }
        class_1937 world = player.method_37908();
        BurnTimeUtils.setCurrentBurnTime(targetStack, newBurnTime);
        serverPlayer.field_13987.method_14364((class_2596)new class_2653(screenHandler.field_7763, screenHandler.method_37421(), handlerSlotId, targetStack.method_7972()));
        if (fuelStack.method_7963()) {
            fuelStack.method_7956(1, (class_1309)player, p -> {});
            if (fuelStack.method_7960()) {
                screenHandler.method_34254(class_1799.field_8037);
                serverPlayer.field_13987.method_14364((class_2596)new class_2653(-1, screenHandler.method_37421(), -1, class_1799.field_8037));
            } else {
                screenHandler.method_34254(fuelStack);
                serverPlayer.field_13987.method_14364((class_2596)new class_2653(-1, screenHandler.method_37421(), -1, fuelStack.method_7972()));
            }
        } else {
            fuelStack.method_7934(1);
            screenHandler.method_34254(fuelStack);
            serverPlayer.field_13987.method_14364((class_2596)new class_2653(-1, screenHandler.method_37421(), -1, fuelStack.method_7972()));
        }
        world.method_8396(null, player.method_24515(), class_3417.field_15145, class_3419.field_15248, 0.8f, 0.6f);
    }
}

