/*
 * Decompiled with CFR 0.152.
 */
package com.enchantedwisp.torchesbt.mixin;

import com.enchantedwisp.torchesbt.RealisticTorchesBT;
import com.enchantedwisp.torchesbt.core.BurnableRegistry;
import com.enchantedwisp.torchesbt.core.FlameLevel;
import com.enchantedwisp.torchesbt.mixinaccess.ICampfireBurnAccessor;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3922;
import net.minecraft.class_3924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3924.class})
public abstract class CampfireBlockEntityMixin
extends class_2586
implements ICampfireBurnAccessor {
    @Unique
    private long torchesbt_burnTime = 0L;

    public CampfireBlockEntityMixin(class_2338 pos, class_2680 state) {
        super(class_2591.field_17380, pos, state);
    }

    @Override
    public long torchesbt_getBurnTime() {
        return this.torchesbt_burnTime;
    }

    @Override
    public void torchesbt_setBurnTime(long time) {
        long max = BurnableRegistry.getBurnTime(this.method_11010().method_26204());
        this.torchesbt_burnTime = Math.max(0L, Math.min(time, max));
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            class_2680 state = this.method_11010();
            FlameLevel level = FlameLevel.LOW;
            double pct = (double)this.torchesbt_burnTime / (double)max;
            if (pct > 0.5) {
                level = FlameLevel.FULL;
            } else if (pct > 0.2) {
                level = FlameLevel.MID;
            }
            this.field_11863.method_8652(this.field_11867, (class_2680)((class_2680)state.method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(this.torchesbt_burnTime > 0L))).method_11657(FlameLevel.PROPERTY, (Comparable)((Object)level)), 3);
        }
    }

    @Override
    public class_2371<class_1799> torchesbt_getItems() {
        return ((class_3924)this).method_17505();
    }

    @Inject(method={"writeNbt"}, at={@At(value="TAIL")})
    private void torchesbt_writeNbt(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10544("remaining_burn", this.torchesbt_burnTime);
    }

    @Inject(method={"readNbt"}, at={@At(value="TAIL")})
    private void torchesbt_readNbt(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10545("remaining_burn")) {
            this.torchesbt_burnTime = nbt.method_10537("remaining_burn");
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(this.torchesbt_burnTime > 0L)), 3);
                RealisticTorchesBT.LOGGER.debug("Loaded campfire at {} with burn time {}, LIT={}", new Object[]{this.field_11867, this.torchesbt_burnTime, this.torchesbt_burnTime > 0L});
            }
        }
    }

    @Inject(method={"toUpdatePacket*"}, at={@At(value="RETURN")}, cancellable=true)
    private void toUpdatePacket(CallbackInfoReturnable<class_2622> cir) {
        class_2487 nbt = this.method_38244();
        nbt.method_10544("remaining_burn", this.torchesbt_burnTime);
        cir.setReturnValue((Object)class_2622.method_39026((class_2586)this, blockEntity -> nbt));
    }

    @Inject(method={"toInitialChunkDataNbt"}, at={@At(value="RETURN")}, cancellable=true)
    private void toInitialChunkDataNbt(CallbackInfoReturnable<class_2487> cir) {
        class_2487 nbt = (class_2487)cir.getReturnValue();
        nbt.method_10544("remaining_burn", this.torchesbt_burnTime);
        cir.setReturnValue((Object)nbt);
    }
}

