/*
 * Decompiled with CFR 0.152.
 */
package com.enchantedwisp.torchesbt.mixin;

import com.enchantedwisp.torchesbt.core.BurnableRegistry;
import com.enchantedwisp.torchesbt.core.burn.BurnTimeUtils;
import java.util.Objects;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1799.class})
public class ItemStackMixin {
    @Inject(method={"isItemBarVisible"}, at={@At(value="HEAD")}, cancellable=true)
    private void isItemBarVisible(CallbackInfoReturnable<Boolean> cir) {
        class_1799 stack = (class_1799)this;
        if (BurnableRegistry.isBurnableItem(stack.method_7909())) {
            long max = BurnTimeUtils.getMaxBurnTime(stack);
            long current = BurnTimeUtils.getCurrentBurnTime(stack);
            cir.setReturnValue((Object)(current > 0L && current < max ? 1 : 0));
        }
    }

    @Inject(method={"getMaxDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void getMaxDamage(CallbackInfoReturnable<Integer> cir) {
        class_1799 stack = (class_1799)this;
        if (BurnableRegistry.isBurnableItem(stack.method_7909())) {
            cir.setReturnValue((Object)((int)BurnTimeUtils.getMaxBurnTime(stack)));
        }
    }

    @Inject(method={"getDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void getDamage(CallbackInfoReturnable<Integer> cir) {
        class_1799 stack = (class_1799)this;
        if (BurnableRegistry.isBurnableItem(stack.method_7909())) {
            long max = BurnTimeUtils.getMaxBurnTime(stack);
            long current = BurnTimeUtils.getCurrentBurnTime(stack);
            cir.setReturnValue((Object)((int)(max - current)));
        }
    }

    @Inject(method={"getItemBarColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void getItemBarColor(CallbackInfoReturnable<Integer> cir) {
        class_1799 stack = (class_1799)this;
        if (BurnableRegistry.isBurnableItem(stack.method_7909())) {
            cir.setReturnValue((Object)16753920);
        }
    }

    @Inject(method={"getItemBarStep"}, at={@At(value="HEAD")}, cancellable=true)
    private void getItemBarStep(CallbackInfoReturnable<Integer> cir) {
        class_1799 stack = (class_1799)this;
        if (BurnableRegistry.isBurnableItem(stack.method_7909())) {
            long max = BurnTimeUtils.getMaxBurnTime(stack);
            long current = BurnTimeUtils.getCurrentBurnTime(stack);
            cir.setReturnValue((Object)((int)(13.0 * (double)current / (double)max)));
        }
    }

    @Inject(method={"getMaxCount"}, at={@At(value="HEAD")}, cancellable=true)
    private void getMaxCount(CallbackInfoReturnable<Integer> cir) {
        class_1799 stack = (class_1799)this;
        if (BurnableRegistry.isBurnableItem(stack.method_7909())) {
            if (!stack.method_7985() || !Objects.requireNonNull(stack.method_7969()).method_10545("remaining_burn")) {
                cir.setReturnValue((Object)stack.method_7909().method_7882());
                return;
            }
            cir.setReturnValue((Object)stack.method_7909().method_7882());
        }
    }

    @Inject(method={"areEqual"}, at={@At(value="HEAD")}, cancellable=true)
    private static void areEqual(class_1799 stack1, class_1799 stack2, CallbackInfoReturnable<Boolean> cir) {
        if (BurnableRegistry.isBurnableItem(stack1.method_7909()) && BurnableRegistry.isBurnableItem(stack2.method_7909())) {
            if (class_1799.method_7984((class_1799)stack1, (class_1799)stack2)) {
                long burnTime2;
                long burnTime1 = BurnTimeUtils.getCurrentBurnTime(stack1);
                cir.setReturnValue((Object)(burnTime1 == (burnTime2 = BurnTimeUtils.getCurrentBurnTime(stack2)) ? 1 : 0));
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }
}

