/*
 * Decompiled with CFR 0.152.
 */
package com.enchantedwisp.torchesbt.util;

import com.enchantedwisp.torchesbt.RealisticTorchesBT;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.slf4j.Logger;

public class JsonLoader {
    public static final Map<class_2960, Integer> IGNITERS = new HashMap<class_2960, Integer>();
    private static final Logger LOGGER = RealisticTorchesBT.LOGGER;
    private static final Gson GSON = new Gson();

    public static void loadJsonFiles(class_3300 manager, String folder, Map<class_2960, Integer> targetMap, String valueKey) {
        for (class_2960 id : manager.method_14488(folder, path -> path.method_12832().endsWith(".json")).keySet()) {
            try {
                class_3298 resource = manager.getResourceOrThrow(id);
                InputStream inputStream = resource.method_14482();
                try (InputStreamReader reader = new InputStreamReader(inputStream);){
                    JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    JsonArray items = json.getAsJsonArray("items");
                    int value = json.get(valueKey).getAsInt();
                    if (items == null || value <= 0) {
                        LOGGER.warn("Skipping invalid JSON at {}: Missing or invalid items/{}", (Object)id, (Object)valueKey);
                        continue;
                    }
                    LOGGER.debug("Processing JSON at {} with {} items and {}={}", new Object[]{id, items.size(), valueKey, value});
                    for (JsonElement itemElement : items) {
                        String itemString = itemElement.getAsString();
                        boolean isTag = itemString.startsWith("#");
                        String parsedString = isTag ? itemString.substring(1) : itemString;
                        class_2960 itemId = class_2960.method_12829((String)parsedString);
                        if (itemId == null) {
                            LOGGER.warn("Invalid identifier in JSON at {}: {}", (Object)id, (Object)itemString);
                            continue;
                        }
                        if (isTag) {
                            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)itemId);
                            Optional entryList = class_7923.field_41178.method_40266(tag);
                            if (entryList.isPresent()) {
                                ((class_6885.class_6888)entryList.get()).forEach(entry -> {
                                    class_2960 entryId = class_7923.field_41178.method_10221((Object)((class_1792)entry.comp_349()));
                                    JsonLoader.putIfAbsent(entryId, value, targetMap, folder);
                                    LOGGER.debug("Added tag item {} from {} with {}={}", new Object[]{entryId, itemId, valueKey, value});
                                });
                                continue;
                            }
                            LOGGER.warn("Tag {} in JSON at {} is empty or invalid", (Object)itemId, (Object)id);
                            continue;
                        }
                        if (class_7923.field_41178.method_10250(itemId)) {
                            class_2960 entryId = class_7923.field_41178.method_10221((Object)((class_1792)class_7923.field_41178.method_10223(itemId)));
                            JsonLoader.putIfAbsent(entryId, value, targetMap, folder);
                            LOGGER.debug("Added item {} with {}={}", new Object[]{entryId, valueKey, value});
                            continue;
                        }
                        LOGGER.warn("Unknown item {} in JSON at {}", (Object)itemId, (Object)id);
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load JSON at {}: {}", (Object)id, (Object)e.getMessage());
            }
        }
        LOGGER.info("Loaded {} entries from {} JSONs", (Object)targetMap.size(), (Object)folder);
    }

    private static void putIfAbsent(class_2960 entryId, int value, Map<class_2960, Integer> targetMap, String folder) {
        if (!targetMap.containsKey(entryId)) {
            targetMap.put(entryId, value);
        } else {
            LOGGER.warn("Duplicate item {} in {} JSON, keeping first value", (Object)entryId, (Object)folder);
        }
    }
}

