package io.github.openbagtwo.lighterend.blocks;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class Fur extends class_2248 implements class_3737 {

  private static final class_2746 WATERLOGGED = class_2741.field_12508;
  public static final class_2754<class_2350> FACING = class_2741.field_12525;
  private static final EnumMap<class_2350, class_265> BOUNDING_SHAPES = Maps.newEnumMap(
      class_2350.class);

  static {
    BOUNDING_SHAPES.put(class_2350.field_11036, class_259.method_1081(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
    BOUNDING_SHAPES.put(class_2350.field_11033, class_259.method_1081(0.0, 0.5, 0.0, 1.0, 1.0, 1.0));
    BOUNDING_SHAPES.put(class_2350.field_11043, class_259.method_1081(0.0, 0.0, 0.5, 1.0, 1.0, 1.0));
    BOUNDING_SHAPES.put(class_2350.field_11035, class_259.method_1081(0.0, 0.0, 0.0, 1.0, 1.0, 0.5));
    BOUNDING_SHAPES.put(class_2350.field_11039, class_259.method_1081(0.5, 0.0, 0.0, 1.0, 1.0, 1.0));
    BOUNDING_SHAPES.put(class_2350.field_11034, class_259.method_1081(0.0, 0.0, 0.0, 0.5, 1.0, 1.0));
  }

  public Fur(class_2251 settings, class_3620 color, int luminance, boolean wet) {
    super(
        settings
            .method_31710(color)
            .method_51371()
            .method_9634()
            .method_9618()
            .method_50013()
            .method_50012(class_3619.field_15971)
            .method_9631(bs -> luminance)
            .method_50013()
            .method_9626(wet ? class_2498.field_11534 : class_2498.field_11535)
    );
    method_9590(method_9564().method_11657(WATERLOGGED, false).method_11657(FACING, class_2350.field_11036));
  }

  @Override
  public @NotNull class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos,
      class_3726 ePos) {
    return BOUNDING_SHAPES.get(state.method_11654(FACING));
  }

  @Override
  protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
    builder.method_11667(WATERLOGGED);
    builder.method_11667(FACING);
  }

  @Override
  protected class_3610 method_9545(class_2680 state) {
    return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
  }

  @Override
  public class_2680 method_9605(class_1750 ctx) {
    class_2680 blockState = super.method_9605(ctx);
    if (blockState != null) {
      class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
      blockState = blockState.method_11657(WATERLOGGED, fluidState.method_15772() == class_3612.field_15910);
      for (class_2350 direction : ctx.method_7718()) {
        blockState = blockState.method_11657(FACING, direction.method_10153());
        if (blockState.method_26184(ctx.method_8045(), ctx.method_8037())) {
          return blockState;
        }
      }
    }
    return null;
  }

  @Override
  public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
    class_2350 direction = state.method_11654(FACING);
    class_2338 blockPos = pos.method_10093(direction.method_10153());
    return method_20044(world, blockPos, direction) || world.method_8320(blockPos)
        .method_26164(class_3481.field_15503);
  }

  @Override
  public class_2680 method_9559(
      class_2680 state,
      class_4538 world,
      class_10225 tickView,
      class_2338 pos,
      class_2350 direction,
      class_2338 neighborPos,
      class_2680 neighborState,
      class_5819 random
  ) {
    if (!method_9558(state, world, pos)) {
      return class_2246.field_10124.method_9564();
    } else {
      return state;
    }
  }

  @Override
  public class_2680 method_9598(class_2680 state, class_2470 rotation) {
    return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
  }

  @Override
  public class_2680 method_9569(class_2680 state, class_2415 mirror) {
    return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
  }
}
