package io.github.openbagtwo.lighterend.blocks.entities;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.openbagtwo.lighterend.blocks.SilkMothNest;
import io.github.openbagtwo.lighterend.mobs.SilkMoth;
import io.github.openbagtwo.lighterend.registries.LighterEndBlockEntities;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndData;
import io.github.openbagtwo.lighterend.registries.LighterEndData.MothsComponent;
import io.github.openbagtwo.lighterend.registries.LighterEndMobs;
import io.github.openbagtwo.lighterend.registries.LighterEndSounds;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2358;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5712;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9279;
import net.minecraft.class_9323;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public class SilkMothNestEntity extends class_2586 {

  static final List<String> IRRELEVANT_NBT_TAGS = Arrays.asList(
      "Air",
      "drop_chances",
      "equipment",
      "Brain",
      "CanPickUpLoot",
      "DeathTime",
      "fall_distance",
      "FallFlying",
      "Fire",
      "HurtByTimestamp",
      "HurtTime",
      "LeftHanded",
      "Motion",
      "NoGravity",
      "OnGround",
      "PortalCooldown",
      "Pos",
      "Rotation",
      "sleeping_pos",
      "CannotEnterHiveTicks",
      "TicksSincePollination",
      "CropsGrownSincePollination",
      "hive_pos",
      "Passengers",
      "leash",
      "UUID"
  );
  public static final int MAX_MOTH_COUNT = 1;
  public static final int MIN_OCCUPATION_TICKS = 2400;
  private final List<Moth> moths = Lists.newArrayList();


  public SilkMothNestEntity(class_2338 pos, class_2680 state) {
    super(LighterEndBlockEntities.SILK_MOTH_NEST, pos, state);
  }

  @Override
  public void method_5431() {
    if (this.isNearFire()) {
      this.tryReleaseMoths(this.field_11863.method_8320(this.method_11016()));
    }
    super.method_5431();
  }

  public int getOccupancy() {
    return this.moths.size();
  }

  public boolean isNearFire() {
    if (this.field_11863 != null) {
      for (class_2338 blockPos : class_2338.method_10097(this.field_11867.method_10069(-1, -1, -1), this.field_11867.method_10069(1, 1, 1))) {
        if (this.field_11863.method_8320(blockPos).method_26204() instanceof class_2358) {
          return true;
        }
      }
    }
    return false;
  }

  public List<class_1297> tryReleaseMoths(class_2680 state) {
    List<class_1297> list = Lists.<class_1297>newArrayList();
    this.moths.removeIf(
        moth -> releaseMoth(this.field_11863, this.field_11867, state, moth.createData(), list, true));
    if (!list.isEmpty()) {
      super.method_5431();
    }
    return list;
  }

  public static int getFullness(class_2680 state) {
    return state.method_11654(SilkMothNest.FULLNESS);
  }

  public void tryEnterHive(SilkMoth entity) {
    if (this.moths.size() < MAX_MOTH_COUNT) {
      entity.method_5848();
      entity.method_5772();
      entity.method_5932();
      this.addMoth(MothData.of(entity));
      if (this.field_11863 != null) {

        class_2338 blockPos = this.method_11016();
        this.field_11863
            .method_43128(
                null, blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(),
                LighterEndSounds.MOTH_NEST_ENTER, class_3419.field_15245, 1.0F, 1.0F
            );
        this.field_11863.method_43276(class_5712.field_28733, blockPos,
            class_5712.class_7397.method_43286(entity, this.method_11010()));
      }

      entity.method_31472();
      super.method_5431();
    }
  }

  public void addMoth(MothData moth) {
    this.moths.add(new Moth(moth));
  }

  private static boolean releaseMoth(
      class_1937 world,
      class_2338 pos,
      class_2680 state,
      MothData moth,
      @Nullable List<class_1297> entities,
      boolean emergency
  ) {

    class_2350 direction = state.method_11654(SilkMothNest.FACING);
    class_2338 blockPos = pos.method_10093(direction);
    boolean bl = !world.method_8320(blockPos).method_26220(world, blockPos).method_1110();
    if (bl) {
      return false;
    } else {
      class_1297 entity = moth.loadEntity(world, pos);

      if (entity != null) {
        if (entity instanceof SilkMoth mothEntity) {

          if (state.method_27852(LighterEndBlocks.SILK_MOTH_NEST) && !emergency) {
            int current_fullness = getFullness(state);
            if (current_fullness < SilkMothNest.MAX_FULLNESS) {
              int additional_fullness = 1;
              if (current_fullness + additional_fullness < SilkMothNest.MAX_FULLNESS) {
                if (world.field_9229.method_43048(100) == 0) {  // 1% chance of bonus fullness
                  additional_fullness += 1;
                }
              }
              world.method_8501(pos,
                  state.method_11657(SilkMothNest.FULLNESS, current_fullness + additional_fullness));
            }
            mothEntity.resetCannotEnterHiveTicks();
          }

          if (entities != null) {
            entities.add(mothEntity);
          }

          float f = entity.method_17681();
          double d = bl ? 0.0 : 0.55 + f / 2.0F;
          double e = pos.method_10263() + 0.5 + d * direction.method_10148();
          double g = pos.method_10264() + 0.5 - entity.method_17682() / 2.0F;
          double h = pos.method_10260() + 0.5 + d * direction.method_10165();
          entity.method_5808(e, g, h, entity.method_36454(), entity.method_36455());
        }

        world.method_8396(null, pos, LighterEndSounds.MOTH_NEST_EXIT, class_3419.field_15245, 1.0F,
            1.0F);
        world.method_43276(class_5712.field_28733, pos,
            class_5712.class_7397.method_43286(entity, world.method_8320(pos)));
        return world.method_8649(entity);
      } else {
        return false;
      }
    }
  }


  private static void tickMoths(class_1937 world, class_2338 pos, class_2680 state,
      List<Moth> moths) {
    boolean bl = false;
    Iterator<Moth> iterator = moths.iterator();

    while (iterator.hasNext()) {
      Moth moth = iterator.next();
      if (moth.canExitHive()) {
        if (releaseMoth(world, pos, state, moth.createData(), null, false)) {
          bl = true;
          iterator.remove();
        }
      }
    }
    if (bl) {
      method_31663(world, pos, state);
    }
  }

  public static void serverTick(class_1937 world, class_2338 pos, class_2680 state,
      SilkMothNestEntity blockEntity) {
    tickMoths(world, pos, state, blockEntity.moths);
    if (!blockEntity.moths.isEmpty() && world.method_8409().method_43058() < 0.005) {
      double d = pos.method_10263() + 0.5;
      double e = pos.method_10264();
      double f = pos.method_10260() + 0.5;
      world.method_43128(null, d, e, f, LighterEndSounds.MOTH_NEST_WORK, class_3419.field_15245,
          1.0F, 1.0F);
    }
  }

  @Override
  protected void method_11014(class_2487 nbt, class_7225.class_7874 registries) {
    super.method_11014(nbt, registries);
    this.moths.clear();
    for (MothData data : nbt.method_67491("moths", MothData.LIST_CODEC).orElse(List.of())) {
      this.addMoth(data);
    }
  }

  @Override
  protected void method_11007(class_2487 nbt, class_7225.class_7874 registries) {
    super.method_11007(nbt, registries);
    nbt.method_67494("moths", MothData.LIST_CODEC, this.createMothData());
  }

  @Override
  protected void method_57568(class_9473 components) {
    super.method_57568(components);
    this.moths.clear();
    List<MothData> list = components.method_58695(
        LighterEndData.MOTHS, LighterEndData.MothsComponent.DEFAULT).moths();
    list.forEach(this::addMoth);
  }

  @Override
  protected void method_57567(class_9323.class_9324 builder) {
    super.method_57567(builder);
    builder.method_57840(LighterEndData.MOTHS, new MothsComponent(this.createMothData()));
  }

  @Override
  public void method_57569(class_2487 nbt) {
    super.method_57569(nbt);
    nbt.method_10551("moths");
  }

  private List<MothData> createMothData() {
    return this.moths.stream().map(Moth::createData)
        .toList();
  }

  protected static class Moth {

    private final MothData data;
    private int ticksInHive;

    protected Moth(MothData data) {
      this.data = data;
      this.ticksInHive = data.ticksInHive();
    }

    public boolean canExitHive() {
      return this.ticksInHive++ > this.data.minTicksInHive;
    }

    public MothData createData() {
      return new MothData(this.data.entityData,
          this.ticksInHive, this.data.minTicksInHive);
    }
  }

  public record MothData(class_9279 entityData, int ticksInHive, int minTicksInHive) {

    public static final Codec<MothData> CODEC = RecordCodecBuilder.create(
        instance -> instance.group(
                class_9279.field_49303.optionalFieldOf("entity_data", class_9279.field_49302).forGetter(
                    MothData::entityData),
                Codec.INT.fieldOf("ticks_in_hive").forGetter(
                    MothData::ticksInHive),
                Codec.INT.fieldOf("min_ticks_in_hive").forGetter(
                    MothData::minTicksInHive)
            )
            .apply(instance, MothData::new)
    );
    public static final Codec<List<MothData>> LIST_CODEC = CODEC.listOf();
    public static final class_9139<ByteBuf, MothData> PACKET_CODEC = class_9139.method_56436(
        class_9279.field_49305,
        MothData::entityData,
        class_9135.field_48550,
        MothData::ticksInHive,
        class_9135.field_48550,
        MothData::minTicksInHive,
        MothData::new
    );

    public static MothData create(int ticksInHive) {
      class_2487 nbtCompound = new class_2487();
      nbtCompound.method_10582("id",
          class_7923.field_41177.method_10221(LighterEndMobs.SILK_MOTH.mob).toString());
      return new MothData(
          class_9279.method_57456(nbtCompound),
          ticksInHive,
          MIN_OCCUPATION_TICKS
      );
    }

    @Nullable
    public class_1297 loadEntity(class_1937 world, class_2338 pos) {
      class_2487 nbtCompound = this.entityData.method_57461();
      SilkMothNestEntity.IRRELEVANT_NBT_TAGS.forEach(
          nbtCompound::method_10551);
      class_1297 entity = class_1299.method_17842(nbtCompound, world, class_3730.field_52444,
          entityx -> entityx);
      if (entity != null && entity.method_5864().method_20210(LighterEndTags.MOTH_NEST_INHABITORS)) {
        entity.method_5875(true);
        if (entity instanceof SilkMoth mothEntity) {
          mothEntity.setHive(pos);
          tickEntity(this.ticksInHive, mothEntity);
        }
        return entity;
      } else {
        return null;
      }
    }

    private static void tickEntity(int ticksInHive, SilkMoth moth) {
      int i = moth.method_5618();
      if (i < 0) {
        moth.method_5614(Math.min(0, i + ticksInHive));
      } else if (i > 0) {
        moth.method_5614(Math.max(0, i - ticksInHive));
      }

      moth.method_6476(Math.max(0, moth.method_29270() - ticksInHive));
    }

    public static MothData of(class_1297 entity) {
      class_2487 nbtCompound = new class_2487();
      entity.method_5662(nbtCompound);
      SilkMothNestEntity.IRRELEVANT_NBT_TAGS.forEach(nbtCompound::method_10551);

      return new MothData(class_9279.method_57456(nbtCompound), 0, MIN_OCCUPATION_TICKS);
    }
  }
}
