package io.github.openbagtwo.lighterend.config;


import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.config.Config.ConfigException;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_353;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_7172;

public class ConfigScreen extends class_4667 {

  private class_353 widgets;

  private static String REQUIRES_RESTART = "Restart Minecraft to apply changes";

  public ConfigScreen(class_437 previous) {
    super(previous, class_310.method_1551().field_1690, class_2561.method_30163(LighterEnd.MOD_NAME));
  }

  @Override
  protected void method_60325() {
    if (this.field_51824 != null) {
      this.field_51824.method_20406(
          class_7172.method_41750(
              "Generate Modded Biomes",
              class_7172.method_42717(class_2561.method_30163(REQUIRES_RESTART)),
              LighterEnd.CONFIG.generateBiomes,
              (value) -> {
                LighterEnd.CONFIG.generateBiomes = value;
              }
          )
      );
      this.field_51824.method_20406(
          class_7172.method_41750(
              "Generate Ores",
              class_7172.method_42717(class_2561.method_30163(
                  "Whether to generate redstone and quartz ores (including in vanilla biomes)"
                      + "\n\n" + REQUIRES_RESTART)),
              LighterEnd.CONFIG.generateOres,
              (value) -> {
                LighterEnd.CONFIG.generateOres = value;
              }
          )
      );
      this.field_51824.method_20406(
          class_7172.method_41751(
              "Play Modded Music in End Biomes",
              LighterEnd.CONFIG.playEndBiomeMusic,
              (value) -> {
                LighterEnd.CONFIG.playEndBiomeMusic = value;
              }
          )
      );
      this.field_51824.method_20406(
          new class_7172<>(
              "End Gravity",
              class_7172.method_42717(
                  class_2561.method_30163("Set to 1.0 for vanilla" + "\n\n" + REQUIRES_RESTART)
              ),
              (optionText, value) -> class_315.method_41783(optionText,
                  class_2561.method_30163(String.valueOf(.01 * value))),
              new class_7172.class_7174(5, 100, false),
              class_3532.method_15357(100 * LighterEnd.CONFIG.endGravity),
              value -> {
                LighterEnd.CONFIG.endGravity = 0.01 * value;
              }
          )
      );
      this.field_51824.method_20406(
          class_7172.method_41750(
              "Disable End Gravity While Flying",
              class_7172.method_42717(
                  class_2561.method_30163(
                      "Lowering gravity nerfs unpowered glide speed otherwise"
                          + "\n\n" + REQUIRES_RESTART
                  )
              ),
              LighterEnd.CONFIG.disableEndGravityWhileFlying,
              (value) -> {
                LighterEnd.CONFIG.disableEndGravityWhileFlying = value;
              }
          )
      );
      this.field_51824.method_20406(
          class_7172.method_41751(
              "Modded Plants Can Only Grow in The End",
              LighterEnd.CONFIG.endPlantsOnlyGrowInTheEnd, (value) -> {
                LighterEnd.CONFIG.endPlantsOnlyGrowInTheEnd = value;
              }
          )
      );
      this.field_51824.method_20406(
          class_7172.method_41750(
              "Mod Music Discs Can Be Found in End Cities",
              class_7172.method_42717(class_2561.method_30163(REQUIRES_RESTART)),
              LighterEnd.CONFIG.musicDiscsInEndCities, (value) -> {
                LighterEnd.CONFIG.musicDiscsInEndCities = value;
              }
          )
      );
      this.field_51824.method_20406(
          class_7172.method_41751(
              "Use Custom Fishing Loot in The End",
              LighterEnd.CONFIG.customEndFishing, (value) -> {
                LighterEnd.CONFIG.customEndFishing = value;
              }
          )
      );
      this.field_51824.method_20406(
          class_7172.method_41750(
              "Custom Aquatic Vegetation Bonemealing",
              class_7172.method_42717(class_2561.method_30163(
                  "With this option enabled, bonemealing underwater in The End will grow modded flora"
              )),
              LighterEnd.CONFIG.bonemealUnderwaterInEndMakesEndVegetation, (value) -> {
                LighterEnd.CONFIG.bonemealUnderwaterInEndMakesEndVegetation = value;
              }
          )
      );
    }
  }

  @Override
  public void method_25432() {
    try {
      LighterEnd.CONFIG.writeConfigToFile();
    } catch (ConfigException e) {
      LighterEnd.LOGGER.error(String.valueOf(e));
    }
  }
}
