package io.github.openbagtwo.lighterend.datagen;

import io.github.openbagtwo.lighterend.registries.LighterEndMobs;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1299;
import net.minecraft.class_3483;
import net.minecraft.class_7225.class_7874;

public class MobTagProvider extends FabricTagProvider.EntityTypeTagProvider {

  public MobTagProvider(
      FabricDataOutput dataOutput,
      CompletableFuture<class_7874> registriesFuture
  ) {
    super(dataOutput, registriesFuture);
  }

  @Override
  protected void method_10514(class_7874 wrapperLookup) {
    method_10512(class_3483.field_48289).add(
        LighterEndMobs.SILK_MOTH.mob,
        LighterEndMobs.DRAGONFLY.mob,
        LighterEndMobs.CHORUS_CRAB.mob
    );
    method_10512(class_3483.field_48288).add(
        LighterEndMobs.END_FISH.mob,
        LighterEndMobs.CUBOZOA.mob
    );
    method_10512(class_3483.field_29824).add(
        LighterEndMobs.END_FISH.mob,
        LighterEndMobs.CUBOZOA.mob
    );

    method_10512(class_3483.field_38697).add(
        LighterEndMobs.DRAGONFLY.mob,
        LighterEndMobs.END_SLIME.mob
    );

    method_10512(class_3483.field_50105).add(
        LighterEndMobs.END_SLIME.mob
    );

    method_10512(class_3483.field_45066).add(
        LighterEndMobs.END_SLIME.mob
    );
    // I like the idea of these weird-looking fish scaring pufferfish
//    getOrCreateTagBuilder(EntityTypeTags.NOT_SCARY_FOR_PUFFERFISH).add(
//        LighterEndMobs.END_FISH.mob,
//        LighterEndMobs.CUBOZOA.mob
//    );
    method_10512(LighterEndTags.MOTH_NEST_INHABITORS).add(
        LighterEndMobs.SILK_MOTH.mob
    );

    method_10512(LighterEndTags.IGNORES_GEYSER_BUBBLES).add(
        LighterEndMobs.END_FISH.mob,
        LighterEndMobs.CUBOZOA.mob
    );

    method_10512(LighterEndTags.IMMUNE_TO_MURKWEED).add(
        class_1299.field_6128,
        class_1299.field_6078
    );

  }
}
