package io.github.openbagtwo.lighterend.misc;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.blocks.Signs;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndSounds;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.object.builder.v1.block.type.BlockSetTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.block.type.WoodTypeBuilder;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1822;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2378;
import net.minecraft.class_2399;
import net.minecraft.class_2440;
import net.minecraft.class_2465;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2766;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_4970.class_2251;
import net.minecraft.class_5321;
import net.minecraft.class_7707;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8177;

public class Wood {

  public static class WoodSet {

    public final String baseName;
    public final class_4719 woodType;
    public final class_2248 log;
    public final class_2248 strippedLog;
    public final class_2248 wood;
    public final class_2248 strippedWood;
    public final class_2248 planks;
    public final class_2248 slab;
    public final class_2248 stairs;
    public final class_2248 door;
    public final class_2248 trapdoor;
    public final class_2248 fence;
    public final class_2248 gate;
    public final class_2248 button;
    public final class_2248 pressurePlate;
    public final class_2248 ladder;
    public final class_2248 sign;
    public final class_2248 wallSign;
    public final class_2248 hangingSign;
    public final class_2248 wallHangingSign;
    // public final Block stool;
    public final List<class_2248> blocks;
    private final class_3620 woodColor;
    private final class_2498 logSounds;

    public WoodSet(String name, class_3620 barkColor, class_3620 woodColor) {
      this.baseName = name;
      this.woodColor = woodColor;

      this.woodType = createWoodType(baseName);
      this.logSounds = createWoodSoundGroup(baseName + "_log");

      log = LighterEndBlocks.register(baseName + "_log",
          settings -> new class_2465(
              applyLogSettings(
                  settings.method_51520(
                      state -> state.method_11654(class_2465.field_11459) == class_2350.class_2351.field_11052 ? woodColor
                          : barkColor
                  )
              )
          )
      );
      strippedLog = LighterEndBlocks.register(baseName + "_stripped_log",
          settings -> new class_2465(
              applyLogSettings(settings.method_31710(woodColor))
          )
      );
      wood = LighterEndBlocks.register(baseName + "_wood",
          settings -> new class_2465(
              applyLogSettings(settings.method_31710(barkColor))
          )
      );
      strippedWood = LighterEndBlocks.register(baseName + "_stripped_wood",
          settings -> new class_2465(
              applyLogSettings(settings.method_31710(woodColor))));

      StrippableBlockRegistry.register(log, strippedLog);
      StrippableBlockRegistry.register(wood, strippedWood);

      planks = LighterEndBlocks.register(
          baseName + "_planks",
          settings -> new class_2248(applyPlankSettings(settings))
      );
      slab = LighterEndBlocks.register(
          baseName + "_slab",
          settings -> new class_2482(applyPlankSettings(settings))
      );
      stairs = LighterEndBlocks.register(
          baseName + "_stairs",
          settings -> new class_2510(planks.method_9564(), applyPlankSettings(settings))
      );

      door = LighterEndBlocks.register(
          baseName + "_door",
          settings -> new class_2323(
              woodType.comp_1300(),
              settings.method_31710(planks.method_26403())
                  .method_51368(class_2766.field_12651)
                  .method_9632(3.0F)
                  .method_22488()
                  .method_50013()
                  .method_50012(class_3619.field_15971)
          )
      );
      trapdoor = LighterEndBlocks.register(
          baseName + "_trapdoor",
          settings -> new class_2533(
              woodType.comp_1300(),
              settings.method_31710(planks.method_26403())
                  .method_51368(class_2766.field_12651)
                  .method_9632(3.0F)
                  .method_22488()
                  .method_26235(class_2246::method_26114)
                  .method_50013()
          )
      );
      fence = LighterEndBlocks.register(
          baseName + "_fence",
          settings -> new class_2354(
              settings.method_31710(planks.method_26403())
                  .method_51368(class_2766.field_12651)
                  .method_9629(2.0F, 3.0F)
                  .method_50013()
                  .method_9626(woodType.comp_1301())
          )
      );
      gate = LighterEndBlocks.register(
          baseName + "_fence_gate",
          settings -> new class_2349(
              woodType,
              settings
                  .method_31710(planks.method_26403())
                  .method_51369()
                  .method_51368(class_2766.field_12651)
                  .method_9629(2.0F, 3.0F)
                  .method_50013()
          )
      );
      button = LighterEndBlocks.register(
          baseName + "_button",
          settings -> new class_2269(
              woodType.comp_1300(),
              30,
              settings.method_9634().method_9632(0.5F).method_50012(class_3619.field_15971)
          )
      );
      pressurePlate = LighterEndBlocks.register(
          baseName + "_pressure_plate",
          settings -> new class_2440(
              woodType.comp_1300(),
              settings.method_31710(planks.method_26403())
                  .method_51369()
                  .method_51368(class_2766.field_12651)
                  .method_9634()
                  .method_9632(0.5F)
                  .method_50013()
                  .method_50012(class_3619.field_15971)
          )
      );
      ladder = LighterEndBlocks.register(
          baseName + "_ladder",
          settings -> new class_2399(
              settings
                  .method_9632(0.4F)
                  .method_9626(class_2498.field_11532)
                  .method_22488()
                  .method_50012(class_3619.field_15971)
          )
      );
      sign = LighterEndBlocks.register(
          baseName + "_sign",
          settings -> new Signs.LighterEndStandingSignBlock(
              woodType,
              settings.method_31710(planks.method_26403())
          ),
          false
      );
      wallSign = LighterEndBlocks.register(
          baseName + "_wall_sign",
          settings -> new Signs.LighterEndWallSignBlock(
              woodType,
              settings
                  .method_31710(planks.method_26403())
                  .method_63502(sign.method_26162())
                  .method_63501(sign.method_63499())
          ),
          false
      );
      class_2378.method_10230(
          class_7923.field_41178,
          LighterEnd.of(baseName + "_sign"),
          new class_1822(
              sign,
              wallSign,
              new class_1792.class_1793().method_7889(16).method_63686(
                  class_5321.method_29179(class_7924.field_41197, LighterEnd.of(baseName + "_sign"))
              ).method_63685()
          )
      );
      hangingSign = LighterEndBlocks.register(
          baseName + "_hanging_sign",
          settings -> new Signs.LighterEndCeilingHangingSignBlock(
              woodType,
              settings.method_31710(planks.method_26403())
          ),
          false
      );
      wallHangingSign = LighterEndBlocks.register(
          baseName + "_wall_hanging_sign",
          settings -> new Signs.LighterEndWallHangingSignBlock(
              woodType,
              settings
                  .method_63502(hangingSign.method_26162())
                  .method_63501(hangingSign.method_63499())
                  .method_31710(planks.method_26403())
          ),
          false
      );
      class_2378.method_10230(
          class_7923.field_41178,
          LighterEnd.of(baseName + "_hanging_sign"),
          new class_7707(
              hangingSign,
              wallHangingSign,
              new class_1792.class_1793().method_7889(16).method_63686(
                  class_5321.method_29179(class_7924.field_41197, LighterEnd.of(baseName + "_hanging_sign"))
              ).method_63685()
          )
      );

      for (class_2248 block : Arrays.asList(log, strippedLog, wood, strippedWood)) {
        FlammableBlockRegistry.getDefaultInstance().add(block, 5, 5);
      }
      for (class_2248 block : Arrays.asList(planks, slab, stairs, fence, gate)) {
        FlammableBlockRegistry.getDefaultInstance().add(block, 5, 20);
      }

      blocks = Arrays.asList(
          log,
          strippedLog,
          wood,
          strippedWood,
          planks,
          slab,
          stairs,
          door,
          trapdoor,
          fence,
          gate,
          button,
          pressurePlate,
          ladder,
          sign,
          hangingSign
      );
    }

    public class_2251 applyLogSettings(class_2251 settings) {
      return settings
          .method_51368(class_2766.field_12651)
          .method_9626(this.logSounds)
          .method_9632(2.0F)
          .method_50013();
    }

    public class_2251 applyPlankSettings(class_2251 settings) {
      return settings
          .method_31710(this.woodColor)
          .method_51368(class_2766.field_12651)
          .method_9626(this.woodType.comp_1301())
          .method_9629(2.0F, 3.0F)
          .method_50013();
    }
  }

  public static class_4719 createWoodType(String name) {
    class_2498 soundGroup = createWoodSoundGroup(name);

    return (new WoodTypeBuilder())
        .soundGroup(soundGroup)
        .hangingSignSoundGroup(createWoodSoundGroup(name + "_hanging_sign"))
        .fenceGateCloseSound(LighterEndSounds.register("block." + name + "_fence_gate.close"))
        .fenceGateOpenSound(LighterEndSounds.register("block." + name + "_fence_gate.open"))
        .register(LighterEnd.of(name), createWoodSetType(name, soundGroup));
  }

  private static class_8177 createWoodSetType(String name, class_2498 soundGroup) {
    return (new BlockSetTypeBuilder())
        .openableByHand(true)
        .openableByWindCharge(true)
        .buttonActivatedByArrows(true)
        .pressurePlateActivationRule(class_8177.class_2441.field_11361)
        .soundGroup(soundGroup)
        .doorCloseSound(LighterEndSounds.register("block." + name + "_door.close"))
        .doorOpenSound(LighterEndSounds.register("block." + name + "_door.open"))
        .trapdoorCloseSound(LighterEndSounds.register("block." + name + "_trapdoor.close"))
        .trapdoorCloseSound(LighterEndSounds.register("block." + name + "_trapdoor.open"))
        .pressurePlateClickOffSound(
            LighterEndSounds.register("block." + name + "_pressure_plate.click_off")
        ).pressurePlateClickOnSound(
            LighterEndSounds.register("block." + name + "_pressure_plate.click_on")
        ).register(LighterEnd.of(name));

  }

  private static class_2498 createWoodSoundGroup(String name) {
    return new class_2498(
        1.0F,
        1.0F,
        LighterEndSounds.register("block." + name + ".break"),
        LighterEndSounds.register("block." + name + ".step"),
        LighterEndSounds.register("block." + name + ".place"),
        LighterEndSounds.register("block." + name + ".hit"),
        LighterEndSounds.register("block." + name + ".fall")
    );
  }

}
