package io.github.openbagtwo.lighterend.mixin;

import io.github.openbagtwo.lighterend.LighterEnd;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public abstract class GravityEffectsMixin extends GravityStrengthMixin {

  @Shadow
  public abstract double getAttributeValue(class_6880<class_1320> attribute);

  @Inject(method = "getUnsafeFallDistance", at = @At("RETURN"), cancellable = true)
  public void increaseSafeFallHeight(CallbackInfoReturnable<Double> cir) {
    double endGravity = LighterEnd.CONFIG.getEndGravity();
    if (endGravity >= 0.0 && class_7134.field_37668.equals(
        this.getWorld().method_40134().method_40230().orElse(null))) {
      cir.setReturnValue(cir.getReturnValue()
          - (1 - endGravity) * this.getAttributeValue(class_5134.field_49079)
          / endGravity);
    }
  }

  @Inject(method = "computeFallDamage", at = @At("RETURN"), cancellable = true)
  public void decreaseFallDamage(CallbackInfoReturnable<Integer> cir) {
    double endGravity = LighterEnd.CONFIG.getEndGravity();
    if (endGravity >= 0.0 && class_7134.field_37668.equals(
        this.getWorld().method_40134().method_40230().orElse(null))) {

      // TODO: this is bad math—replace with a full @Override that recomputes the value
      cir.setReturnValue(class_3532.method_15357(cir.getReturnValue() * endGravity));
    }
  }


}
