package io.github.openbagtwo.lighterend.mixin;

import io.github.openbagtwo.lighterend.registries.LighterEndData;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_9299;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1799.class)
public abstract class TooltipMixin {

  @Shadow
  public abstract <T extends class_9299> void appendComponentTooltip(
      class_9331<T> componentType,
      class_1792.class_9635 context,
      class_10712 displayComponent,
      Consumer<class_2561> textConsumer,
      class_1836 type
  );

  @Inject(method = "appendTooltip", at = @At("HEAD"))
  public void appendLighterEndTooltips(
      class_1792.class_9635 context,
      class_10712 displayComponent,
      @Nullable class_1657 player,
      class_1836 type,
      Consumer<class_2561> textConsumer,
      CallbackInfo ci
  ) {
    this.appendComponentTooltip(
        LighterEndData.MOTHS,
        context,
        displayComponent,
        textConsumer,
        type
    );
    this.appendComponentTooltip(
        LighterEndData.SILK_LEVEL,
        context,
        displayComponent,
        textConsumer,
        type
    );
    this.appendComponentTooltip(
        LighterEndData.TOTEM_TARGET,
        context,
        displayComponent,
        textConsumer,
        type
    );

  }

}
