package io.github.openbagtwo.lighterend.mobs.renderers;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.mobs.Cubozoa;
import io.github.openbagtwo.lighterend.mobs.EntityModels;
import io.github.openbagtwo.lighterend.mobs.models.CubozoaModel;
import io.github.openbagtwo.lighterend.mobs.states.CubozoaRenderState;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4606;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_927;

public class CubozoaRenderer extends
    class_927<Cubozoa, CubozoaRenderState, CubozoaModel> {

  private static final List<class_2960> TEXTURES = Arrays.asList(
      LighterEnd.of("textures/entity/cubozoa/cubozoa.png"),
      LighterEnd.of("textures/entity/cubozoa/cubozoa_sulphur.png")
  );
  private static final List<class_1921> GLOW = Arrays.asList(
      class_1921.method_23026(
          LighterEnd.of("textures/entity/cubozoa/cubozoa_glow.png")),
      class_1921.method_23026(
          LighterEnd.of("textures/entity/cubozoa/cubozoa_sulphur_glow.png"))
  );

  public CubozoaRenderer(class_5617.class_5618 ctx) {
    super(ctx, new CubozoaModel(ctx.method_32167(EntityModels.CUBOZOA_MODEL)), 0.5F);
    this.method_4046(new class_4606<>(this) {
      @Override
      public class_1921 method_23193() {
        return GLOW.get(0);
      }

      @Override
      public void render(
          class_4587 matrices,
          class_4597 vertexConsumers,
          int light,
          CubozoaRenderState state,
          float limbAngle,
          float limbDistance
      ) {
        class_4588 vertexConsumer = vertexConsumers.getBuffer(
            GLOW.get(state.variant % GLOW.size())
        );
        this.method_17165()
            .renderOverride(
                matrices,
                vertexConsumer,
                15728640,
                class_4608.field_21444,
                0xffffffff
            );
      }
    });
  }


  @Override
  public CubozoaRenderState method_55269() {
    return new CubozoaRenderState();
  }

  @Override
  public class_2960 getTexture(CubozoaRenderState state) {
    return TEXTURES.get(state.variant % TEXTURES.size());
  }

  @Override
  public void updateRenderState(Cubozoa fish, CubozoaRenderState state, float f) {
    super.method_62355(fish, state, f);
    state.variant = fish.getVariant();
  }
}
