package io.github.openbagtwo.lighterend.mobs.renderers;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.blocks.Polypore;
import io.github.openbagtwo.lighterend.mobs.GlossyMooshroom;
import io.github.openbagtwo.lighterend.mobs.states.GlossyMooshroomRenderState;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_10042;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4606;
import net.minecraft.class_4608;
import net.minecraft.class_560;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_922;
import net.minecraft.class_9990;

public class GlossyMooshroomRenderer extends
    class_9990<GlossyMooshroom, class_10042, class_560> {

  private static final List<class_2960> TEXTURES = Arrays.asList(
      LighterEnd.of("textures/entity/glossy_mooshroom.png")
  );

  private static final List<class_1921> GLOW = Arrays.asList(
      class_1921.method_23026(
          LighterEnd.of("textures/entity/glossy_mooshroom_glow.png")
      )
  );

  public GlossyMooshroomRenderer(class_5617.class_5618 context) {
    super(context, new class_560(context.method_32167(class_5602.field_27615)),
        new class_560(context.method_32167(class_5602.field_53835)), 0.7F);
    this.method_4046(new PolyporeFeatureRenderer(this, context.method_43337()));
    this.method_4046(
        new class_4606<>(this) {
          @Override
          public class_1921 method_23193() {
            return GLOW.get(0);
          }

          @Override
          public void render(
              class_4587 matrices,
              class_4597 vertexConsumers,
              int light,
              class_10042 state,
              float limbAngle,
              float limbDistance
          ) {
            if (state instanceof GlossyMooshroomRenderState cowState) {
              class_4588 vertexConsumer = vertexConsumers.getBuffer(
                  GLOW.get(cowState.variant % GLOW.size())
              );
              this.method_17165()
                  .method_62100(
                      matrices,
                      vertexConsumer,
                      15728640,
                      class_4608.field_21444,
                      0xffffffff
                  );
            }
          }
        });
  }

  public class_2960 method_3885(class_10042 state) {
    int variant = 0;
    if (state instanceof GlossyMooshroomRenderState cowState) {
      variant = cowState.variant;
    }
    return TEXTURES.get(variant % TEXTURES.size());
  }

  public GlossyMooshroomRenderState method_55269() {
    return new GlossyMooshroomRenderState();
  }

  public void updateRenderState(GlossyMooshroom cow, class_10042 state, float f) {
    super.method_62355(cow, state, f);
    if (state instanceof GlossyMooshroomRenderState cowState) {
      cowState.variant = cow.getVariant();
      cowState.sheared = cow.isSheared();
    }
  }

  public static class PolyporeFeatureRenderer extends
      class_3887<class_10042, class_560> {

    private final class_776 blockRenderManager;

    public PolyporeFeatureRenderer(
        class_3883<class_10042, class_560> context,
        class_776 blockRenderManager) {
      super(context);
      this.blockRenderManager = blockRenderManager;
    }

    public void render(
        class_4587 matrixStack,
        class_4597 vertexConsumerProvider,
        int i,
        class_10042 state,
        float f,
        float g
    ) {
      if (state instanceof GlossyMooshroomRenderState cowState) {
        if (!cowState.sheared && !cowState.field_53457) {
          boolean bl = cowState.field_53462 && cowState.field_53333;
          if (!cowState.field_53333 || bl) {
            class_2680 polyphore;
            if (cowState.variant == 0) {
              polyphore = LighterEndBlocks.AURANT_POLYPORE.method_9564().method_11657(
                  Polypore.FACING, class_2350.field_11039
              );
            } else if (cowState.variant == 1) {
              polyphore = LighterEndBlocks.PURPLE_POLYPORE.method_9564().method_11657(
                  Polypore.FACING, class_2350.field_11039
              );
            } else {
              return;
            }
            int j = class_922.method_23622(cowState, 0.0F);
            class_1087 blockStateModel = this.blockRenderManager.method_3349(polyphore);
            matrixStack.method_22903();
            matrixStack.method_22905(-0.3F, -0.5F, 0.5F);
            matrixStack.method_46416(-2.25F, -1.5F, 0);
            this.renderMushroom(matrixStack, vertexConsumerProvider, i, bl, polyphore, j,
                blockStateModel);
            matrixStack.method_22909();

            blockStateModel = this.blockRenderManager.method_3349(
                polyphore.method_11657(Polypore.FACING, class_2350.field_11034)
            );
            matrixStack.method_22903();
            matrixStack.method_22905(0.3F, -0.5F, -0.5F);
            matrixStack.method_46416(-2.25F, -1.5F, -0.2F);
            this.renderMushroom(matrixStack, vertexConsumerProvider, i, bl, polyphore, j,
                blockStateModel);
            matrixStack.method_22909();
          }
        }
      }
    }

    private void renderMushroom(
        class_4587 matrices,
        class_4597 vertexConsumers,
        int light,
        boolean renderAsModel,
        class_2680 mushroomState,
        int overlay,
        class_1087 mushroomModel
    ) {
      if (renderAsModel) {
        class_778.method_3367(
            matrices.method_23760(),
            vertexConsumers.getBuffer(
                class_1921.method_23287(class_1059.field_5275)),
            mushroomModel, 0.0F, 0.0F, 0.0F, light, overlay
        );
      } else {
        this.blockRenderManager.method_3353(
            mushroomState,
            matrices,
            vertexConsumers,
            light,
            overlay
        );
      }
    }
  }
}
