package io.github.openbagtwo.lighterend.utils;

import java.util.Map;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class PosInfo implements Comparable<PosInfo> {

  private static final class_2680 AIR = class_2246.field_10124.method_9564();
  private final Map<class_2338, PosInfo> blocks;
  private final Map<class_2338, PosInfo> add;
  private final class_2338 pos;
  private class_2680 state;

  private static final ThreadLocal<class_2339> TL_POS = ThreadLocal.withInitial(() -> new class_2339());

  public static PosInfo create(Map<class_2338, PosInfo> blocks, Map<class_2338, PosInfo> add,
      class_2338 pos) {
    return new PosInfo(blocks, add, pos);
  }

  private PosInfo(Map<class_2338, PosInfo> blocks, Map<class_2338, PosInfo> add, class_2338 pos) {
    this.blocks = blocks;
    this.add = add;
    this.pos = pos;
    blocks.put(pos, this);
  }

  public static int downRay(class_1936 world, class_2338 pos, int maxDist) {
    int length = 0;
    for (int j = 1; j < maxDist && (world.method_22347(pos.method_10087(j))); j++) {
      length++;
    }
    return length;
  }

  public static int downRayRep(class_1936 world, class_2338 pos, int maxDist) {
    final class_2339 POS = TL_POS.get();
    POS.method_10101(pos);
    for (int j = 1; j < maxDist && (world.method_8320(POS)).method_45474(); j++) {
      POS.method_33098(POS.method_10264() - 1);
    }
    return pos.method_10264() - POS.method_10264();
  }

  public static int upRay(class_1936 world, class_2338 pos, int maxDist) {
    int length = 0;
    for (int j = 1; j < maxDist && (world.method_22347(pos.method_10086(j))); j++) {
      length++;
    }
    return length;
  }

  public class_2680 getState() {
    return state;
  }

  public class_2680 getState(class_2338 pos) {
    PosInfo info = blocks.get(pos);
    if (info == null) {
      info = add.get(pos);
      return info == null ? AIR : info.getState();
    }
    return info.getState();
  }

  public void setState(class_2680 state) {
    this.state = state;
  }

  public void setState(class_2338 pos, class_2680 state) {
    PosInfo info = blocks.get(pos);
    if (info != null) {
      info.setState(state);
    }
  }

  public class_2680 getState(class_2350 dir) {
    PosInfo info = blocks.get(pos.method_10093(dir));
    if (info == null) {
      info = add.get(pos.method_10093(dir));
      return info == null ? AIR : info.getState();
    }
    return info.getState();
  }

  public class_2680 getState(class_2350 dir, int distance) {
    PosInfo info = blocks.get(pos.method_10079(dir, distance));
    if (info == null) {
      return AIR;
    }
    return info.getState();
  }

  public class_2680 getStateUp() {
    return getState(class_2350.field_11036);
  }

  public class_2680 getStateDown() {
    return getState(class_2350.field_11033);
  }

  @Override
  public int hashCode() {
    return pos.hashCode();
  }

  @Override
  public boolean equals(Object obj) {
    if (!(obj instanceof PosInfo)) {
      return false;
    }
    return pos.equals(((PosInfo) obj).pos);
  }

  @Override
  public int compareTo(PosInfo info) {
    return this.pos.method_10264() - info.pos.method_10264();
  }

  public class_2338 getPos() {
    return pos;
  }

  public void setBlockPos(class_2338 pos, class_2680 state) {
    PosInfo info = new PosInfo(blocks, add, pos);
    info.state = state;
    add.put(pos, info);
  }
}
