package io.github.openbagtwo.lighterend.utils;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3341;
import net.minecraft.class_5281;
import net.minecraft.class_7923;

public class StructureWorld {

  private final Map<class_1923, Part> parts = Maps.newHashMap();
  private class_1923 lastPos;
  private Part lastPart;
  private int minX = Integer.MAX_VALUE;
  private int minY = Integer.MAX_VALUE;
  private int minZ = Integer.MAX_VALUE;
  private int maxX = Integer.MIN_VALUE;
  private int maxY = Integer.MIN_VALUE;
  private int maxZ = Integer.MIN_VALUE;

  public StructureWorld() {
  }

  public StructureWorld(class_2487 tag) {
    minX = tag.method_68083("minX", Integer.MAX_VALUE);
    maxX = tag.method_68083("maxX", Integer.MIN_VALUE);
    minY = tag.method_68083("minY", Integer.MAX_VALUE);
    maxY = tag.method_68083("maxY", Integer.MIN_VALUE);
    minZ = tag.method_68083("minZ", Integer.MAX_VALUE);
    maxZ = tag.method_68083("maxZ", Integer.MIN_VALUE);

    class_2499 map = tag.method_10554("parts").get();
    map.forEach((element) -> {
      class_2487 compound = (class_2487) element;
      Part part = new Part(compound);
      int x = compound.method_10550("x").get();
      int z = compound.method_10550("z").get();
      parts.put(new class_1923(x, z), part);
    });
  }

  public void setBlock(class_2338 pos, class_2680 state) {
    class_1923 cPos = new class_1923(pos);

    if (cPos.equals(lastPos)) {
      lastPart.addBlock(pos, state);
      return;
    }

    Part part = parts.get(cPos);
    if (part == null) {
      part = new Part();
      parts.put(cPos, part);

      if (cPos.field_9181 < minX) {
        minX = cPos.field_9181;
      }
      if (cPos.field_9181 > maxX) {
        maxX = cPos.field_9181;
      }
      if (cPos.field_9180 < minZ) {
        minZ = cPos.field_9180;
      }
      if (cPos.field_9180 > maxZ) {
        maxZ = cPos.field_9180;
      }
    }
    if (pos.method_10264() < minY) {
      minY = pos.method_10264();
    }
    if (pos.method_10264() > maxY) {
      maxY = pos.method_10264();
    }
    part.addBlock(pos, state);

    lastPos = cPos;
    lastPart = part;
  }

  public boolean placeChunk(class_5281 world, class_1923 chunkPos) {
    Part part = parts.get(chunkPos);
    if (part != null) {
      class_2791 chunk = world.method_8392(chunkPos.field_9181, chunkPos.field_9180);
      part.placeChunk(chunk);
      return true;
    }
    return false;
  }

  public class_2487 toBNT() {
    class_2487 tag = new class_2487();
    tag.method_10569("minX", minX);
    tag.method_10569("maxX", maxX);
    tag.method_10569("minY", minY);
    tag.method_10569("maxY", maxY);
    tag.method_10569("minZ", minZ);
    tag.method_10569("maxZ", maxZ);
    class_2499 map = new class_2499();
    tag.method_10566("parts", map);
    parts.forEach((pos, part) -> {
      map.add(part.toNBT(pos.field_9181, pos.field_9180));
    });
    return tag;
  }

  public class_3341 getBounds() {
    if (minX == Integer.MAX_VALUE || maxX == Integer.MIN_VALUE || minZ == Integer.MAX_VALUE
        || maxZ == Integer.MIN_VALUE) {
      return class_3341.method_14665();
    }
    return new class_3341(minX << 4, minY, minZ << 4, (maxX << 4) | 15, maxY, (maxZ << 4) | 15);
  }

  private static final class Part {

    Map<class_2338, class_2680> blocks = Maps.newHashMap();

    public Part() {
    }

    public Part(class_2487 tag) {
      class_2499 map = tag.method_10554("blocks").get();
      class_2499 map2 = tag.method_10554("states").get();
      class_2680[] states = new class_2680[map2.size()];
      for (int i = 0; i < states.length; i++) {
        states[i] = class_2512.method_10681(
            class_7923.field_41175.method_40276(),
            (class_2487) map2.get(i)
        );
      }

      map.forEach((element) -> {
        class_2487 block = (class_2487) element;
        class_2338 pos = toBlockPos(block, "pos").orElse(null);
        if (pos != null) {
          int stateID = block.method_10550("state").get();
          class_2680 state =
              stateID < states.length ? states[stateID] : class_2248.method_9531(stateID);
          blocks.put(pos, state);
        }
      });
    }

    void addBlock(class_2338 pos, class_2680 state) {
      class_2338 inner = new class_2338(pos.method_10263() & 15, pos.method_10264(), pos.method_10260() & 15);
      blocks.put(inner, state);
    }

    void placeChunk(class_2791 chunk) {
      blocks.forEach((pos, state) -> {
        chunk.method_66480(pos, state);
      });
    }

    class_2487 toNBT(int x, int z) {
      class_2487 tag = new class_2487();
      tag.method_10569("x", x);
      tag.method_10569("z", z);
      class_2499 map = new class_2499();
      tag.method_10566("blocks", map);
      class_2499 stateMap = new class_2499();
      tag.method_10566("states", stateMap);

      int[] id = new int[1];
      Map<class_2680, Integer> states = Maps.newHashMap();

      blocks.forEach((pos, state) -> {
        int stateID = states.getOrDefault(states, -1);
        if (stateID < 0) {
          stateID = id[0]++;
          states.put(state, stateID);
          stateMap.add(class_2512.method_10686(state));
        }

        class_2487 block = new class_2487();
        block.method_10566("pos", fromBlockPos(pos));
        block.method_10569("state", stateID);
        map.add(block);
      });

      return tag;
    }
  }

  public static Optional<class_2338> toBlockPos(class_2487 compoundTag, String string) {
    int[] is = compoundTag.method_10561(string).get();
    return is.length == 3 ? Optional.of(new class_2338(is[0], is[1], is[2])) : Optional.empty();
  }

  public static class_2495 fromBlockPos(class_2338 blockPos) {
    return new class_2495(new int[]{blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()});
  }
}
