package io.github.openbagtwo.lighterend.utils.math.sdf;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.github.openbagtwo.lighterend.utils.Flags;
import io.github.openbagtwo.lighterend.utils.PosInfo;
import io.github.openbagtwo.lighterend.utils.StructureWorld;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_5425;

public abstract class SDF {

  private final List<Function<PosInfo, class_2680>> postProcesses = Lists.newArrayList();
  private Function<class_2680, Boolean> canReplace = (state) -> state.method_45474();

  public abstract float getDistance(float x, float y, float z);

  public abstract class_2680 getBlockState(class_2338 pos);

  public SDF addPostProcess(Function<PosInfo, class_2680> postProcess) {
    this.postProcesses.add(postProcess);
    return this;
  }

  public SDF setReplaceFunction(Function<class_2680, Boolean> canReplace) {
    this.canReplace = canReplace;
    return this;
  }

  public void fillRecursive(class_5425 world, class_2338 start) {
    Map<class_2338, PosInfo> mapWorld = Maps.newHashMap();
    Map<class_2338, PosInfo> addInfo = Maps.newHashMap();
    Set<class_2338> blocks = Sets.newHashSet();
    Set<class_2338> ends = Sets.newHashSet();
    Set<class_2338> add = Sets.newHashSet();
    ends.add(new class_2338(0, 0, 0));
    boolean run = true;

    class_2339 bPos = new class_2339();

    while (run) {
      for (class_2338 center : ends) {
        for (class_2350 dir : class_2350.values()) {
          bPos.method_10101(center).method_10098(dir);
          class_2338 wpos = bPos.method_10081(start);

          if (!blocks.contains(bPos) && canReplace.apply(world.method_8320(wpos))) {
            if (this.getDistance(bPos.method_10263(), bPos.method_10264(), bPos.method_10260()) < 0) {
              class_2680 state = getBlockState(wpos);
              PosInfo.create(mapWorld, addInfo, wpos).setState(state);
              add.add(bPos.method_10062());
            }
          }
        }
      }

      blocks.addAll(ends);
      ends.clear();
      ends.addAll(add);
      add.clear();

      run &= !ends.isEmpty();
    }

    List<PosInfo> infos = new ArrayList<PosInfo>(mapWorld.values());
    if (infos.size() > 0) {
      Collections.sort(infos);
      postProcesses.forEach((postProcess) -> {
        infos.forEach((info) -> {
          info.setState(postProcess.apply(info));
        });
      });
      infos.forEach((info) -> {
        world.method_8652(info.getPos(), info.getState(), Flags.SILENT);
      });

      infos.clear();
      infos.addAll(addInfo.values());
      Collections.sort(infos);
      postProcesses.forEach((postProcess) -> {
        infos.forEach((info) -> {
          info.setState(postProcess.apply(info));
        });
      });
      infos.forEach((info) -> {
        if (canReplace.apply(world.method_8320(info.getPos()))) {
          world.method_8652(info.getPos(), info.getState(), Flags.SILENT);
        }
      });
    }
  }

  public void fillArea(class_5425 world, class_2338 center, class_238 box) {
    Map<class_2338, PosInfo> mapWorld = Maps.newHashMap();
    Map<class_2338, PosInfo> addInfo = Maps.newHashMap();

    class_2339 mut = new class_2339();
    for (int y = (int) box.field_1322; y <= box.field_1325; y++) {
      mut.method_33098(y);
      for (int x = (int) box.field_1323; x <= box.field_1320; x++) {
        mut.method_33097(x);
        for (int z = (int) box.field_1321; z <= box.field_1324; z++) {
          mut.method_33099(z);
          if (canReplace.apply(world.method_8320(mut))) {
            class_2338 fpos = mut.method_10059(center);
            if (this.getDistance(fpos.method_10263(), fpos.method_10264(), fpos.method_10260()) < 0) {
              PosInfo.create(mapWorld, addInfo, mut.method_10062()).setState(getBlockState(mut));
            }
          }
        }
      }
    }

    List<PosInfo> infos = new ArrayList<PosInfo>(mapWorld.values());
    if (infos.size() > 0) {
      Collections.sort(infos);
      postProcesses.forEach((postProcess) -> {
        infos.forEach((info) -> {
          info.setState(postProcess.apply(info));
        });
      });
      infos.forEach((info) -> {
        world.method_8652(info.getPos(), info.getState(), Flags.SILENT);
      });

      infos.clear();
      infos.addAll(addInfo.values());
      Collections.sort(infos);
      postProcesses.forEach((postProcess) -> {
        infos.forEach((info) -> {
          info.setState(postProcess.apply(info));
        });
      });
      infos.forEach((info) -> {
        if (canReplace.apply(world.method_8320(info.getPos()))) {
          world.method_8652(info.getPos(), info.getState(), Flags.SILENT);
        }
      });
    }
  }

  public void fillRecursiveIgnore(class_5425 world, class_2338 start,
      Function<class_2680, Boolean> ignore) {
    Map<class_2338, PosInfo> mapWorld = Maps.newHashMap();
    Map<class_2338, PosInfo> addInfo = Maps.newHashMap();
    Set<class_2338> blocks = Sets.newHashSet();
    Set<class_2338> ends = Sets.newHashSet();
    Set<class_2338> add = Sets.newHashSet();
    ends.add(new class_2338(0, 0, 0));
    boolean run = true;

    class_2339 bPos = new class_2339();

    while (run) {
      for (class_2338 center : ends) {
        for (class_2350 dir : class_2350.values()) {
          bPos.method_10101(center).method_10098(dir);
          class_2338 wpos = bPos.method_10081(start);
          class_2680 state = world.method_8320(wpos);
          boolean ign = ignore.apply(state);
          if (!blocks.contains(bPos) && (ign || canReplace.apply(state))) {
            if (this.getDistance(bPos.method_10263(), bPos.method_10264(), bPos.method_10260()) < 0) {
              PosInfo.create(mapWorld, addInfo, wpos).setState(ign ? state : getBlockState(bPos));
              add.add(bPos.method_10062());
            }
          }
        }
      }

      blocks.addAll(ends);
      ends.clear();
      ends.addAll(add);
      add.clear();

      run &= !ends.isEmpty();
    }

    List<PosInfo> infos = new ArrayList<PosInfo>(mapWorld.values());
    if (infos.size() > 0) {
      Collections.sort(infos);
      postProcesses.forEach((postProcess) -> {
        infos.forEach((info) -> {
          info.setState(postProcess.apply(info));
        });
      });
      infos.forEach((info) -> {
        world.method_8652(info.getPos(), info.getState(), Flags.SILENT);
      });

      infos.clear();
      infos.addAll(addInfo.values());
      Collections.sort(infos);
      postProcesses.forEach((postProcess) -> {
        infos.forEach((info) -> {
          info.setState(postProcess.apply(info));
        });
      });
      infos.forEach((info) -> {
        if (canReplace.apply(world.method_8320(info.getPos()))) {
          world.method_8652(info.getPos(), info.getState(), Flags.SILENT);
        }
      });
    }
  }

  public void fillRecursive(StructureWorld world, class_2338 start) {
    Map<class_2338, PosInfo> mapWorld = Maps.newHashMap();
    Map<class_2338, PosInfo> addInfo = Maps.newHashMap();
    Set<class_2338> blocks = Sets.newHashSet();
    Set<class_2338> ends = Sets.newHashSet();
    Set<class_2338> add = Sets.newHashSet();
    ends.add(new class_2338(0, 0, 0));
    boolean run = true;

    class_2339 bPos = new class_2339();

    while (run) {
      for (class_2338 center : ends) {
        for (class_2350 dir : class_2350.values()) {
          bPos.method_10101(center).method_10098(dir);
          class_2338 wpos = bPos.method_10081(start);

          if (!blocks.contains(bPos)) {
            if (this.getDistance(bPos.method_10263(), bPos.method_10264(), bPos.method_10260()) < 0) {
              class_2680 state = getBlockState(wpos);
              PosInfo.create(mapWorld, addInfo, wpos).setState(state);
              add.add(bPos.method_10062());
            }
          }
        }
      }

      blocks.addAll(ends);
      ends.clear();
      ends.addAll(add);
      add.clear();

      run &= !ends.isEmpty();
    }

    List<PosInfo> infos = new ArrayList<PosInfo>(mapWorld.values());
    Collections.sort(infos);
    postProcesses.forEach((postProcess) -> {
      infos.forEach((info) -> {
        info.setState(postProcess.apply(info));
      });
    });
    infos.forEach((info) -> {
      world.setBlock(info.getPos(), info.getState());
    });

    infos.clear();
    infos.addAll(addInfo.values());
    Collections.sort(infos);
    postProcesses.forEach((postProcess) -> {
      infos.forEach((info) -> {
        info.setState(postProcess.apply(info));
      });
    });
    infos.forEach((info) -> {
      world.setBlock(info.getPos(), info.getState());
    });
  }

  public Set<class_2338> getPositions(class_5425 world, class_2338 start) {
    Set<class_2338> blocks = Sets.newHashSet();
    Set<class_2338> ends = Sets.newHashSet();
    Set<class_2338> add = Sets.newHashSet();
    ends.add(new class_2338(0, 0, 0));
    boolean run = true;

    class_2339 bPos = new class_2339();

    while (run) {
      for (class_2338 center : ends) {
        for (class_2350 dir : class_2350.values()) {
          bPos.method_10101(center).method_10098(dir);
          class_2338 wpos = bPos.method_10081(start);
          class_2680 state = world.method_8320(wpos);
          if (!blocks.contains(wpos) && canReplace.apply(state)) {
            if (this.getDistance(bPos.method_10263(), bPos.method_10264(), bPos.method_10260()) < 0) {
              add.add(bPos.method_10062());
            }
          }
        }
      }

      ends.forEach((end) -> blocks.add(end.method_10081(start)));
      ends.clear();
      ends.addAll(add);
      add.clear();

      run &= !ends.isEmpty();
    }

    return blocks;
  }

  public abstract static class Primitive extends SDF {

    protected Function<class_2338, class_2680> placerFunction;

    public Primitive setBlock(Function<class_2338, class_2680> placerFunction) {
      this.placerFunction = placerFunction;
      return this;
    }

    public Primitive setBlock(class_2680 state) {
      this.placerFunction = (pos) -> {
        return state;
      };
      return this;
    }

    public Primitive setBlock(class_2248 block) {
      this.placerFunction = (pos) -> {
        return block.method_9564();
      };
      return this;
    }

    public class_2680 getBlockState(class_2338 pos) {
      return placerFunction.apply(pos);
    }
  }

  public abstract static class UnaryOperator extends SDF {

    protected SDF source;

    public UnaryOperator setSource(SDF source) {
      this.source = source;
      return this;
    }

    @Override
    public class_2680 getBlockState(class_2338 pos) {
      return source.getBlockState(pos);
    }
  }

  public abstract static class BinaryOperator extends SDF {

    protected SDF sourceA;
    protected SDF sourceB;
    protected boolean firstValue;

    public BinaryOperator setSourceA(SDF sourceA) {
      this.sourceA = sourceA;
      return this;
    }

    public BinaryOperator setSourceB(SDF sourceB) {
      this.sourceB = sourceB;
      return this;
    }

    protected void selectValue(float a, float b) {
      firstValue = a < b;
    }

    @Override
    public class_2680 getBlockState(class_2338 pos) {
      if (firstValue) {
        return sourceA.getBlockState(pos);
      } else {
        return sourceB.getBlockState(pos);
      }
    }
  }
}
