package io.github.openbagtwo.lighterend.world.features;

import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.utils.Flags;
import io.github.openbagtwo.lighterend.utils.MiscUtils;
import io.github.openbagtwo.lighterend.utils.PosInfo;
import io.github.openbagtwo.lighterend.utils.math.MathUtils;
import io.github.openbagtwo.lighterend.utils.math.sdf.SDF;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFRotate;
import io.github.openbagtwo.lighterend.utils.math.sdf.primitives.SDFHexPrism;
import net.minecraft.class_2338;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.joml.Vector3f;

public class AuroraCrystalFormation extends class_3031<class_3111> {

  public AuroraCrystalFormation() {
    super(class_3111.field_24893);
  }

  @Override
  public boolean method_13151(class_5821<class_3111> featureConfig) {
    final class_5819 random = featureConfig.method_33654();
    class_2338 pos = featureConfig.method_33655();
    final class_5281 world = featureConfig.method_33652();
    int maxY = pos.method_10264() + PosInfo.upRay(world, pos, 16);
    int minY = pos.method_10264() - PosInfo.downRay(world, pos, 16);

    if (maxY - minY < 10) {
      return false;
    }

    int height = class_3532.method_15395(random, 5, 25);

    pos = new class_2338(
        pos.method_10263(),
        class_3532.method_15395(random, minY, minY + height / 2),
        pos.method_10260());

    SDF prism = new SDFHexPrism().setHeight(height)
        .setRadius(class_3532.method_15344(random, 1.7F, 3F))
        .setBlock(LighterEndBlocks.AURORA_CRYSTAL);
    Vector3f vec = MathUtils.randomHorizontal(random);
    prism = new SDFRotate().setRotation(vec, random.method_43057()).setSource(prism);
    prism.setReplaceFunction((state) ->
        state.method_26164(LighterEndTags.END_STONES)
            || state.method_26164(LighterEndTags.END_SOIL)
            || MiscUtils.replaceableOrPlant(state)
            || state.method_26164(class_3481.field_15503));
    prism.fillRecursive(world, pos);
    world.method_8652(pos, LighterEndBlocks.AURORA_CRYSTAL.method_9564(), Flags.SILENT);

    return true;
  }
}
