package io.github.openbagtwo.lighterend.world.gen;

import static net.minecraft.class_6686.field_35222;
import static net.minecraft.class_6686.field_36342;
import static net.minecraft.class_6686.field_36341;
import static net.minecraft.class_6686.method_39055;
import static net.minecraft.class_6686.method_39047;
import static net.minecraft.class_6686.method_39049;
import static net.minecraft.class_6686.method_39053;
import static net.minecraft.class_6686.method_39050;

import com.mojang.datafixers.util.Pair;
import io.github.openbagtwo.lighterend.config.Config;
import io.github.openbagtwo.lighterend.registries.LighterEndBiomes;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.world.LighterEndPlacedFeatures;
import io.github.openbagtwo.lighterend.world.gen.noise.NoiseParameters;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.TheEndBiomes;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2893;
import net.minecraft.class_2893.class_2895;
import net.minecraft.class_2960;
import net.minecraft.class_4766;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6686.class_6708;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class LighterEndWorldGen {

  public static class_1966 addBiomesToNoiseSource(
      class_6544.class_6547<class_6880<class_1959>> defaultBiomes,
      class_7871<class_1959> context
  ) {
    List<Pair<class_6544.class_4762, class_6880<class_1959>>> biomeParams = new ArrayList<>();
    biomeParams.addAll(
        List.of(
            Pair.of(class_6544.method_38118(
                class_6544.class_6546.method_38120(0),
                class_6544.class_6546.method_38120(0.3F),
                class_6544.class_6546.method_38120(0.3F),
                class_6544.class_6546.method_38120(0),
                class_6544.class_6546.method_38120(0),
                class_6544.class_6546.method_38120(-0.5F),
                0.0F
            ), context.method_46747(LighterEndBiomes.BLOSSOM_FOREST)),
            Pair.of(class_6544.method_38118(
                class_6544.class_6546.method_38121(0, 1),
                class_6544.class_6546.method_38120(0.5F),
                class_6544.class_6546.method_38120(0.5F),
                class_6544.class_6546.method_38121(0, 1),
                class_6544.class_6546.method_38121(-1, 1),
                class_6544.class_6546.method_38121(-1, 1),
                0.3F
            ), context.method_46747(LighterEndBiomes.UMBRELLA_JUNGLE)),
            Pair.of(class_6544.method_38118(
                class_6544.class_6546.method_38121(0, 1),
                class_6544.class_6546.method_38121(-0.5F, -0.2F),
                class_6544.class_6546.method_38121(-1, 0),
                class_6544.class_6546.method_38121(-1, 1),
                class_6544.class_6546.method_38121(-1.4F, 1),
                class_6544.class_6546.method_38121(-1, 1),
                0.48F
            ), context.method_46747(LighterEndBiomes.SHADOW_FOREST)),
            Pair.of(class_6544.method_38118(
                class_6544.class_6546.method_38121(-1, 1),
                class_6544.class_6546.method_38121(0, 1),
                class_6544.class_6546.method_38121(0.5F, 1),
                class_6544.class_6546.method_38121(0.8F, 1),
                class_6544.class_6546.method_38120(0),
                class_6544.class_6546.method_38121(-1, 1),
                0.0F
            ), context.method_46747(LighterEndBiomes.MEGALAKE)),
            Pair.of(class_6544.method_38118(
                class_6544.class_6546.method_38121(-1, 1),
                class_6544.class_6546.method_38121(-1, -0.5F),
                class_6544.class_6546.method_38121(-1, 1),
                class_6544.class_6546.method_38120(0),
                class_6544.class_6546.method_38120(0),
                class_6544.class_6546.method_38121(-0.2F, 0.2F),
                0.01F
            ), context.method_46747(LighterEndBiomes.UMBRA_VALLEY)),
            Pair.of(class_6544.method_38118(
                class_6544.class_6546.method_38121(-1, 1),
                class_6544.class_6546.method_38121(-0.5F, 1),
                class_6544.class_6546.method_38121(-1, 1),
                class_6544.class_6546.method_38121(0.25F, 1),
                class_6544.class_6546.method_38121(-1.4F, 1),
                class_6544.class_6546.method_38121(-1, 1),
                0.42F
            ), context.method_46747(LighterEndBiomes.SULPHUR_SPRINGS)),
            Pair.of(class_6544.method_38118(
                class_6544.class_6546.method_38121(-0.5F, 0.2F),
                class_6544.class_6546.method_38121(0.5F, 1),
                class_6544.class_6546.method_38121(0.5F, 1),
                class_6544.class_6546.method_38121(0, 0.5F),
                class_6544.class_6546.method_38120(0),
                class_6544.class_6546.method_38121(-1F, 1F),
                0.4F
            ), context.method_46747(LighterEndBiomes.FOGGY_MUSHROOMLANDS)),
            Pair.of(class_6544.method_38118(
                class_6544.class_6546.method_38121(-1, 0),
                class_6544.class_6546.method_38120(1),
                class_6544.class_6546.method_38121(0.3F, 1),
                class_6544.class_6546.method_38121(-1, -0.15F),
                class_6544.class_6546.method_38121(-1.4F, 1),
                class_6544.class_6546.method_38121(-1, 1),
                0.1F
            ), context.method_46747(LighterEndBiomes.STARFIELD)),
            Pair.of(class_6544.method_38118(
                class_6544.class_6546.method_38121(-1, 1),
                class_6544.class_6546.method_38121(-1, 1),
                class_6544.class_6546.method_38121(-1, 1),
                class_6544.class_6546.method_38121(0.5F, 1),
                class_6544.class_6546.method_38121(-1.4F, 0),
                class_6544.class_6546.method_38121(-0.5F, 0.5F),
                0.3F
            ), context.method_46747(LighterEndBiomes.GLOWING_GRASSLAND))
        )
    );
    biomeParams.addAll(defaultBiomes.method_38128());

    return class_4766.method_49501(new class_6544.class_6547<>(biomeParams));

  }

  public static void modifyWorldGen(Config config) {
    if (!config.generateBiomes()) {
      return;
    }
    TheEndBiomes.addHighlandsBiome(LighterEndBiomes.GLOWING_GRASSLAND, 2.0);
    TheEndBiomes.addMidlandsBiome(LighterEndBiomes.GLOWING_GRASSLAND,
        LighterEndBiomes.GLOWING_GRASSLAND, 2.0);
    TheEndBiomes.addSmallIslandsBiome(LighterEndBiomes.GLOWING_GRASSLAND, 1.0);

    TheEndBiomes.addHighlandsBiome(LighterEndBiomes.BLOSSOM_FOREST, 1.0);

    TheEndBiomes.addHighlandsBiome(LighterEndBiomes.SHADOW_FOREST, 1.0);

    TheEndBiomes.addHighlandsBiome(LighterEndBiomes.FOGGY_MUSHROOMLANDS, 0.5);

    TheEndBiomes.addHighlandsBiome(LighterEndBiomes.UMBRELLA_JUNGLE, 1.0);
    TheEndBiomes.addMidlandsBiome(LighterEndBiomes.UMBRELLA_JUNGLE,
        LighterEndBiomes.UMBRELLA_JUNGLE, 1.0);

    TheEndBiomes.addHighlandsBiome(LighterEndBiomes.UMBRA_VALLEY, 1.0);
    TheEndBiomes.addMidlandsBiome(LighterEndBiomes.UMBRA_VALLEY,
        LighterEndBiomes.UMBRA_VALLEY, 1.0);

    TheEndBiomes.addHighlandsBiome(LighterEndBiomes.SULPHUR_SPRINGS, 1.0);
    TheEndBiomes.addMidlandsBiome(LighterEndBiomes.SULPHUR_SPRINGS,
        LighterEndBiomes.SULPHUR_SPRINGS, 1.0);

    TheEndBiomes.addHighlandsBiome(LighterEndBiomes.MEGALAKE, 1.0);

    TheEndBiomes.addSmallIslandsBiome(LighterEndBiomes.STARFIELD, 0.1);
    for (class_5321<class_1959> parentBiome : List.of(
        class_1972.field_9442,
        LighterEndBiomes.GLOWING_GRASSLAND,
        LighterEndBiomes.FOGGY_MUSHROOMLANDS,
        LighterEndBiomes.UMBRA_VALLEY,
        LighterEndBiomes.MEGALAKE,
        LighterEndBiomes.SULPHUR_SPRINGS
    )) {
      TheEndBiomes.addBarrensBiome(parentBiome, LighterEndBiomes.STARFIELD, 0.18);
      TheEndBiomes.addBarrensBiome(parentBiome, class_1972.field_9465, 1);
    }
  }

  public static void addIceStars(Config config) {
    if (!config.generateBiomes()) {
      return;
    }
    List<class_5321<class_1959>> barrensBiomes = new ArrayList<>();
    barrensBiomes.add(class_1972.field_9465);
    try {
      barrensBiomes.add(
          class_5321.method_29179(class_7924.field_41236, class_2960.method_60655("nullscape", "void_barrens"))
      );
    } catch (NullPointerException ignored) {
    }

    for (class_5321<class_6796> star : LighterEndPlacedFeatures.BARRENS_ICE_STARS) {
      BiomeModifications.addFeature(
          BiomeSelectors.includeByKey(barrensBiomes),
          class_2893.class_2895.field_13173,
          star
      );
    }
  }

  public static void addJadestoneBlobs(Config config) {
    if (!config.generateBiomes()) {
      return;
    }
    List<class_5321<class_1959>> biomes = new ArrayList<>();
    biomes.add(class_1972.field_9442);
    try {
      biomes.add(
          class_5321.method_29179(class_7924.field_41236, class_2960.method_60655("nullscape", "crystal_peaks"))
      );
    } catch (NullPointerException ignored) {
    }

    for (class_5321<class_6796> blob : LighterEndPlacedFeatures.JADESTONE_BLOBS_BM) {
      BiomeModifications.addFeature(
          BiomeSelectors.includeByKey(biomes),
          class_2895.field_13176,
          blob
      );
    }
  }

  public static void addOres(Config config) {
    if (!config.generateOres()) {
      return;
    }
    List<class_5321<class_1959>> endStoneBiomes = new ArrayList<>();
    endStoneBiomes.addAll(List.of(
            LighterEndBiomes.GLOWING_GRASSLAND,
            LighterEndBiomes.BLOSSOM_FOREST,
            LighterEndBiomes.UMBRELLA_JUNGLE,
            LighterEndBiomes.MEGALAKE,
            LighterEndBiomes.FOGGY_MUSHROOMLANDS,
            LighterEndBiomes.SULPHUR_SPRINGS,
            class_1972.field_9442,
            class_1972.field_9447,
            class_1972.field_9457
        )
    );

    List<class_5321<class_1959>> umbralithBiomes = new ArrayList<>();
    umbralithBiomes.add(LighterEndBiomes.UMBRA_VALLEY);

    try {
      endStoneBiomes.add(
          class_5321.method_29179(class_7924.field_41236, class_2960.method_60655("nullscape", "crystal_peaks"))
      );
      endStoneBiomes.add(
          class_5321.method_29179(class_7924.field_41236, class_2960.method_60655("nullscape", "shadowlands"))
      );
    } catch (NullPointerException ignored) {
    }

    BiomeModifications.addFeature(
        BiomeSelectors.includeByKey(endStoneBiomes),
        class_2895.field_13176,
        LighterEndPlacedFeatures.END_STONE_REDSTONE_ORE
    );
    BiomeModifications.addFeature(
        BiomeSelectors.includeByKey(endStoneBiomes),
        class_2895.field_13176,
        LighterEndPlacedFeatures.END_STONE_QUARTZ_ORE
    );
    BiomeModifications.addFeature(
        BiomeSelectors.includeByKey(umbralithBiomes),
        class_2895.field_13176,
        LighterEndPlacedFeatures.UMBRALITH_REDSTONE_ORE
    );
    BiomeModifications.addFeature(
        BiomeSelectors.includeByKey(umbralithBiomes),
        class_2895.field_13176,
        LighterEndPlacedFeatures.UMBRALITH_QUARTZ_ORE
    );
  }

  public static class_6708 updateSurfaceRules() {
    return method_39050(
        method_39049(
            field_35222,
            method_39050(
                method_39049(
                    method_39055(
                        LighterEndBiomes.BLOSSOM_FOREST,
                        LighterEndBiomes.UMBRELLA_JUNGLE,
                        LighterEndBiomes.GLOWING_GRASSLAND,
                        LighterEndBiomes.FOGGY_MUSHROOMLANDS,
                        LighterEndBiomes.SHADOW_FOREST
                    ),
                    method_39050(
                        method_39049(
                            method_39053(NoiseParameters.END_MOSS_SURFACE, -0.5, 0.5),
                            method_39047(LighterEndBlocks.END_MOSS.method_9564())
                        )
                    )
                )
            )
        ),
        method_39049(
            field_36342,
            method_39050(
                method_39049(
                    method_39055(
                        LighterEndBiomes.UMBRA_VALLEY
                    ),
                    method_39050(
                        method_39049(
                            method_39053(NoiseParameters.VIOLECITE_SURFACE, -0.05, 0.05),
                            method_39047(LighterEndBlocks.VIOLECITE.baseBlock.method_9564())
                        ),
                        method_39047(LighterEndBlocks.UMBRALITH.baseBlock.method_9564())
                    )
                )
            )
        ),
        method_39049(
            field_36341,
            method_39050(
                method_39049(
                    method_39055(
                        LighterEndBiomes.SULPHUR_SPRINGS
                    ),
                    method_39050(
                        method_39049(
                            method_39053(NoiseParameters.SULPHUR_SURFACE, -0.3, 0.3),
                            method_39047(LighterEndBlocks.BORNITE.baseBlock.method_9564())
                        ),
                        method_39047(class_2246.field_10471.method_9564())
                    )
                )
            )
        )
    );
  }

}
