/*
 * Decompiled with CFR 0.152.
 */
package io.github.openbagtwo.lighterend.blocks;

import com.google.common.collect.Maps;
import io.github.openbagtwo.lighterend.blocks.Sapling;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import java.util.Map;
import net.minecraft.class_10225;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2402;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3621;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.jetbrains.annotations.Nullable;

public class EndLotus
extends class_2248 {
    private static final class_265 SHAPE_OUTLINE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    private static final class_265 SHAPE_COLLISION = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public EndLotus(class_4970.class_2251 settings) {
        super(settings.method_31710(class_3620.field_16030).method_51368(class_2766.field_12651).method_9626(class_2498.field_11547).method_9632(0.2f).method_50013().method_50012(class_3619.field_15971).method_22488().method_9618().method_9631(bs -> 15));
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (!this.method_9558(state, world, pos)) {
            tickView.method_64310(pos, (class_2248)this, 1);
        }
        return state;
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!state.method_26184((class_4538)world, pos)) {
            world.method_22352(pos, true);
        }
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return state.method_27852(LighterEndBlocks.END_LOTUS_STEM);
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE_OUTLINE;
    }

    public class_265 method_9549(class_2680 state, class_1922 view, class_2338 pos, class_3726 ePos) {
        return SHAPE_COLLISION;
    }

    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return new class_1799((class_1935)LighterEndBlocks.END_LOTUS_SEED);
    }

    private static boolean canGrow(class_1936 world, class_2338 pos) {
        if (!world.method_8320(pos).method_26227().method_15772().equals(class_3612.field_15910.method_15751())) {
            return false;
        }
        class_2338.class_2339 bpos = new class_2338.class_2339();
        bpos.method_10101((class_2382)pos);
        while (world.method_8320((class_2338)bpos).method_26227().method_15772().equals(class_3612.field_15910.method_15751())) {
            bpos.method_33098(bpos.method_10264() + 1);
        }
        return world.method_22347((class_2338)bpos) && world.method_22347(bpos.method_10084());
    }

    public static enum Shape implements class_3542
    {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;

        private Shape(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class EndLotusFeature
    extends class_3031<class_3111> {
        public EndLotusFeature() {
            super(class_3111.field_24893);
        }

        public boolean method_13151(class_5821<class_3111> featureConfig) {
            class_2338 pos = featureConfig.method_33655();
            class_5281 world = featureConfig.method_33652();
            class_5819 random = featureConfig.method_33654();
            if (EndLotus.canGrow((class_1936)world, pos)) {
                class_2680 startLeaf = (class_2680)LighterEndBlocks.END_LOTUS_STEM.method_9564().method_11657((class_2769)Stem.LEAF, (Comparable)Boolean.valueOf(true));
                class_2680 roots = (class_2680)((class_2680)LighterEndBlocks.END_LOTUS_STEM.method_9564().method_11657(Stem.SHAPE, (Comparable)((Object)Shape.BOTTOM))).method_11657((class_2769)Stem.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                class_2680 stem = LighterEndBlocks.END_LOTUS_STEM.method_9564();
                class_2680 flower = LighterEndBlocks.END_LOTUS_FLOWER.method_9564();
                world.method_8652(pos, roots, 18);
                class_2338.class_2339 bpos = new class_2338.class_2339().method_10101((class_2382)pos);
                bpos.method_33098(bpos.method_10264() + 1);
                while (world.method_8316((class_2338)bpos).method_15771()) {
                    world.method_8652((class_2338)bpos, (class_2680)stem.method_11657((class_2769)Stem.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 18);
                    bpos.method_33098(bpos.method_10264() + 1);
                }
                int height = random.method_43056() ? 0 : (random.method_43056() ? 1 : (random.method_43056() ? 1 : -1));
                Shape shape = height == 0 ? Shape.TOP : Shape.MIDDLE;
                class_2350 dir = class_2350.class_2353.field_11062.method_10183(random);
                class_2338 leafCenter = bpos.method_10062().method_10093(dir);
                if (this.hasLeaf(world, leafCenter)) {
                    this.generateLeaf(world, leafCenter);
                    world.method_8652((class_2338)bpos, (class_2680)((class_2680)startLeaf.method_11657(Stem.SHAPE, (Comparable)((Object)shape))).method_11657(Stem.FACING, (Comparable)dir), 18);
                } else {
                    world.method_8652((class_2338)bpos, (class_2680)stem.method_11657(Stem.SHAPE, (Comparable)((Object)shape)), 18);
                }
                bpos.method_33098(bpos.method_10264() + 1);
                for (int i = 1; i <= height; ++i) {
                    if (!world.method_22347((class_2338)bpos)) {
                        bpos.method_33098(bpos.method_10264() - 1);
                        world.method_8652((class_2338)bpos, flower, 18);
                        bpos.method_33098(bpos.method_10264() - 1);
                        stem = world.method_8320((class_2338)bpos);
                        world.method_8652((class_2338)bpos, (class_2680)stem.method_11657(Stem.SHAPE, (Comparable)((Object)Shape.TOP)), 18);
                        return true;
                    }
                    world.method_8652((class_2338)bpos, stem, 18);
                    bpos.method_33098(bpos.method_10264() + 1);
                }
                if (!world.method_22347((class_2338)bpos) || height < 0) {
                    bpos.method_33098(bpos.method_10264() - 1);
                }
                world.method_8652((class_2338)bpos, flower, 18);
                bpos.method_33098(bpos.method_10264() - 1);
                stem = world.method_8320((class_2338)bpos);
                if (!stem.method_27852(LighterEndBlocks.END_LOTUS_STEM)) {
                    stem = LighterEndBlocks.END_LOTUS_STEM.method_9564();
                    if (!world.method_8320(bpos.method_10095()).method_26227().method_15769()) {
                        stem = (class_2680)stem.method_11657((class_2769)Stem.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                    }
                }
                if (world.method_8320(bpos.method_10093(dir)).method_27852(LighterEndBlocks.END_LOTUS_LEAF)) {
                    stem = (class_2680)((class_2680)stem.method_11657((class_2769)Stem.LEAF, (Comparable)Boolean.valueOf(true))).method_11657(Stem.FACING, (Comparable)dir);
                }
                world.method_8652((class_2338)bpos, (class_2680)stem.method_11657(Stem.SHAPE, (Comparable)((Object)Shape.TOP)), 18);
                return true;
            }
            return false;
        }

        private void generateLeaf(class_5281 world, class_2338 pos) {
            class_2338.class_2339 p = new class_2338.class_2339();
            class_2680 leaf = LighterEndBlocks.END_LOTUS_LEAF.method_9564();
            world.method_8652(pos, (class_2680)leaf.method_11657(Leaf.SHAPE, (Comparable)((Object)Shape.BOTTOM)), 18);
            for (class_2350 move : class_2350.class_2353.field_11062) {
                world.method_8652((class_2338)p.method_10101((class_2382)pos).method_10098(move), (class_2680)((class_2680)leaf.method_11657(Leaf.HORIZONTAL_FACING, (Comparable)move)).method_11657(Leaf.SHAPE, (Comparable)((Object)Shape.MIDDLE)), 18);
            }
            for (int i = 0; i < 4; ++i) {
                class_2350 d1 = (class_2350)class_2350.class_2353.field_11062.method_29716().toList().get(i);
                class_2350 d2 = (class_2350)class_2350.class_2353.field_11062.method_29716().toList().get(i + 1 & 3);
                world.method_8652((class_2338)p.method_10101((class_2382)pos).method_10098(d1).method_10098(d2), (class_2680)((class_2680)leaf.method_11657(Leaf.HORIZONTAL_FACING, (Comparable)d1)).method_11657(Leaf.SHAPE, (Comparable)((Object)Shape.TOP)), 18);
            }
        }

        private boolean hasLeaf(class_5281 world, class_2338 pos) {
            class_2338.class_2339 p = new class_2338.class_2339();
            p.method_33098(pos.method_10264());
            int count = 0;
            for (int x = -1; x < 2; ++x) {
                p.method_33097(pos.method_10263() + x);
                for (int z = -1; z < 2; ++z) {
                    p.method_33099(pos.method_10260() + z);
                    if (!world.method_22347((class_2338)p) || world.method_8316(p.method_10074()).method_15769()) continue;
                    ++count;
                }
            }
            return count == 9;
        }
    }

    public static class Seed
    extends Sapling
    implements class_2402 {
        public Seed(class_4970.class_2251 settings) {
            super(EndLotusFeature::new, settings, 7);
        }

        @Override
        protected boolean method_9695(class_2680 floor, class_1922 world, class_2338 pos) {
            return floor.method_26206(world, pos, class_2350.field_11036) && floor.method_26164(LighterEndTags.AQUATIC_END_SOIL);
        }

        @Nullable
        public class_2680 method_9605(class_1750 ctx) {
            class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
            return fluidState.method_15767(class_3486.field_15517) && fluidState.method_15761() == 8 ? super.method_9605(ctx) : null;
        }

        protected class_3610 method_9545(class_2680 state) {
            return class_3612.field_15910.method_15729(false);
        }

        public boolean method_10310(@Nullable class_1309 filler, class_1922 world, class_2338 pos, class_2680 state, class_3611 fluid) {
            return false;
        }

        public boolean method_10311(class_1936 world, class_2338 pos, class_2680 state, class_3610 fluidState) {
            return false;
        }

        public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
            return EndLotus.canGrow((class_1936)world, pos);
        }
    }

    public static class Leaf
    extends class_2248 {
        public static final class_2754<class_2350> HORIZONTAL_FACING = class_2741.field_12481;
        public static final class_2754<Shape> SHAPE = class_2754.method_11850((String)"shape", Shape.class);
        private static final class_265 VSHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

        public Leaf(class_4970.class_2251 settings) {
            super(settings.method_31710(class_3620.field_16030).method_9618().method_9626(class_2498.field_25183).method_22488().method_50012(class_3619.field_15971));
        }

        public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
            class_2680 down = world.method_8320(pos.method_10074());
            return !down.method_26227().method_15769() && down.method_26227().method_15772() instanceof class_3621;
        }

        protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
            builder.method_11667(new class_2769[]{SHAPE, HORIZONTAL_FACING});
        }

        public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 ePos) {
            return VSHAPE;
        }

        public class_2680 method_9598(class_2680 state, class_2470 rotation) {
            return (class_2680)state.method_11657(HORIZONTAL_FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(HORIZONTAL_FACING)));
        }

        public class_2680 method_9569(class_2680 state, class_2415 mirror) {
            return state.method_26186(mirror.method_10345((class_2350)state.method_11654(HORIZONTAL_FACING)));
        }

        protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
            return new class_1799((class_1935)LighterEndBlocks.END_LOTUS_SEED);
        }
    }

    public static class Stem
    extends class_2248
    implements class_3737,
    class_2402 {
        public static final class_2754<class_2350> FACING = class_2741.field_12525;
        public static final class_2746 WATERLOGGED = class_2741.field_12508;
        public static final class_2746 LEAF = class_2746.method_11825((String)"leaf");
        public static final class_2754<Shape> SHAPE = class_2754.method_11850((String)"shape", Shape.class);
        private static final Map<class_2350.class_2351, class_265> SHAPES = Maps.newEnumMap(class_2350.class_2351.class);

        public Stem(class_4970.class_2251 settings) {
            super(settings.method_31710(class_3620.field_15995).method_51368(class_2766.field_12651).method_9629(2.0f, 3.0f).method_9626(class_2498.field_40314).method_50012(class_3619.field_15971).method_22488().method_51369().method_50013());
            this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657(SHAPE, (Comparable)((Object)Shape.MIDDLE))).method_11657((class_2769)LEAF, (Comparable)Boolean.valueOf(false))).method_11657(FACING, (Comparable)class_2350.field_11036));
        }

        protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
            builder.method_11667(new class_2769[]{FACING, WATERLOGGED, SHAPE, LEAF});
        }

        protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
            return (Boolean)state.method_11654((class_2769)LEAF) != false ? SHAPES.get(class_2350.class_2351.field_11052) : SHAPES.get(((class_2350)state.method_11654(FACING)).method_10166());
        }

        public class_3610 method_9545(class_2680 state) {
            return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
        }

        public class_2680 method_9605(class_1750 ctx) {
            class_1937 worldAccess = ctx.method_8045();
            class_2338 blockPos = ctx.method_8037();
            return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(worldAccess.method_8316(blockPos).method_15772() == class_3612.field_15910))).method_11657(FACING, (Comparable)ctx.method_8038());
        }

        public class_2680 method_9598(class_2680 state, class_2470 rotation) {
            return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
        }

        public class_2680 method_9569(class_2680 state, class_2415 mirror) {
            return state.method_26186(mirror.method_10345((class_2350)state.method_11654(FACING)));
        }

        protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
            if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
                tickView.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
            }
            if (!this.method_9558(state, world, pos)) {
                tickView.method_64310(pos, (class_2248)this, 1);
            }
            return state;
        }

        protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
            if (!state.method_26184((class_4538)world, pos)) {
                world.method_22352(pos, true);
            }
        }

        public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
            class_2680 down = world.method_8320(pos.method_10074());
            return down.method_26164(LighterEndTags.AQUATIC_END_SOIL) || down.method_26204() == this;
        }

        static {
            SHAPES.put(class_2350.class_2351.field_11048, class_2248.method_9541((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
            SHAPES.put(class_2350.class_2351.field_11052, class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
            SHAPES.put(class_2350.class_2351.field_11051, class_2248.method_9541((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0));
        }
    }
}

