/*
 * Decompiled with CFR 0.152.
 */
package io.github.openbagtwo.lighterend.mobs;

import io.github.openbagtwo.lighterend.registries.LighterEndBiomes;
import io.github.openbagtwo.lighterend.utils.PosInfo;
import java.util.EnumSet;
import net.minecraft.class_10179;
import net.minecraft.class_10181;
import net.minecraft.class_1266;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_268;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class EndSlime
extends class_1621 {
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(EndSlime.class, (class_2941)class_2943.field_13327);

    public EndSlime(class_1299<EndSlime> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new EndSlimeMoveControl(this);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new SwimmingGoal());
        this.field_6201.method_6277(2, (class_1352)new FaceTowardTargetGoal());
        this.field_6201.method_6277(3, (class_1352)new RandomLookGoal());
        this.field_6201.method_6277(5, (class_1352)new MoveGoal(this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, (target, world) -> Math.abs(target.method_23318() - this.method_23318()) <= 4.0));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23716, 1.0).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23717, 16.0).method_26868(class_5134.field_23719, 0.15);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_1315 data = super.method_5943(world, difficulty, spawnReason, entityData);
        class_6880 biome = world.method_23753(this.method_24515());
        if (biome.method_40230().isPresent()) {
            if (biome.method_40225(LighterEndBiomes.FOGGY_MUSHROOMLANDS)) {
                this.setMossy();
            } else if (biome.method_40225(LighterEndBiomes.UMBRELLA_JUNGLE)) {
                this.setJungle();
            }
            this.method_18382();
        }
        return data;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)0);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getSlimeType());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setSlimeType(nbt.method_68083("Variant", 0));
    }

    protected class_2394 method_7162() {
        return class_2398.field_11214;
    }

    public int getSlimeType() {
        return (Integer)this.field_6011.method_12789(VARIANT);
    }

    public void setSlimeType(int value) {
        this.field_6011.method_12778(VARIANT, (Object)value);
    }

    protected void setMossy() {
        this.setSlimeType(1);
    }

    protected void setJungle() {
        this.setSlimeType(0);
    }

    public void method_5650(class_1297.class_5529 reason) {
        class_1937 class_19372;
        int i = this.method_7152();
        if (!this.method_37908().method_8608() && i > 1 && this.method_29504()) {
            float f = this.method_18377(this.method_18376()).comp_2185();
            float g = f / 2.0f;
            int j = i / 2;
            int k = 2 + this.field_5974.method_43048(3);
            class_268 team = this.method_5781();
            for (int l = 0; l < k; ++l) {
                float h = ((float)(l % 2) - 0.5f) * g;
                float m = ((float)(l / 2) - 0.5f) * g;
                this.method_63631(this.method_5864(), new class_10179(class_10181.field_54081, false, false, team), class_3730.field_16461, newSlime -> {
                    newSlime.method_7161(j, true);
                    if (newSlime instanceof EndSlime) {
                        EndSlime babyEndSlime = (EndSlime)newSlime;
                        babyEndSlime.setSlimeType(this.getSlimeType());
                    }
                    newSlime.method_5808(this.method_23317() + (double)h, this.method_23318() + 0.5, this.method_23321() + (double)m, this.field_5974.method_43057() * 360.0f, 0.0f);
                });
            }
        }
        if ((reason == class_1297.class_5529.field_26998 || reason == class_1297.class_5529.field_26999) && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            this.method_60699(serverWorld, reason);
        }
        this.method_31745(reason);
        this.field_18321.method_49709();
    }

    class EndSlimeMoveControl
    extends class_1335 {
        private float targetYaw;
        private int ticksUntilJump;
        private boolean jumpOften;

        public EndSlimeMoveControl(EndSlime slime) {
            super((class_1308)slime);
            this.targetYaw = 180.0f * slime.method_36454() / (float)Math.PI;
        }

        public void look(float targetYaw, boolean jumpOften) {
            this.targetYaw = targetYaw;
            this.jumpOften = jumpOften;
        }

        public void move(double speed) {
            this.field_6372 = speed;
            this.field_6374 = class_1335.class_1336.field_6378;
        }

        public void method_6240() {
            this.field_6371.method_36456(this.method_6238(this.field_6371.method_36454(), this.targetYaw, 90.0f));
            this.field_6371.field_6241 = this.field_6371.method_36454();
            this.field_6371.field_6283 = this.field_6371.method_36454();
            if (this.field_6374 != class_1335.class_1336.field_6378) {
                this.field_6371.method_5930(0.0f);
            } else {
                this.field_6374 = class_1335.class_1336.field_6377;
                if (this.field_6371.method_24828()) {
                    this.field_6371.method_6125((float)(this.field_6372 * this.field_6371.method_45325(class_5134.field_23719)));
                    if (this.ticksUntilJump-- <= 0) {
                        this.ticksUntilJump = EndSlime.this.method_7154();
                        if (this.jumpOften) {
                            this.ticksUntilJump /= 3;
                        }
                        EndSlime.this.method_5993().method_6233();
                        if (EndSlime.this.method_7159()) {
                            EndSlime.this.method_5783(EndSlime.this.method_7153(), EndSlime.this.method_6107(), this.getJumpSoundPitch());
                        }
                    } else {
                        EndSlime.this.field_6212 = 0.0f;
                        EndSlime.this.field_6250 = 0.0f;
                        this.field_6371.method_6125(0.0f);
                    }
                } else {
                    this.field_6371.method_6125((float)(this.field_6372 * this.field_6371.method_45325(class_5134.field_23719)));
                }
            }
        }

        private float getJumpSoundPitch() {
            float f = EndSlime.this.method_7157() ? 1.4f : 0.8f;
            return ((EndSlime.this.field_5974.method_43057() - EndSlime.this.field_5974.method_43057()) * 0.2f + 1.0f) * f;
        }
    }

    class SwimmingGoal
    extends class_1352 {
        public SwimmingGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407, class_1352.class_4134.field_18405));
            EndSlime.this.method_5942().method_6354(true);
        }

        public boolean method_6264() {
            return (EndSlime.this.method_5799() || EndSlime.this.method_5771()) && EndSlime.this.method_5962() instanceof EndSlimeMoveControl;
        }

        public void method_6268() {
            if (EndSlime.this.method_59922().method_43057() < 0.8f) {
                EndSlime.this.method_5993().method_6233();
            }
            ((EndSlimeMoveControl)EndSlime.this.method_5962()).move(1.2);
        }
    }

    class FaceTowardTargetGoal
    extends class_1352 {
        private int ticksLeft;

        public FaceTowardTargetGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 livingEntity = EndSlime.this.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            return (!(livingEntity instanceof class_1657) || !((class_1657)livingEntity).method_31549().field_7480) && EndSlime.this.method_5962() instanceof EndSlimeMoveControl;
        }

        public void method_6269() {
            this.ticksLeft = 300;
            super.method_6269();
        }

        public boolean method_6266() {
            class_1309 livingEntity = EndSlime.this.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            if (livingEntity instanceof class_1657 && ((class_1657)livingEntity).method_31549().field_7480) {
                return false;
            }
            return --this.ticksLeft > 0;
        }

        public void method_6268() {
            EndSlime.this.method_5951((class_1297)EndSlime.this.method_5968(), 10.0f, 10.0f);
            ((EndSlimeMoveControl)EndSlime.this.method_5962()).look(EndSlime.this.method_36454(), EndSlime.this.method_7163());
        }
    }

    class RandomLookGoal
    extends class_1352 {
        private float targetYaw;
        private int timer;

        public RandomLookGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return EndSlime.this.method_5968() == null && (EndSlime.this.method_24828() || EndSlime.this.method_5799() || EndSlime.this.method_5771() || EndSlime.this.method_6059(class_1294.field_5902)) && EndSlime.this.method_5962() instanceof EndSlimeMoveControl;
        }

        public void method_6268() {
            if (--this.timer <= 0) {
                this.timer = 40 + EndSlime.this.method_59922().method_43048(60);
                this.targetYaw = EndSlime.this.method_59922().method_43048(360);
            }
            ((EndSlimeMoveControl)EndSlime.this.method_5962()).look(this.targetYaw, false);
        }
    }

    class MoveGoal
    extends class_1352 {
        private final EndSlime slime;

        public MoveGoal(EndSlime slime) {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407, class_1352.class_4134.field_18405));
            this.slime = slime;
        }

        public boolean method_6264() {
            if (EndSlime.this.method_5765()) {
                return false;
            }
            float yaw = EndSlime.this.method_5791();
            float speed = EndSlime.this.method_6029();
            if ((double)speed > 0.1) {
                float dx = class_3532.method_15374((float)(-yaw * ((float)Math.PI / 180)));
                float dz = class_3532.method_15362((float)(-yaw * ((float)Math.PI / 180)));
                class_2338 pos = EndSlime.this.method_24515().method_10069((int)(dx * speed * 4.0f), 0, (int)(dz * speed * 4.0f));
                int down = PosInfo.downRay((class_1936)EndSlime.this.method_37908(), pos, 16);
                return down < 5;
            }
            return true;
        }

        public void method_6268() {
            class_1335 class_13352 = this.slime.method_5962();
            if (class_13352 instanceof EndSlimeMoveControl) {
                EndSlimeMoveControl slimeMoveControl = (EndSlimeMoveControl)class_13352;
                slimeMoveControl.move(1.0);
            }
        }
    }
}

