/*
 * Decompiled with CFR 0.152.
 */
package io.github.openbagtwo.lighterend.mobs.renderers;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.mobs.EndSlime;
import io.github.openbagtwo.lighterend.mobs.EntityModels;
import io.github.openbagtwo.lighterend.mobs.models.EndSlimeModel;
import io.github.openbagtwo.lighterend.mobs.states.EndSlimeRenderState;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4606;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_922;
import net.minecraft.class_927;

@Environment(value=EnvType.CLIENT)
public class EndSlimeRenderer
extends class_927<EndSlime, EndSlimeRenderState, EndSlimeModel> {
    private static final List<class_2960> TEXTURES = Arrays.asList(LighterEnd.of("textures/entity/end_slime/end_slime.png"), LighterEnd.of("textures/entity/end_slime/end_slime_mossy.png"), LighterEnd.of("textures/entity/end_slime/end_slime_lake.png"), LighterEnd.of("textures/entity/end_slime/end_slime_amber.png"));
    private static final List<class_1921> GLOW = Arrays.asList(class_1921.method_23026((class_2960)LighterEnd.of("textures/entity/end_slime/end_slime_glow.png")), class_1921.method_23026((class_2960)LighterEnd.of("textures/entity/end_slime/end_slime_glow.png")), class_1921.method_23026((class_2960)LighterEnd.of("textures/entity/end_slime/end_slime_lake_glow.png")), class_1921.method_23026((class_2960)LighterEnd.of("textures/entity/end_slime/end_slime_amber_glow.png")));

    public EndSlimeRenderer(class_5617.class_5618 context) {
        super(context, (class_583)new EndSlimeModel(context.method_32167(EntityModels.END_SLIME_MODEL), false), 0.25f);
        this.method_4046(new OverlayFeatureRenderer((class_3883<EndSlimeRenderState, EndSlimeModel>)this, context.method_32170()));
        this.method_4046((class_3887)new class_4606<EndSlimeRenderState, EndSlimeModel>(this, (class_3883)this){

            public class_1921 method_23193() {
                return GLOW.get(0);
            }

            public void render(class_4587 matrices, class_4597 vertexConsumers, int light, EndSlimeRenderState state, float limbAngle, float limbDistance) {
                class_4588 vertexConsumer = vertexConsumers.getBuffer(GLOW.get(state.variant % GLOW.size()));
                ((EndSlimeModel)this.method_17165()).method_62100(matrices, vertexConsumer, 0xF00000, class_4608.field_21444, -1);
            }
        });
    }

    protected float getShadowRadius(EndSlimeRenderState state) {
        return (float)state.size * 0.25f;
    }

    protected void scale(EndSlimeRenderState state, class_4587 matrixStack) {
        float f = 0.999f;
        matrixStack.method_22905(0.999f, 0.999f, 0.999f);
        matrixStack.method_46416(0.0f, 0.001f, 0.0f);
        float g = state.size;
        float h = state.stretch / (g * 0.5f + 1.0f);
        float i = 1.0f / (h + 1.0f);
        matrixStack.method_22905(i * g, 1.0f / i * g, i * g);
    }

    public class_2960 getTexture(EndSlimeRenderState state) {
        return TEXTURES.get(state.variant % TEXTURES.size());
    }

    public EndSlimeRenderState createRenderState() {
        return new EndSlimeRenderState();
    }

    public void updateRenderState(EndSlime slime, EndSlimeRenderState state, float f) {
        super.method_62355((class_1309)slime, (class_10042)state, f);
        state.variant = slime.getSlimeType();
        state.stretch = class_3532.method_16439((float)f, (float)slime.field_7387, (float)slime.field_7388);
        state.size = slime.method_7152();
    }

    @Environment(value=EnvType.CLIENT)
    public static class OverlayFeatureRenderer
    extends class_3887<EndSlimeRenderState, EndSlimeModel> {
        private final EndSlimeModel model;

        public OverlayFeatureRenderer(class_3883<EndSlimeRenderState, EndSlimeModel> context, class_5599 loader) {
            super(context);
            this.model = new EndSlimeModel(loader.method_32072(EntityModels.END_SLIME_SHELL_MODEL), true);
        }

        public void render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, EndSlimeRenderState state, float f, float g) {
            boolean renderAsModel;
            this.model.method_2819((class_10017)state);
            boolean bl = renderAsModel = state.field_53462 && state.field_53333;
            if (!state.field_53333 || renderAsModel) {
                class_4588 vertexConsumer = renderAsModel ? vertexConsumerProvider.getBuffer(class_1921.method_23287((class_2960)TEXTURES.get(state.variant % TEXTURES.size()))) : vertexConsumerProvider.getBuffer(class_1921.method_23580((class_2960)TEXTURES.get(state.variant % TEXTURES.size())));
                this.model.method_60879(matrixStack, vertexConsumer, i, class_922.method_23622((class_10042)state, (float)0.0f));
            }
        }
    }
}

