/*
 * Decompiled with CFR 0.152.
 */
package io.github.openbagtwo.lighterend.world.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.utils.math.sdf.SDF;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFRotate;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFTranslate;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFUnion;
import io.github.openbagtwo.lighterend.utils.math.sdf.primitives.SDFCappedCone;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.joml.Vector3f;

public class IceStar
extends class_3031<Config> {
    public IceStar() {
        super(Config.CODEC);
    }

    public boolean method_13151(class_5821<Config> featureConfig) {
        class_2680 dense;
        class_2680 ice;
        class_5819 random = featureConfig.method_33654();
        class_2338 pos = featureConfig.method_33655();
        class_5281 world = featureConfig.method_33652();
        Config cfg = (Config)featureConfig.method_33656();
        float size = class_3532.method_15344((class_5819)random, (float)cfg.minSize, (float)cfg.maxSize);
        int count = class_3532.method_15395((class_5819)random, (int)cfg.minCount, (int)cfg.maxCount);
        List<Vector3f> points = this.getFibonacciPoints(count);
        SDF sdf = null;
        SDF spike = new SDFCappedCone().setRadius1(3.0f + (size - 5.0f) * 0.2f).setRadius2(0.0f).setHeight(size).setBlock(class_2246.field_10491);
        spike = new SDFTranslate().setTranslate(0.0f, size - 0.5f, 0.0f).setSource(spike);
        Vector3f yp = new Vector3f(0.0f, 1.0f, 0.0f);
        for (Vector3f point : points) {
            SDF rotated = spike;
            float angle = IceStar.angle(yp, point = IceStar.normalize(point));
            if (angle > 0.01f && angle < 3.14f) {
                Vector3f axis = IceStar.normalize(IceStar.cross(yp, point));
                rotated = new SDFRotate().setRotation(axis, angle).setSource(spike);
            } else if (angle > 1.0f) {
                rotated = new SDFRotate().setRotation(yp, (float)Math.PI).setSource(spike);
            }
            sdf = sdf == null ? rotated : new SDFUnion().setSourceA(sdf).setSourceB(rotated);
        }
        int x1 = pos.method_10263() >> 4 << 4;
        int z1 = pos.method_10260() >> 4 << 4;
        pos = new class_2338(x1 + random.method_43048(16), class_3532.method_15395((class_5819)random, (int)32, (int)128), z1 + random.method_43048(16));
        float ancientRadius = size * 0.7f;
        float denseRadius = size * 0.9f;
        float iceRadius = size < 7.0f ? size * 5.0f : size * 1.3f;
        float randScale = size * 0.3f;
        class_2338 center = pos;
        class_2680 ancient = switch (cfg.variant % 3) {
            case 2 -> {
                ice = LighterEndBlocks.AUROUS_ICE.method_9564();
                dense = class_2246.field_33510.method_9564();
                yield class_2246.field_33510.method_9564();
            }
            case 1 -> {
                ice = LighterEndBlocks.FERROUS_ICE.method_9564();
                dense = LighterEndBlocks.FERROUS_ICE.method_9564();
                yield class_2246.field_33508.method_9564();
            }
            default -> {
                ice = LighterEndBlocks.EMERALD_ICE.method_9564();
                dense = class_2246.field_33509.method_9564();
                yield class_2246.field_33509.method_9564();
            }
        };
        SDF sdfCopy = sdf;
        sdf.addPostProcess(info -> {
            float pz;
            float py;
            class_2338 bpos = info.getPos();
            float px = bpos.method_10263() - center.method_10263();
            float distance = class_3532.method_15355((float)(px * px + (py = (float)(bpos.method_10264() - center.method_10264())) * py + (pz = (float)(bpos.method_10260() - center.method_10260())) * pz)) + sdfCopy.getDistance(px, py, pz) * 0.4f + random.method_43057() * randScale;
            if (distance < ancientRadius) {
                return ancient;
            }
            if (distance < denseRadius) {
                return dense;
            }
            if (distance < iceRadius) {
                return ice;
            }
            return info.getState();
        }).fillRecursive((class_5425)world, pos);
        return true;
    }

    private List<Vector3f> getFibonacciPoints(int count) {
        float max = count - 1;
        ArrayList<Vector3f> result = new ArrayList<Vector3f>(count);
        for (int i = 0; i < count; ++i) {
            float y = 1.0f - (float)i / max * 2.0f;
            float radius = (float)Math.sqrt(1.0f - y * y);
            float theta = (float)(Math.PI * (3.0 - Math.sqrt(5.0))) * (float)i;
            float x = (float)Math.cos(theta) * radius;
            float z = (float)Math.sin(theta) * radius;
            result.add(new Vector3f(x, y, z));
        }
        return result;
    }

    public static Vector3f normalize(Vector3f vec) {
        float length = vec.x * vec.x + vec.y * vec.y + vec.z * vec.z;
        if (length > 0.0f) {
            length = (float)Math.sqrt(length);
            float x = vec.x / length;
            float y = vec.y / length;
            float z = vec.z / length;
            vec.set(x, y, z);
        }
        return vec;
    }

    private static float angle(Vector3f vec1, Vector3f vec2) {
        float dot = vec1.x * vec2.x + vec1.y * vec2.y + vec1.z * vec2.z;
        float length1 = vec1.x * vec1.x + vec1.y * vec1.y + vec1.z * vec1.z;
        float length2 = vec2.x * vec2.x + vec2.y * vec2.y + vec2.z * vec2.z;
        return (float)Math.acos((double)dot / Math.sqrt(length1 * length2));
    }

    private static Vector3f cross(Vector3f vec1, Vector3f vec2) {
        float cx = vec1.y * vec2.z - vec1.z * vec2.y;
        float cy = vec1.z * vec2.x - vec1.x * vec2.z;
        float cz = vec1.x * vec2.y - vec1.y * vec2.x;
        return new Vector3f(cx, cy, cz);
    }

    public record Config(int variant, float minSize, float maxSize, int minCount, int maxCount) implements class_3037
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("variant").forGetter(o -> o.variant), (App)Codec.FLOAT.fieldOf("min_size").forGetter(o -> Float.valueOf(o.minSize)), (App)Codec.FLOAT.fieldOf("max_size").forGetter(o -> Float.valueOf(o.maxSize)), (App)Codec.INT.fieldOf("min_count").forGetter(o -> o.minCount), (App)Codec.INT.fieldOf("max_count").forGetter(o -> o.maxCount)).apply((Applicative)instance, Config::new));
    }
}

