/*
 * Decompiled with CFR 0.152.
 */
package io.github.openbagtwo.lighterend.world.features;

import com.google.common.collect.Sets;
import io.github.openbagtwo.lighterend.BlockFixer;
import io.github.openbagtwo.lighterend.blocks.HydrothermalVent;
import io.github.openbagtwo.lighterend.blocks.TubeWorm;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.utils.MiscUtils;
import io.github.openbagtwo.lighterend.utils.math.MathUtils;
import io.github.openbagtwo.lighterend.world.features.SulphurLake;
import io.github.openbagtwo.lighterend.world.gen.noise.OpenSimplexNoise;
import java.util.HashSet;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class SulphurCave
extends class_3031<class_3111> {
    public SulphurCave() {
        super(class_3111.field_24893);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_5819 random = context.method_33654();
        class_2338 pos = context.method_33655();
        class_5281 world = context.method_33652();
        int radius = class_3532.method_15395((class_5819)random, (int)10, (int)30);
        int top = world.method_8624(class_2902.class_2903.field_13194, pos.method_10263(), pos.method_10260());
        class_2338.class_2339 bpos = new class_2338.class_2339();
        bpos.method_33097(pos.method_10263());
        bpos.method_33099(pos.method_10260());
        bpos.method_33098(top - 1);
        class_2680 state = world.method_8320((class_2338)bpos);
        while (!state.method_26164(LighterEndTags.END_STONES) && bpos.method_10264() > 5) {
            bpos.method_33098(bpos.method_10264() - 1);
            state = world.method_8320((class_2338)bpos);
        }
        if (bpos.method_10264() < 10) {
            return false;
        }
        top = (int)((float)bpos.method_10264() - ((float)radius * 1.3f + 5.0f));
        while (state.method_26164(LighterEndTags.END_STONES) || !state.method_26227().method_15769() && bpos.method_10264() > 5) {
            bpos.method_33098(bpos.method_10264() - 1);
            state = world.method_8320((class_2338)bpos);
        }
        int bottom = (int)((float)bpos.method_10264() + (float)radius * 1.3f + 5.0f);
        if (top <= bottom) {
            return false;
        }
        class_2338.class_2339 mut = new class_2338.class_2339();
        pos = new class_2338(pos.method_10263(), class_3532.method_15395((class_5819)random, (int)bottom, (int)top), pos.method_10260());
        OpenSimplexNoise noise = new OpenSimplexNoise(MathUtils.getSeed(534, pos.method_10263(), pos.method_10260()));
        int x1 = pos.method_10263() - radius - 5;
        int z1 = pos.method_10260() - radius - 5;
        int x2 = pos.method_10263() + radius + 5;
        int z2 = pos.method_10260() + radius + 5;
        int y1 = class_3532.method_15357((double)((double)pos.method_10264() - (double)(radius + 5) / 1.6));
        int y2 = class_3532.method_15357((double)((double)pos.method_10264() + (double)(radius + 5) / 1.6));
        double hr = (double)radius * 0.75;
        double nr = (double)radius * 0.25;
        HashSet brimstone = Sets.newHashSet();
        class_2680 rock = LighterEndBlocks.BORNITE.baseBlock.method_9564();
        int waterLevel = pos.method_10264() + class_3532.method_15395((class_5819)random, (int)class_3532.method_15357((double)((double)radius * 0.8)), (int)radius);
        for (int x = x1; x <= x2; ++x) {
            int xsq = x - pos.method_10263();
            xsq *= xsq;
            mut.method_33097(x);
            for (int z = z1; z <= z2; ++z) {
                int zsq = z - pos.method_10260();
                zsq *= zsq;
                mut.method_33099(z);
                for (int y = y1; y <= y2; ++y) {
                    int ysq = y - pos.method_10264();
                    ysq = (int)((double)ysq * 1.6);
                    ysq *= ysq;
                    mut.method_33098(y);
                    double r = noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) * nr + hr;
                    double r2 = r + 5.0;
                    double dist = xsq + ysq + zsq;
                    if (dist < r * r) {
                        state = world.method_8320((class_2338)mut);
                        if (!SulphurCave.isReplaceable(state)) continue;
                        world.method_8652((class_2338)mut, y < waterLevel ? class_2246.field_10382.method_9564() : class_2246.field_10543.method_9564(), 18);
                        continue;
                    }
                    if (!(dist < r2 * r2) || !(state = world.method_8320((class_2338)mut)).method_26164(LighterEndTags.END_STONES) && !state.method_27852(class_2246.field_10124)) continue;
                    double v = noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) + noise.eval((double)x * 0.03, (double)y * 0.03, (double)z * 0.03) * 0.5;
                    if (v > 0.4) {
                        brimstone.add(mut.method_10062());
                        continue;
                    }
                    world.method_8652((class_2338)mut, rock, 18);
                }
            }
        }
        brimstone.forEach(blockPos -> SulphurLake.placeBrimstone(world, blockPos, random));
        if (random.method_43048(4) == 0) {
            int count = class_3532.method_15395((class_5819)random, (int)5, (int)20);
            for (int i = 0; i < count; ++i) {
                mut.method_10101((class_2382)pos).method_10100(class_3532.method_15357((double)(random.method_43059() * 2.0 + 0.5)), 0, class_3532.method_15357((double)(random.method_43059() * 2.0 + 0.5)));
                int dist = class_3532.method_15357((double)(3.0 - Math.sqrt(Math.pow(mut.method_10263() - pos.method_10263(), 2.0) + Math.pow(mut.method_10260() - pos.method_10260(), 2.0)))) + random.method_43048(2);
                if (dist <= 0) continue;
                state = world.method_8320((class_2338)mut);
                while (!state.method_26227().method_15769() || state.method_26164(LighterEndTags.AQUATIC_END_VEGETATION)) {
                    mut.method_33098(mut.method_10264() - 1);
                    state = world.method_8320((class_2338)mut);
                }
                if (!state.method_26164(LighterEndTags.END_STONES) || world.method_8320(mut.method_10084()).method_27852(LighterEndBlocks.HYDROTHERMAL_VENT)) continue;
                for (int j = 0; j <= dist; ++j) {
                    world.method_8652((class_2338)mut, LighterEndBlocks.BORNITE.baseBlock.method_9564(), 18);
                    for (class_2350 dir : class_2350.class_2353.field_11062.method_43342(random)) {
                        class_2338 p = mut.method_10093(dir);
                        if (!random.method_43056() || !world.method_8320(p).method_27852(class_2246.field_10382)) continue;
                        world.method_8652(p, (class_2680)LighterEndBlocks.TUBE_WORM.method_9564().method_11657(TubeWorm.FACING, (Comparable)dir), 18);
                    }
                    mut.method_33098(mut.method_10264() + 1);
                }
                world.method_8652((class_2338)mut, (class_2680)((class_2680)LighterEndBlocks.HYDROTHERMAL_VENT.method_9564().method_11657((class_2769)HydrothermalVent.ACTIVATED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)HydrothermalVent.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 18);
                mut.method_33098(mut.method_10264() + 1);
                state = world.method_8320((class_2338)mut);
                while (state.method_27852(class_2246.field_10382)) {
                    world.method_8652((class_2338)mut, LighterEndBlocks.VENT_BUBBLE_COLUMN.method_9564(), 18);
                    world.method_39283(mut.method_10062(), (Object)LighterEndBlocks.VENT_BUBBLE_COLUMN, class_3532.method_15395((class_5819)random, (int)8, (int)32));
                    mut.method_33098(mut.method_10264() + 1);
                    state = world.method_8320((class_2338)mut);
                }
            }
        }
        BlockFixer.fixBlocks((class_1936)world, new class_2338(x1, y1, z1), new class_2338(x2, y2, z2));
        return true;
    }

    private static boolean isReplaceable(class_2680 state) {
        return state.method_26164(LighterEndTags.END_STONES) || state.method_27852(LighterEndBlocks.HYDROTHERMAL_VENT) || state.method_27852(LighterEndBlocks.VENT_BUBBLE_COLUMN) || state.method_27852(LighterEndBlocks.SULPHUR_CRYSTAL) || MiscUtils.replaceableOrPlant(state) != false || state.method_26164(LighterEndTags.AQUATIC_END_VEGETATION) || state.method_26164(class_3481.field_15503);
    }
}

