/*
 * Decompiled with CFR 0.152.
 */
package io.github.openbagtwo.lighterend.world.features.trees;

import com.google.common.collect.Lists;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.utils.MiscUtils;
import io.github.openbagtwo.lighterend.utils.math.MathUtils;
import io.github.openbagtwo.lighterend.utils.math.sdf.SDF;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFDisplace;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFScale;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFScale3D;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFSubtract;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFTranslate;
import io.github.openbagtwo.lighterend.utils.math.sdf.primitives.SDFSphere;
import io.github.openbagtwo.lighterend.world.gen.noise.OpenSimplexNoise;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.joml.Vector3f;

public class TenaneaTree
extends class_3031<class_3111> {
    private static final Function<class_2680, Boolean> REPLACE = state -> {
        if (state.method_26204() == LighterEndBlocks.TENANEA_LEAVES) {
            return true;
        }
        return MiscUtils.replaceableOrPlant(state);
    };
    private static final Function<class_2680, Boolean> IGNORE = state -> Arrays.asList(LighterEndBlocks.TENANEA.log, LighterEndBlocks.TENANEA.wood).contains(state.method_26204());
    private static final List<Vector3f> SPLINE = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.1f, 0.35f, 0.0f), new Vector3f(0.2f, 0.5f, 0.0f), new Vector3f(0.3f, 0.55f, 0.0f), new Vector3f(0.42f, 0.7f, 0.0f), new Vector3f(0.5f, 1.0f, 0.0f)});

    public TenaneaTree() {
        super(class_3111.field_24893);
    }

    public boolean method_13151(class_5821<class_3111> featureConfig) {
        class_5819 random = featureConfig.method_33654();
        class_2338 pos = featureConfig.method_33655();
        class_5281 world = featureConfig.method_33652();
        if (!world.method_8320(pos.method_10074()).method_26164(LighterEndTags.END_SOIL)) {
            return false;
        }
        float size = class_3532.method_15395((class_5819)random, (int)7, (int)10);
        int count = (int)(size * 0.45f);
        float var = (float)Math.PI * 2 / (float)(count * 3);
        float start = class_3532.method_15344((class_5819)random, (float)0.0f, (float)((float)Math.PI * 2));
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2) + class_3532.method_15344((class_5819)random, (float)0.0f, (float)var) + start;
            List<Vector3f> spline = MathUtils.copySpline(SPLINE);
            MathUtils.rotateSpline(spline, angle);
            MathUtils.scale(spline, size + class_3532.method_15344((class_5819)random, (float)0.0f, (float)(size * 0.5f)));
            MathUtils.offsetParts(spline, random, 1.0f, 0.0f, 1.0f);
            MathUtils.fillSpline(spline, world, LighterEndBlocks.TENANEA.wood.method_9564(), pos, REPLACE);
            Vector3f last = spline.getLast();
            float leavesRadius = (size * 0.3f + class_3532.method_15344((class_5819)random, (float)0.8f, (float)1.5f)) * 1.4f;
            OpenSimplexNoise noise = new OpenSimplexNoise(random.method_43055());
            this.leavesBall(world, pos.method_10069((int)last.x(), (int)last.y(), (int)last.z()), leavesRadius, random, noise);
        }
        return true;
    }

    private void leavesBall(class_5281 world, class_2338 pos, float radius, class_5819 random, OpenSimplexNoise noise) {
        SDF sphere = new SDFSphere().setRadius(radius).setBlock((class_2680)LighterEndBlocks.TENANEA_LEAVES.method_9564().method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(6)));
        SDF.UnaryOperator sub = new SDFScale().setScale(5.0f).setSource(sphere);
        sub = new SDFTranslate().setTranslate(0.0f, -radius * 5.0f, 0.0f).setSource(sub);
        sphere = new SDFSubtract().setSourceA(sphere).setSourceB(sub);
        sphere = new SDFScale3D().setScale(1.0f, 0.75f, 1.0f).setSource(sphere);
        sphere = new SDFDisplace().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.x() * 0.2, (double)vec.y() * 0.2, (double)vec.z() * 0.2) * 2.0f)).setSource(sphere);
        sphere = new SDFDisplace().setFunction(vec -> Float.valueOf(class_3532.method_15344((class_5819)random, (float)-1.5f, (float)1.5f))).setSource(sphere);
        class_2338.class_2339 mut = new class_2338.class_2339();
        for (class_2350 d1 : class_2350.class_2353.field_11062) {
            class_2338 p = mut.method_10101((class_2382)pos).method_10098(class_2350.field_11036).method_10098(d1).method_10062();
            world.method_8652(p, LighterEndBlocks.TENANEA.wood.method_9564(), 18);
            for (class_2350 d2 : class_2350.class_2353.field_11062) {
                mut.method_10101((class_2382)p).method_10098(class_2350.field_11036).method_10098(d2);
                world.method_8652(p, LighterEndBlocks.TENANEA.wood.method_9564(), 18);
            }
        }
        class_2680 top = (class_2680)LighterEndBlocks.TENANEA_FLOWER.method_9564().method_11657((class_2769)class_2741.field_54794, (Comparable)Boolean.valueOf(false));
        class_2680 middle = (class_2680)LighterEndBlocks.TENANEA_FLOWER.method_9564().method_11657((class_2769)class_2741.field_54794, (Comparable)Boolean.valueOf(false));
        class_2680 bottom = (class_2680)LighterEndBlocks.TENANEA_FLOWER.method_9564().method_11657((class_2769)class_2741.field_54794, (Comparable)Boolean.valueOf(true));
        ArrayList support = Lists.newArrayList();
        sphere.addPostProcess(info -> {
            if (random.method_43048(6) == 0 && info.getStateDown().method_26215()) {
                class_2338 d = info.getPos().method_10074();
                support.add(d);
            }
            if (random.method_43048(5) == 0) {
                for (class_2338 dir : class_2350.values()) {
                    class_2680 state = info.getState((class_2350)dir, 2);
                    if (!state.method_26215()) continue;
                    return info.getState();
                }
                info.setState(LighterEndBlocks.TENANEA.wood.method_9564());
            }
            if (Arrays.asList(LighterEndBlocks.TENANEA.log, LighterEndBlocks.TENANEA.wood).contains(info.getState().method_26204())) {
                for (int x = -6; x < 7; ++x) {
                    int ax = Math.abs(x);
                    mut.method_33097(x + info.getPos().method_10263());
                    for (int z = -6; z < 7; ++z) {
                        int az = Math.abs(z);
                        mut.method_33099(z + info.getPos().method_10260());
                        for (int y = -6; y < 7; ++y) {
                            int distance;
                            int ay = Math.abs(y);
                            int d = ax + ay + az;
                            if (d >= 7) continue;
                            mut.method_33098(y + info.getPos().method_10264());
                            class_2680 state = info.getState((class_2338)mut);
                            if (!(state.method_26204() instanceof class_2397) || d >= (distance = ((Integer)state.method_11654((class_2769)class_2397.field_11199)).intValue())) continue;
                            info.setState((class_2338)mut, (class_2680)state.method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(d)));
                        }
                    }
                }
            }
            return info.getState();
        });
        sphere.fillRecursiveIgnore((class_5425)world, pos, IGNORE);
        world.method_8652(pos, LighterEndBlocks.TENANEA.wood.method_9564(), 18);
        support.forEach(bpos -> {
            class_2680 state = world.method_8320(bpos);
            if (state.method_26215()) {
                int count = class_3532.method_15395((class_5819)random, (int)3, (int)8);
                mut.method_10101((class_2382)bpos);
                if (world.method_8320(mut.method_10084()).method_27852(LighterEndBlocks.TENANEA_LEAVES)) {
                    world.method_8652((class_2338)mut, top, 18);
                    for (int i = 1; i < count; ++i) {
                        mut.method_33098(mut.method_10264() - 1);
                        if (!world.method_22347(mut.method_10074())) break;
                        world.method_8652((class_2338)mut, middle, 18);
                    }
                    world.method_8652((class_2338)mut, bottom, 18);
                }
            }
        });
    }
}

