package io.github.openbagtwo.lighterend.blocks;

import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.utils.Flags;
import io.github.openbagtwo.lighterend.utils.PosInfo;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2498;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2766;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

/**
 * Port of BetterEnd's Blue Vine, which isn't a vine
 */
public class Agave extends class_2248 {

  private static final class_265 OUTLINE_SHAPE = method_9541(4, 0, 4, 12, 16, 12);
  public static final class_2754<Shape> SHAPE = class_2754.method_11850("shape", Shape.class);

  public Agave(class_2251 settings) {
    super(
        settings
            .method_31710(class_3620.field_16024)
            .method_49229(class_2250.field_10657)
            .method_9624()
            .method_22488()
            .method_9618()
            .method_50012(class_3619.field_15971)
            .method_51368(class_2766.field_12651)
            .method_9629(2.0F, 3.0F)
            .method_9626(class_2498.field_11535)
            .method_51369()
            .method_50013()
    );
    this.method_9590(method_9564().method_11657(SHAPE, Shape.MIDDLE));
  }

  @Override
  protected void method_9515(class_2690<class_2248, class_2680> builder) {
    builder.method_11667(SHAPE);
  }

  @Override
  protected class_265 method_9530(
      class_2680 state, class_1922 world, class_2338 pos, class_3726 context
  ) {
    return OUTLINE_SHAPE.method_64034(state.method_26226(pos));
  }

  @Override
  protected class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos,
      class_3726 context) {
    return OUTLINE_SHAPE.method_64034(state.method_26226(pos));
  }

  @Override
  protected boolean method_9579(class_2680 state) {
    return true;
  }

  @Override
  protected boolean method_9516(class_2680 state, class_10 type) {
    return false;
  }

  @Override
  protected boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
    return false;
  }

  @Override
  public class_2680 method_9559(
      class_2680 state,
      class_4538 world,
      class_10225 tickView,
      class_2338 pos,
      class_2350 direction,
      class_2338 neighborPos,
      class_2680 neighborState,
      class_5819 random
  ) {
    if (!method_9558(state, world, pos)) {
      tickView.method_64310(pos, this, 1);
    }
    return state;
  }

  @Override
  protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
    if (!method_9558(state, world, pos)) {
      world.method_22352(pos, true);
    }
  }

  @Override
  public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
    class_2680 down = world.method_8320(pos.method_10074());
    return down.method_26164(LighterEndTags.AQUATIC_END_SOIL) || down.method_26204() == this;
  }

  @Override
  protected class_1799 method_9574(
      class_4538 world,
      class_2338 pos,
      class_2680 state,
      boolean includeData
  ) {
    return new class_1799(LighterEndBlocks.AGAVE_SEED);
  }

  public enum Shape implements class_3542 {
    TOP("top"),
    MIDDLE("middle"),
    BOTTOM("bottom");

    private final String name;

    Shape(String name) {
      this.name = name;
    }

    @Override
    public String method_15434() {
      return name;
    }

    @Override
    public String toString() {
      return name;
    }
  }

  public static class Bulb extends class_2248 {

    public static final class_2746 NATURAL = class_2746.method_11825("natural");

    public Bulb(class_2251 settings) {
      super(
          settings
              .method_31710(class_3620.field_25708)
              .method_9632(1.0F)
              .method_9626(class_2498.field_37636)
              .method_9631((bs) -> 15)
      );
      method_9590(field_10647.method_11664().method_11657(NATURAL, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
      stateManager.method_11667(NATURAL);
    }

    @Override
    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
      if (
          !world.method_8320(pos.method_10074()).method_27852(LighterEndBlocks.AGAVE) && state.method_11654(NATURAL)
      ) {
        world.method_22352(pos, true);
      }
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 world,
        class_10225 tickView,
        class_2338 pos,
        class_2350 direction,
        class_2338 neighborPos,
        class_2680 neighborState,
        class_5819 random
    ) {
      if (!method_9558(state, world, pos)) {
        tickView.method_64310(pos, this, 1);
      }
      return state;
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
      if (!state.method_11654(NATURAL)) {
        return true;
      }
      return world.method_8320(pos.method_10074()).method_27852(LighterEndBlocks.AGAVE);
    }
  }

  public static class AgaveFeature extends class_3031<class_3111> {

    public AgaveFeature() {
      super(class_3111.field_24893);
    }

    @Override
    public boolean method_13151(class_5821<class_3111> featureConfig) {
      final class_5819 random = featureConfig.method_33654();
      final class_2338 pos = featureConfig.method_33655();
      final class_5281 world = featureConfig.method_33652();

      int height = class_3532.method_15395(random, 2, 5);
      int h = PosInfo.upRay(world, pos, height + 2);
      if (h < height + 1) {
        return false;
      }

      for (int i = 0; i <= height; i++) {
        Shape shape = Shape.MIDDLE;
        if (i == 0) {
          shape = Shape.BOTTOM;
        } else if (i == height) {
          shape = Shape.TOP;
        }
        world.method_8652(
            pos.method_10086(i), LighterEndBlocks.AGAVE.method_9564().method_11657(SHAPE, shape), Flags.SILENT
        );
      }
      placeBulb(world, pos.method_10086(height + 1));
      return true;
    }

    private void placeBulb(class_5281 world, class_2338 pos) {
      world.method_8652(
          pos,
          LighterEndBlocks.AGAVE_BULB.method_9564().method_11657(Bulb.NATURAL, true),
          Flags.SILENT
      );

      for (class_2350 dir : field_23157) {
        if (dir == class_2350.field_11033) {
          continue;
        }
        class_2338 p = pos.method_10093(dir);
        if (world.method_22347(p)) {
          world.method_8652(
              p,
              LighterEndBlocks.AGAVE_FUR.method_9564().method_11657(Fur.FACING, dir),
              Flags.SILENT);
        }
      }
    }
  }
}
