package io.github.openbagtwo.lighterend.blocks;

import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.EnumMap;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class Chandelier extends class_2248 {

  public static final class_2754<class_2350> FACING = class_2741.field_12525;

  private static final EnumMap<class_2350, class_265> BOUNDING_SHAPES = Maps.newEnumMap(
      class_2350.class);

  public Chandelier(class_2251 settings) {
    super(
        settings
            .method_31710(class_3620.field_16005)
            .method_9631((bs) -> 15)
            .method_51369()
            .method_22488()
            .method_29292()
            .method_50012(class_3619.field_15971)
            .method_9632(2.5F)
            .method_9626(class_2498.field_24119)
    );
    method_9590(method_9564().method_11657(FACING, class_2350.field_11036));
  }

  @Override
  public class_265 method_9530(
      class_2680 state,
      class_1922 view,
      class_2338 pos,
      class_3726 ePos
  ) {
    return BOUNDING_SHAPES.get(state.method_11654(FACING));
  }

  @Override
  protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
    stateManager.method_11667(FACING);
  }

  @Override
  public class_2680 method_9605(class_1750 ctx) {
    class_2680 blockState = method_9564();
    class_4538 worldView = ctx.method_8045();
    class_2338 blockPos = ctx.method_8037();
    class_2350[] directions = ctx.method_7718();
    for (class_2350 direction : directions) {
      class_2350 direction2 = direction.method_10153();
      blockState = blockState.method_11657(FACING, direction2);
      if (blockState.method_26184(worldView, blockPos)) {
        return blockState;
      }
    }
    return null;
  }

  @Override
  public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
    class_2350 direction = state.method_11654(FACING);
    class_2338 blockPos = pos.method_10093(direction.method_10153());
    return method_20044(world, blockPos, direction) || world.method_8320(blockPos)
        .method_26164(class_3481.field_15503);
  }

  @Override
  protected class_2680 method_9559(
      class_2680 state,
      class_4538 world,
      class_10225 tickView,
      class_2338 pos,
      class_2350 direction,
      class_2338 neighborPos,
      class_2680 neighborState,
      class_5819 random
  ) {
    if (!method_9558(state, world, pos)) {
      return class_2246.field_10124.method_9564();
    } else {
      return state;
    }
  }


  @Override
  public class_2680 method_9598(class_2680 state, class_2470 rotation) {
    return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
  }

  @Override
  public class_2680 method_9569(class_2680 state, class_2415 mirror) {
    return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
  }

  @Override
  protected boolean method_9516(class_2680 state, class_10 type) {
    return false;
  }

  static {
    BOUNDING_SHAPES.put(class_2350.field_11036, class_2248.method_9541(5, 0, 5, 11, 13, 11));
    BOUNDING_SHAPES.put(class_2350.field_11033, class_2248.method_9541(5, 3, 5, 11, 16, 11));
    BOUNDING_SHAPES.put(class_2350.field_11043, class_259.method_1081(0.0, 0.0, 0.5, 1.0, 1.0, 1.0));
    BOUNDING_SHAPES.put(class_2350.field_11035, class_259.method_1081(0.0, 0.0, 0.0, 1.0, 1.0, 0.5));
    BOUNDING_SHAPES.put(class_2350.field_11039, class_259.method_1081(0.5, 0.0, 0.0, 1.0, 1.0, 1.0));
    BOUNDING_SHAPES.put(class_2350.field_11034, class_259.method_1081(0.0, 0.0, 0.0, 0.5, 1.0, 1.0));
  }

  public static class Oxidizable extends Chandelier implements net.minecraft.class_5955 {

    public static final MapCodec<Oxidizable> CODEC = RecordCodecBuilder.mapCodec(
        instance -> instance.group(
                net.minecraft.class_5955.class_5811.field_46493.fieldOf("weathering_state")
                    .forGetter(
                        Oxidizable::method_33622), method_54096()
            )
            .apply(instance, Oxidizable::new)
    );
    private final net.minecraft.class_5955.class_5811 oxidationLevel;

    @Override
    public MapCodec<Oxidizable> method_53969() {
      return field_46280;
    }

    public Oxidizable(net.minecraft.class_5955.class_5811 oxidationLevel,
        class_4970.class_2251 settings) {
      super(settings);
      this.oxidationLevel = oxidationLevel;
    }

    @Override
    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
      this.method_54764(state, world, pos, random);
    }

    @Override
    protected boolean method_9542(class_2680 state) {
      return net.minecraft.class_5955.method_34737(state.method_26204())
          .isPresent();
    }

    public net.minecraft.class_5955.class_5811 method_33622() {
      return this.oxidationLevel;
    }
  }

}
