package io.github.openbagtwo.lighterend.blocks;

import io.github.openbagtwo.lighterend.registries.LighterEndBlockEntities;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_3468;
import net.minecraft.class_3620;
import net.minecraft.class_3706;
import net.minecraft.class_3716;
import net.minecraft.class_3858;
import net.minecraft.class_3865;
import net.minecraft.class_3908;
import net.minecraft.class_3956;
import net.minecraft.class_5558;
import net.minecraft.class_9895;
import org.jetbrains.annotations.Nullable;

public class Furnaces {

  public static class EndFurnace extends class_3865 {

    public EndFurnace(class_2251 settings) {
      super(
          settings
              .method_31710(class_3620.field_15986)
              .method_51368(class_2766.field_12653)
              .method_29292()
              .method_9632(7F)
              .method_9631(class_2246.method_26107(13))
      );
    }

    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
      return new EndFurnaceEntity(pos, state);
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(
        class_1937 world, class_2680 state, class_2591<T> type
    ) {
      return method_31617(world, type, LighterEndBlockEntities.END_FURNACE);
    }

    @Override
    protected void method_17025(class_1937 world, class_2338 pos, class_1657 player) {
      class_2586 blockEntity = world.method_8321(pos);
      if (blockEntity instanceof EndFurnaceEntity) {
        player.method_17355((class_3908) blockEntity);
        player.method_7281(class_3468.field_15379);
      }
    }
  }

  public static class EndFurnaceEntity extends class_2609 {

    public EndFurnaceEntity(class_2338 pos, class_2680 state) {
      super(LighterEndBlockEntities.END_FURNACE, pos, state, class_3956.field_17546);
    }

    @Override
    protected class_2561 method_17823() {
      return class_2561.method_43471("container.furnace");
    }

    @Override
    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
      return new class_3858(syncId, playerInventory, this, this.field_17374);
    }
  }

  public static class EndSmoker extends class_3716 {

    public EndSmoker(class_2251 settings) {
      super(
          settings
              .method_31710(class_3620.field_15986)
              .method_51368(class_2766.field_12653)
              .method_29292()
              .method_9632(7F)
              .method_9631(class_2246.method_26107(13))
      );
    }

    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
      return new EndSmokerEntity(pos, state);
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(
        class_1937 world, class_2680 state, class_2591<T> type
    ) {
      return method_31617(world, type, LighterEndBlockEntities.END_SMOKER);
    }

    @Override
    protected void method_17025(class_1937 world, class_2338 pos, class_1657 player) {
      class_2586 blockEntity = world.method_8321(pos);
      if (blockEntity instanceof EndSmokerEntity) {
        player.method_17355((class_3908) blockEntity);
        player.method_7281(class_3468.field_17273);
      }
    }
  }

  public static class EndSmokerEntity extends class_2609 {

    public EndSmokerEntity(class_2338 pos, class_2680 state) {
      super(LighterEndBlockEntities.END_SMOKER, pos, state, class_3956.field_17548);
    }

    @Override
    protected class_2561 method_17823() {
      return class_2561.method_43471("container.smoker");
    }

    @Override
    protected int method_11200(class_9895 fuelRegistry, class_1799 stack) {
      return super.method_11200(fuelRegistry, stack) / 2;
    }

    @Override
    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
      return new class_3706(syncId, playerInventory, this, this.field_17374);
    }
  }

}
