package io.github.openbagtwo.lighterend.blocks;

import com.mojang.serialization.MapCodec;
import io.github.openbagtwo.lighterend.blocks.entities.Updraft;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.utils.Flags;
import net.minecraft.class_10225;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2402;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2766;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class HydrothermalVent extends class_2237 implements class_2402, class_3737 {

  public static final MapCodec<HydrothermalVent> CODEC = method_54094(HydrothermalVent::new);

  public static final class_2746 WATERLOGGED = class_2741.field_12508;
  public static final class_2746 ACTIVATED = class_2746.method_11825("active");
  private static final class_265 SHAPE = class_2248.method_9541(1, 1, 1, 15, 16, 15);

  public HydrothermalVent(class_2251 settings) {
    super(
        settings
            .method_51368(class_2766.field_12653)
            .method_9626(class_2498.field_11544)
            .method_29292()
            .method_9629(1.5F, 6.0F)
            .method_50012(class_3619.field_15971)
            .method_31710(class_3620.field_16023)
    );
    this.method_9590(method_9564().method_11657(WATERLOGGED, false).method_11657(ACTIVATED, false));
  }

  @Override
  public MapCodec<HydrothermalVent> method_53969() {
    return field_46280;
  }

  @Override
  protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
    builder.method_11667(WATERLOGGED, ACTIVATED);
  }

  @Override
  public class_265 method_9530(
      class_2680 state,
      class_1922 view,
      class_2338 pos,
      class_3726 ePos
  ) {
    return SHAPE;
  }

  @Override
  public boolean method_10310(
      @Nullable class_1309 filler,
      class_1922 world,
      class_2338 pos,
      class_2680 state,
      class_3611 fluid
  ) {
    return false;
  }


  @Override
  public boolean method_10311(
      class_1936 world,
      class_2338 pos,
      class_2680 state,
      class_3610 fluidState
  ) {
    return false;
  }

  @Override
  public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
    state = world.method_8320(pos.method_10074());
    return state.method_27852(LighterEndBlocks.BORNITE.baseBlock);
  }

  @Override
  protected class_2680 method_9559(
      class_2680 state,
      class_4538 world,
      class_10225 tickView,
      class_2338 pos,
      class_2350 direction,
      class_2338 neighborPos,
      class_2680 neighborState,
      class_5819 random
  ) {
    if (!method_9558(state, world, pos)) {
      return state.method_11654(WATERLOGGED) ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564();
    } else if (
        state.method_11654(WATERLOGGED)
            && direction == class_2350.field_11036
            && neighborState.method_27852(class_2246.field_10382)
            && world instanceof class_3218 serverWorld
    ) {
      serverWorld.method_39283(pos, this, 20);
    }
    return state;
  }

  @Override
  public class_2680 method_9605(class_1750 ctx) {
    class_1936 worldAccess = ctx.method_8045();
    class_2338 blockPos = ctx.method_8037();
    return this.method_9564()
        .method_11657(WATERLOGGED, worldAccess.method_8316(blockPos).method_15772() == class_3612.field_15910);
  }

  @Override
  public class_3610 method_9545(class_2680 state) {
    return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
  }

  @Override
  public class_2586 method_10123(class_2338 pos, class_2680 state) {
    return new Updraft(pos, state);
  }

  @Override
  public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
    class_2338 up = pos.method_10084();
    if (world.method_8320(up).method_27852(class_2246.field_10382)) {
      world.method_8652(up, LighterEndBlocks.VENT_BUBBLE_COLUMN.method_9564(), Flags.SILENT);
      world.method_39283(up, LighterEndBlocks.VENT_BUBBLE_COLUMN, 5);
    }
  }

  @Override
  public void method_9567(
      class_1937 world,
      class_2338 pos,
      class_2680 state,
      @Nullable class_1309 placer,
      class_1799 itemStack
  ) {
    if (
        world instanceof class_3218
            && state.method_11654(WATERLOGGED) && world.method_8320(pos.method_10084()).method_27852(class_2246.field_10382)) {
      method_9588(state, (class_3218) world, pos, world.field_9229);
    }
  }

  public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
    super.method_9496(state, world, pos, random);
    if (!state.method_11654(ACTIVATED) && random.method_43056()) {
      double x = pos.method_10263() + random.method_43058();
      double y = pos.method_10264() + 0.9 + random.method_43058() * 0.3;
      double z = pos.method_10260() + random.method_43058();
      world.method_8406(class_2398.field_11237, x, y, z, 0, 0, 0);
    }
  }

  @Nullable
  @Override
  public <T extends class_2586> class_5558<T> method_31645(
      class_1937 level,
      class_2680 blockState,
      class_2591<T> blockEntityType
  ) {
    return Updraft::tick;
  }

}
