package io.github.openbagtwo.lighterend.blocks;

import io.github.openbagtwo.lighterend.utils.Flags;
import net.minecraft.class_10225;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2754;
import net.minecraft.class_2766;
import net.minecraft.class_3542;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class Obelisk extends class_2248 {

  private static final class_265 VOXEL_SHAPE_BOTTOM = class_2248.method_9541(1, 0, 1, 15, 16, 15);
  private static final class_265 VOXEL_SHAPE_MIDDLE_TOP = class_2248.method_9541(
      2, 0, 2, 14, 16, 14
  );

  public static final class_2754<Shape> SHAPE = class_2754.method_11850("shape", Shape.class);

  public Obelisk(class_2251 settings) {
    super(
        settings
            .method_31710(class_3620.field_15986)
            .method_51368(class_2766.field_12653)
            .method_9629(-1.0F, 3600000.0F)
            .method_42327()
            .method_9631((state) -> state.method_11654(SHAPE) == Shape.BOTTOM ? 0 : 15)
    );
  }

  @Override
  protected class_265 method_9530(
      class_2680 state, class_1922 world, class_2338 pos, class_3726 context
  ) {
    return (state.method_11654(SHAPE) == Shape.BOTTOM) ? VOXEL_SHAPE_BOTTOM : VOXEL_SHAPE_MIDDLE_TOP;
  }

  @Override
  protected void method_9515(class_2690<class_2248, class_2680> builder) {
    builder.method_11667(SHAPE);
  }

  @Override
  public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
    for (int i = 0; i < 3; i++) {
      if (!world.method_8320(pos.method_10086(i)).method_45474()) {
        return false;
      }
    }
    return true;
  }

  @Override
  public void method_9567(
      class_1937 world,
      class_2338 pos,
      class_2680 state,
      @Nullable class_1309 placer,
      class_1799 itemStack
  ) {
    state = this.method_9564();
    world.method_8652(pos, state.method_11657(SHAPE, Shape.BOTTOM), Flags.SILENT);
    world.method_8652(pos.method_10084(), state.method_11657(SHAPE, Shape.MIDDLE), Flags.SILENT);
    world.method_8652(pos.method_10086(2), state.method_11657(SHAPE, Shape.TOP), Flags.SILENT);
  }

  @Override
  protected class_2680 method_9559(
      class_2680 state,
      class_4538 world,
      class_10225 tickView,
      class_2338 pos,
      class_2350 direction,
      class_2338 neighborPos,
      class_2680 neighborState,
      class_5819 random
  ) {
    Shape shape = state.method_11654(SHAPE);
    if (shape == Shape.BOTTOM) {
      if (world.method_8320(pos.method_10084()).method_27852(this)) {
        return state;
      } else {
        return class_2246.field_10124.method_9564();
      }
    } else if (shape == Shape.MIDDLE) {
      if (world.method_8320(pos.method_10084()).method_27852(this) && world.method_8320(pos.method_10074()).method_27852(this)) {
        return state;
      } else {
        return class_2246.field_10124.method_9564();
      }
    } else {
      if (world.method_8320(pos.method_10074()).method_27852(this)) {
        return state;
      } else {
        return class_2246.field_10124.method_9564();
      }
    }
  }

  @Override
  public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
    if (player.method_68878()) {
      Shape shape = state.method_11654(SHAPE);
      if (shape == Shape.MIDDLE) {
        world.method_8652(pos.method_10074(), class_2246.field_10124.method_9564(), Flags.SILENT);
      } else if (shape == Shape.TOP) {
        world.method_8652(pos.method_10087(2), class_2246.field_10124.method_9564(), Flags.SILENT);
      }
    }
    return super.method_9576(world, pos, state, player);
  }

  public enum Shape implements class_3542 {
    TOP("top"),
    MIDDLE("middle"),
    BOTTOM("bottom");

    private final String name;

    Shape(String name) {
      this.name = name;
    }

    @Override
    public String method_15434() {
      return name;
    }

    @Override
    public String toString() {
      return name;
    }
  }

}
