package io.github.openbagtwo.lighterend.blocks;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.openbagtwo.lighterend.registries.LighterEndBlockEntities;
import net.minecraft.class_2338;
import net.minecraft.class_2508;
import net.minecraft.class_2551;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_4719;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_7717;

public class Signs {

  public static class LighterEndStandingSignBlock extends class_2508 {

    public static final MapCodec<class_2508> CODEC =
        RecordCodecBuilder.mapCodec((instance) ->
            instance.group(
                    class_4719.field_46535.fieldOf("wood_type")
                        .forGetter((obj) -> obj.method_24025()),
                    method_54096())
                .apply(instance, LighterEndStandingSignBlock::new));

    public LighterEndStandingSignBlock(class_4719 woodType, class_2251 properties) {
      super(
          woodType,
          properties
              .method_51369()
              .method_51368(class_2766.field_12651)
              .method_9634()
              .method_9632(1.0F)
              .method_50013()
      );
    }

    @Override
    public MapCodec<class_2508> method_53969() {
      return field_46461;
    }

    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
      return new LighterEndSignBlockEntity(pos, state);
    }
  }

  public static class LighterEndWallSignBlock extends class_2551 {

    public static final MapCodec<class_2551> CODEC =
        RecordCodecBuilder.mapCodec((instance) ->
            instance.group(
                    class_4719.field_46535.fieldOf("wood_type")
                        .forGetter((obj) -> obj.method_24025()),
                    method_54096())
                .apply(instance, LighterEndWallSignBlock::new));

    public LighterEndWallSignBlock(class_4719 woodType, class_2251 properties) {
      super(
          woodType,
          properties
              .method_51369()
              .method_51368(class_2766.field_12651)
              .method_9634()
              .method_9632(1.0F)
              .method_50013()
      );
    }

    @Override
    public MapCodec<class_2551> method_53969() {
      return field_46280;
    }

    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
      return new LighterEndSignBlockEntity(pos, state);
    }
  }

  public static class LighterEndCeilingHangingSignBlock extends class_7713 {

    public static final MapCodec<class_7713> CODEC =
        RecordCodecBuilder.mapCodec((instance) ->
            instance.group(
                    class_4719.field_46535.fieldOf("wood_type")
                        .forGetter((obj) -> obj.method_24025()),
                    method_54096())
                .apply(instance, LighterEndCeilingHangingSignBlock::new));

    public LighterEndCeilingHangingSignBlock(class_4719 woodType, class_2251 properties) {
      super(
          woodType,
          properties
              .method_51369()
              .method_51368(class_2766.field_12651)
              .method_9634()
              .method_9632(1.0F)
              .method_50013()
      );
    }

    @Override
    public MapCodec<class_7713> method_53969() {
      return field_46280;
    }

    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
      return new LighterEndHangingSignBlockEntity(pos, state);
    }
  }

  public static class LighterEndWallHangingSignBlock extends class_7715 {

    public static final MapCodec<class_7715> CODEC =
        RecordCodecBuilder.mapCodec((instance) ->
            instance.group(
                    class_4719.field_46535.fieldOf("wood_type")
                        .forGetter((obj) -> obj.method_24025()),
                    method_54096())
                .apply(instance, LighterEndWallHangingSignBlock::new));

    public LighterEndWallHangingSignBlock(class_4719 woodType, class_2251 properties) {
      super(
          woodType,
          properties
              .method_51369()
              .method_51368(class_2766.field_12651)
              .method_9634()
              .method_9632(1.0F)
              .method_50013()
      );
    }

    @Override
    public MapCodec<class_7715> method_53969() {
      return field_46280;
    }

    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
      return new LighterEndHangingSignBlockEntity(pos, state);
    }
  }

  public static class LighterEndSignBlockEntity extends class_2625 {

    public LighterEndSignBlockEntity(class_2338 pos, class_2680 state) {
      super(LighterEndBlockEntities.SIGN, pos, state);
    }
  }

  public static class LighterEndHangingSignBlockEntity extends class_7717 {

    public LighterEndHangingSignBlockEntity(class_2338 pos, class_2680 state) {
      super(pos, state);
    }

    @Override
    public class_2591<?> method_11017() {
      return LighterEndBlockEntities.HANGING_SIGN;
    }

    @Override
    public boolean method_61176(class_2680 blockState) {
      return this.method_11017().method_20526(blockState);
    }
  }
}
