package io.github.openbagtwo.lighterend.blocks;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2402;
import net.minecraft.class_2498;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class SulphurCrystal extends class_2248 implements class_3737, class_2402 {

  public static final int MAX_STAGE = 2;
  public static final class_2758 STAGE = class_2758.method_11867("stage", 0, MAX_STAGE);
  public static final class_2754<class_2350> FACING = class_2741.field_12525;
  public static final class_2746 WATERLOGGED = class_2741.field_12508;

  private static final EnumMap<class_2350, class_265> SHAPES = Maps.newEnumMap(class_2350.class);

  public SulphurCrystal(class_2251 settings) {
    super(
        settings
            .method_31710(class_3620.field_16010)
            .method_9626(class_2498.field_11537)
            .method_50012(class_3619.field_15971)
    );
  }

  @Override
  protected void method_9515(class_2690<class_2248, class_2680> builder) {
    builder.method_11667(STAGE, WATERLOGGED, FACING);
  }

  @Override
  public class_2680 method_9605(class_1750 ctx) {
    class_1936 worldAccess = ctx.method_8045();
    class_2338 blockPos = ctx.method_8037();

    class_2680 state = this.method_9564().method_11657(
        WATERLOGGED,
        worldAccess.method_8316(blockPos).method_15772() == class_3612.field_15910
    );

    class_2350[] directions = ctx.method_7718();

    for (class_2350 direction : directions) {
      state = state.method_11657(FACING, direction.method_10153());
      if (state.method_26184(worldAccess, blockPos)) {
        return state;
      }
    }
    return null;
  }

  @Override
  public @NotNull class_3610 method_9545(class_2680 state) {
    return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
  }

  @Override
  public @NotNull class_265 method_9530(
      class_2680 state,
      class_1922 view,
      class_2338 pos,
      class_3726 ePos
  ) {
    return SHAPES.get(state.method_11654(FACING));
  }

  @Override
  protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
    class_2350 direction = state.method_11654(FACING);
    class_2338 blockPos = pos.method_10093(direction.method_10153());
    return world.method_8320(blockPos).method_26206(world, blockPos, direction);
  }

  @Override
  protected class_2680 method_9559(
      class_2680 state,
      class_4538 world,
      class_10225 tickView,
      class_2338 pos,
      class_2350 direction,
      class_2338 neighborPos,
      class_2680 neighborState,
      class_5819 random
  ) {
    if (state.method_11654(WATERLOGGED)) {
      tickView.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
    }

    return direction == (state.method_11654(FACING)).method_10153() && !state.method_26184(world, pos)
        ? class_2246.field_10124.method_9564()
        : super.method_9559(
            state,
            world,
            tickView,
            pos,
            direction,
            neighborPos,
            neighborState,
            random
        );
  }

  static {
    SHAPES.put(class_2350.field_11036, class_259.method_1081(0.125, 0.0, 0.125, 0.875F, 0.5, 0.875F));
    SHAPES.put(class_2350.field_11033, class_259.method_1081(0.125, 0.5, 0.125, 0.875F, 1.0, 0.875F));
    SHAPES.put(class_2350.field_11043, class_259.method_1081(0.125, 0.125, 0.5, 0.875F, 0.875F, 1.0));
    SHAPES.put(class_2350.field_11035, class_259.method_1081(0.125, 0.125, 0.0, 0.875F, 0.875F, 0.5));
    SHAPES.put(class_2350.field_11039, class_259.method_1081(0.5, 0.125, 0.125, 1.0, 0.875F, 0.875F));
    SHAPES.put(class_2350.field_11034, class_259.method_1081(0.0, 0.125, 0.125, 0.5, 0.875F, 0.875F));
  }

}
