package io.github.openbagtwo.lighterend.blocks;

import com.mojang.serialization.MapCodec;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndParticles;
import net.minecraft.class_10225;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2498;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4538;
import net.minecraft.class_4865;
import net.minecraft.class_4949;
import net.minecraft.class_4970;
import net.minecraft.class_5778;
import net.minecraft.class_5819;

public class TenaneaFlower extends class_4865 {

  public static final MapCodec<TenaneaFlower> CODEC = method_54094(TenaneaFlower::new);
  private static final class_265 SHAPE = class_2248.method_9541(2, 0, 2, 14, 16, 14);
  public static final class_2746 TIP = class_2741.field_54794;
  public static final class_2382[] COLORS;

  public TenaneaFlower(class_4970.class_2251 settings) {
    super(
        settings
            .method_31710(class_3620.field_15998)
            .method_51371()
            .method_9634()
            .method_9618()
            .method_22488()
            .method_9626(class_2498.field_11535)
            .method_50012(class_3619.field_15971)
            .method_49229(class_2250.field_10656)
            .method_50013()
            .method_9640()
            .method_9631((bs) -> 8),
        class_2350.field_11033,
        SHAPE,
        false,
        0.1
    );
    this.method_9590(this.field_10647.method_11664().method_11657(TIP, true));
  }

  @Override
  protected int method_26376(class_5819 random) {
    return class_4949.method_26381(random);
  }

  @Override
  protected boolean method_24949(class_2680 state) {
    return class_4949.method_25961(state);
  }

  @Override
  protected class_2248 method_24946() {
    return LighterEndBlocks.TENANEA_FLOWER;
  }

  @Override
  protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
    class_2338 blockPos = pos.method_10093(class_2350.field_11036);
    class_2680 blockState = world.method_8320(blockPos);
    // TODO once Tenanea Leaves are a thing:
    // return blockState.isOf(LighterEndBlocks.TENANEA_LEAVES) || || blockState.isOf(
    //        LighterEndBlocks.TENANEA_FLOWER);
    return class_5778.method_33358(world, class_2350.field_11036, blockPos, blockState) || blockState.method_27852(
        LighterEndBlocks.TENANEA_FLOWER);
  }

  @Override
  protected class_2680 method_9559(
      class_2680 state,
      class_4538 world,
      class_10225 tickView,
      class_2338 pos,
      class_2350 direction,
      class_2338 neighborPos,
      class_2680 neighborState,
      class_5819 random
  ) {
    super.method_9559(state, world, tickView, pos, direction, neighborPos,
        neighborState, random);

    return state.method_11657(TIP, !world.method_8320(pos.method_10074()).method_27852(this));
  }

  @Override
  protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
    super.method_9515(builder);
    builder.method_11667(TIP);
  }

  @Override
  public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
    return world.method_8320(this.getTipPos(world, pos).method_10074()).method_26215();
  }

  public class_2338 getTipPos(class_1922 world, class_2338 pos) {
    class_2338.class_2339 mutable = pos.method_25503();

    class_2680 blockState;
    do {
      mutable.method_10098(class_2350.field_11033);
      blockState = world.method_8320(mutable);
    } while (blockState.method_27852(this));

    return mutable.method_10093(class_2350.field_11036).method_10062();
  }

  @Override
  public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
    super.method_9652(world, random, pos, state);
    world.method_8501(this.getTipPos(world, pos), state.method_11657(TIP, true));
  }

  @Override
  public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
    super.method_9496(state, world, pos, random);
    if (random.method_43048(32) == 0) {
      double x = (double) pos.method_10263() + random.method_43059() + 0.5;
      double z = (double) pos.method_10260() + random.method_43059() + 0.5;
      double y = (double) pos.method_10264() + random.method_43058();
      world.method_8406(LighterEndParticles.TENANEA_PETAL, x, y, z, 0, 0, 0);
    }

  }

  @Override
  public MapCodec<TenaneaFlower> method_53969() {
    return field_46280;
  }


  static {
    COLORS = new class_2382[]{
        new class_2382(250, 111, 222),
        new class_2382(167, 89, 255),
        new class_2382(120, 207, 239),
        new class_2382(255, 87, 182)
    };
  }


}
