package io.github.openbagtwo.lighterend.blocks;

import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_322;
import net.minecraft.class_3532;

public class TenaneaFlowerRenderer {

  public static final class_2382[] COLORS = new class_2382[]{
      new class_2382(250, 111, 222),
      new class_2382(167, 89, 255),
      new class_2382(120, 207, 239),
      new class_2382(255, 87, 182)
  };

  public static class_322 getBlockColor() {
    return (state, world, pos, tintIndex) -> {
      if (pos == null) {
        pos = class_2338.field_10980;
      }

      long i = (getRandom(pos.method_10263(), pos.method_10260()) & 63) + pos.method_10264();
      double delta = i * 0.1;
      int index = class_3532.method_15357(delta);
      int index2 = (index + 1) & 3;
      delta -= index;
      index &= 3;

      class_2382 color1 = COLORS[index];
      class_2382 color2 = COLORS[index2];

      int r = class_3532.method_15357(class_3532.method_16436(delta, color1.method_10263(), color2.method_10263()));
      int g = class_3532.method_15357(class_3532.method_16436(delta, color1.method_10264(), color2.method_10264()));
      int b = class_3532.method_15357(class_3532.method_16436(delta, color1.method_10260(), color2.method_10260()));
      float[] hsb = RGBtoHSB(r, g, b, new float[3]);

      return HSBtoRGB(hsb[0], Math.max(0.5F, hsb[1]), hsb[2]);
    };
  }

  // Utils (TODO: refactor out as needed)

  private static int getRandom(int x, int z) {
    int h = x * 374761393 + z * 668265263;
    h = (h ^ (h >> 13)) * 1274126177;
    return h ^ (h >> 16);
  }

  private static float[] RGBtoHSB(int r, int g, int b, float[] hsbvals) {
    float hue, saturation, brightness;
    if (hsbvals == null) {
      hsbvals = new float[4];
    }
    int cmax = (r > g) ? r : g;
    if (b > cmax) {
      cmax = b;
    }
    int cmin = (r < g) ? r : g;
    if (b < cmin) {
      cmin = b;
    }

    brightness = ((float) cmax) / 255.0F;
    if (cmax != 0) {
      saturation = ((float) (cmax - cmin)) / ((float) cmax);
    } else {
      saturation = 0;
    }
    if (saturation == 0) {
      hue = 0;
    } else {
      float redc = ((float) (cmax - r)) / ((float) (cmax - cmin));
      float greenc = ((float) (cmax - g)) / ((float) (cmax - cmin));
      float bluec = ((float) (cmax - b)) / ((float) (cmax - cmin));
      if (r == cmax) {
        hue = bluec - greenc;
      } else if (g == cmax) {
        hue = 2.0F + redc - bluec;
      } else {
        hue = 4.0F + greenc - redc;
      }
      hue = hue / 6.0F;
      if (hue < 0) {
        hue = hue + 1.0F;
      }
    }
    hsbvals[0] = hue;
    hsbvals[1] = saturation;
    hsbvals[2] = brightness;
    return hsbvals;
  }

  private static int HSBtoRGB(float hue, float saturation, float brightness) {
    int r = 0, g = 0, b = 0;
    if (saturation == 0) {
      r = g = b = (int) (brightness * 255.0F + 0.5F);
    } else {
      float h = (hue - (float) Math.floor(hue)) * 6.0F;
      float f = h - (float) Math.floor(h);
      float p = brightness * (1.0F - saturation);
      float q = brightness * (1.0F - saturation * f);
      float t = brightness * (1.0F - (saturation * (1.0F - f)));
      switch ((int) h) {
        case 0:
          r = (int) (brightness * 255.0F + 0.5F);
          g = (int) (t * 255.0F + 0.5F);
          b = (int) (p * 255.0F + 0.5F);
          break;
        case 1:
          r = (int) (q * 255.0F + 0.5F);
          g = (int) (brightness * 255.0F + 0.5F);
          b = (int) (p * 255.0F + 0.5F);
          break;
        case 2:
          r = (int) (p * 255.0F + 0.5F);
          g = (int) (brightness * 255.0F + 0.5F);
          b = (int) (t * 255.0F + 0.5F);
          break;
        case 3:
          r = (int) (p * 255.0F + 0.5F);
          g = (int) (q * 255.0F + 0.5F);
          b = (int) (brightness * 255.0F + 0.5F);
          break;
        case 4:
          r = (int) (t * 255.0F + 0.5F);
          g = (int) (p * 255.0F + 0.5F);
          b = (int) (brightness * 255.0F + 0.5F);
          break;
        case 5:
          r = (int) (brightness * 255.0F + 0.5F);
          g = (int) (p * 255.0F + 0.5F);
          b = (int) (q * 255.0F + 0.5F);
          break;
      }
    }
    return 0xFF000000 | (r << 16) | (g << 8) | (b << 0);
  }
}
