package io.github.openbagtwo.lighterend.datagen;

import io.github.openbagtwo.lighterend.registries.LighterEndMobs;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1299;
import net.minecraft.class_3483;
import net.minecraft.class_7225.class_7874;

public class MobTagProvider extends FabricTagProvider.EntityTypeTagProvider {

  public MobTagProvider(
      FabricDataOutput dataOutput,
      CompletableFuture<class_7874> registriesFuture
  ) {
    super(dataOutput, registriesFuture);
  }

  @Override
  protected void method_10514(class_7874 wrapperLookup) {
    valueLookupBuilder(class_3483.field_48289).method_71558(
        LighterEndMobs.SILK_MOTH.mob,
        LighterEndMobs.DRAGONFLY.mob,
        LighterEndMobs.CHORUS_CRAB.mob
    );
    valueLookupBuilder(class_3483.field_48288).method_71558(
        LighterEndMobs.END_FISH.mob,
        LighterEndMobs.CUBOZOA.mob
    );
    valueLookupBuilder(class_3483.field_29824).method_71558(
        LighterEndMobs.END_FISH.mob,
        LighterEndMobs.CUBOZOA.mob
    );

    valueLookupBuilder(class_3483.field_38697).method_71558(
        LighterEndMobs.DRAGONFLY.mob,
        LighterEndMobs.END_SLIME.mob
    );

    valueLookupBuilder(class_3483.field_50105).method_71554(
        LighterEndMobs.END_SLIME.mob
    );

    valueLookupBuilder(class_3483.field_45066).method_71554(
        LighterEndMobs.END_SLIME.mob
    );
    // I like the idea of these weird-looking fish scaring pufferfish
//    valueLookupBuilder(EntityTypeTags.NOT_SCARY_FOR_PUFFERFISH).add(
//        LighterEndMobs.END_FISH.mob,
//        LighterEndMobs.CUBOZOA.mob
//    );
    valueLookupBuilder(LighterEndTags.MOTH_NEST_INHABITORS).method_71554(
        LighterEndMobs.SILK_MOTH.mob
    );

    valueLookupBuilder(LighterEndTags.IGNORES_GEYSER_BUBBLES).method_71558(
        LighterEndMobs.END_FISH.mob,
        LighterEndMobs.CUBOZOA.mob
    );

    valueLookupBuilder(LighterEndTags.IMMUNE_TO_MURKWEED).method_71558(
        class_1299.field_6128,
        class_1299.field_6078
    );

  }
}
