package io.github.openbagtwo.lighterend.datagen;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.misc.Wood.WoodSet;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks.Material;
import io.github.openbagtwo.lighterend.registries.LighterEndEquipment;
import io.github.openbagtwo.lighterend.registries.LighterEndItems;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2446;
import net.minecraft.class_2454;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7225.class_7874;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8790;

public class RecipeProvider extends FabricRecipeProvider {

  protected RecipeProvider(
      FabricDataOutput output,
      CompletableFuture<class_7874> registriesFuture
  ) {
    super(output, registriesFuture);
  }

  @Override
  protected class_2446 method_62766(
      class_7225.class_7874 registryLookup,
      class_8790 exporter
  ) {
    return new class_2446(registryLookup, exporter) {
      @Override
      public void method_10419() {
        method_46209(
            class_7800.field_40634,
            LighterEndBlocks.AURORA_CRYSTAL,
            LighterEndItems.AURORA_CRYSTAL_SHARD
        );

        method_46209(
            class_7800.field_40634, LighterEndBlocks.ENDER_BLOCK, class_1802.field_8634
        );

        generateMaterialRecipes(LighterEndBlocks.VIOLECITE);

        method_62747(class_7800.field_40634, LighterEndBlocks.MISSING_TILE, 4)
            .method_10439("VP")
            .method_10439("PV")
            .method_10434('V', LighterEndBlocks.VIOLECITE.tiles)
            .method_10434('P', class_2246.field_10286)
            .method_10429(
                method_32807(LighterEndBlocks.VIOLECITE.tiles),
                method_10426(LighterEndBlocks.VIOLECITE.tiles)
            ).method_10431(field_53721);

        for (Material jadestone : Arrays.asList(
            LighterEndBlocks.AZURE_JADESTONE,
            LighterEndBlocks.SANDY_JADESTONE,
            LighterEndBlocks.VIRID_JADESTONE
        )) {
          generateMaterialRecipes(jadestone);
        }

        method_62747(class_7800.field_40634, LighterEndBlocks.DRAGON_BONE_BLOCK, 8)
            .method_10439("BBB")
            .method_10439("BDB")
            .method_10439("BBB")
            .method_10434('B', class_2246.field_10166)
            .method_10434('D', class_1802.field_8613)
            .method_10429(
                method_32807(class_1802.field_8613),
                method_10426(class_1802.field_8613)
            ).method_10431(field_53721);
        method_32814(
            class_7800.field_40634,
            LighterEndBlocks.DRAGON_BONE_SLAB,
            LighterEndBlocks.DRAGON_BONE_BLOCK
        );
        method_33715(
            class_7800.field_40634,
            LighterEndBlocks.DRAGON_BONE_SLAB,
            LighterEndBlocks.DRAGON_BONE_BLOCK,
            2
        );
        offerStairsRecipe(LighterEndBlocks.DRAGON_BONE_STAIRS, LighterEndBlocks.DRAGON_BONE_BLOCK);
        method_33717(
            class_7800.field_40634,
            LighterEndBlocks.DRAGON_BONE_STAIRS,
            LighterEndBlocks.DRAGON_BONE_BLOCK
        );

        method_62750(class_7800.field_40642, LighterEndBlocks.END_MOSS, 2)
            .method_10454(class_2246.field_10471)
            .method_10454(class_2246.field_54731)
            .method_10442(
                method_32807(class_2246.field_10471),
                method_10426(class_2246.field_10471)
            ).method_10431(field_53721);

        method_62749(class_7800.field_40642, class_1802.field_8632)
            .method_10454(LighterEndBlocks.CREEPING_MOSS)
            .method_10442(
                method_32807(LighterEndBlocks.CREEPING_MOSS),
                method_10426(LighterEndBlocks.CREEPING_MOSS)
            ).method_17972(
                field_53721,
                class_5321.method_29179(
                    class_7924.field_52178,
                    LighterEnd.of("cyan_dye_from_creeping_moss")
                )
            );

        method_62749(class_7800.field_40642, class_1802.field_8492)
            .method_10454(LighterEndBlocks.UMBRELLA_FERN)
            .method_10442(
                method_32807(LighterEndBlocks.UMBRELLA_FERN),
                method_10426(LighterEndBlocks.UMBRELLA_FERN)
            ).method_17972(
                field_53721,
                class_5321.method_29179(
                    class_7924.field_52178,
                    LighterEnd.of("orange_dye_from_umbrella_fern")
                )
            );

        generateCookingRecipes(LighterEndItems.LUMECORN_EAR, LighterEndItems.POPPED_LUMECORN);

        generateMaterialRecipes(LighterEndBlocks.UMBRALITH);

        method_62749(class_7800.field_40642, class_1802.field_8669)
            .method_10454(LighterEndBlocks.TENANEA_FLOWER)
            .method_10442(
                method_32807(LighterEndBlocks.TENANEA_FLOWER),
                method_10426(LighterEndBlocks.TENANEA_FLOWER)
            ).method_17972(
                field_53721,
                class_5321.method_29179(
                    class_7924.field_52178,
                    LighterEnd.of("magenta_dye_from_tenanea_flower")
                )
            );

        generateWoodRecipes(LighterEndBlocks.TENANEA);

        method_62750(class_7800.field_40642, class_1802.field_8276, 2)
            .method_10454(LighterEndItems.SILK)
            .method_10442(
                method_32807(LighterEndItems.SILK),
                method_10426(LighterEndItems.SILK)
            ).method_17972(
                field_53721,
                class_5321.method_29179(
                    class_7924.field_52178,
                    LighterEnd.of("string_from_silk")
                )
            );

        method_62746(class_7800.field_40642, LighterEndItems.SILK_MATRIX)
            .method_10439("###")
            .method_10439("###")
            .method_10439("###")
            .method_10434('#', LighterEndItems.SILK)
            .method_10429(
                method_32807(LighterEndItems.SILK),
                method_10426(LighterEndItems.SILK)
            ).method_10431(field_53721);

        method_62750(class_7800.field_40642, LighterEndItems.SILK, 9)
            .method_10454(LighterEndItems.SILK_MATRIX)
            .method_10442(
                method_32807(LighterEndItems.SILK_MATRIX),
                method_10426(LighterEndItems.SILK_MATRIX)
            ).method_10431(field_53721);

        method_62746(class_7800.field_40635, LighterEndItems.SILK_MOTH_NEST)
            .method_10439(" P ")
            .method_10439("PMP")
            .method_10439("PPP")
            .method_10434('M', LighterEndItems.SILK_MATRIX)
            .method_10434('P', LighterEndBlocks.TENANEA.planks)
            .method_10429(
                method_32807(LighterEndItems.SILK_MATRIX),
                method_10426(LighterEndItems.SILK_MATRIX)
            ).method_10431(field_53721);

        method_62746(class_7800.field_40639, LighterEndEquipment.SILK_ELYTRA)
            .method_10439("P P")
            .method_10439("MMM")
            .method_10439("MMM")
            .method_10434('M', LighterEndItems.SILK_MATRIX)
            .method_10434('P', class_1802.field_8614)
            .method_10429(
                method_32807(LighterEndItems.SILK_MATRIX),
                method_10426(LighterEndItems.SILK_MATRIX)
            ).method_10431(field_53721);

        generateWoodRecipes(LighterEndBlocks.UMBRELLA);
        class_2454.method_17802(
                class_1856.method_8101(LighterEndBlocks.UMBRELLA_MEMBRANE), class_7800.field_40642,
                class_1802.field_8777, 0.1F, 200)
            .method_10469(method_32807(LighterEndBlocks.UMBRELLA_MEMBRANE),
                this.method_10426(LighterEndBlocks.UMBRELLA_MEMBRANE))
            .method_17972(
                field_53721,
                class_5321.method_29179(
                    class_7924.field_52178,
                    LighterEnd.of("slime_balls_from_smelting_membranes")
                )
            );

        generateSmokingSmeltingRecipes(LighterEndItems.RAW_END_FISH, class_1802.field_28410,
            class_7800.field_40642);

        generateSmokingSmeltingRecipes(LighterEndBlocks.CHARNIA_CYAN, class_1802.field_8632,
            class_7800.field_40642);
        generateSmokingSmeltingRecipes(LighterEndBlocks.CHARNIA_GREEN, class_1802.field_8408,
            class_7800.field_40642);
        generateSmokingSmeltingRecipes(LighterEndBlocks.CHARNIA_LIGHT_BLUE, class_1802.field_8273,
            class_7800.field_40642);
        generateSmokingSmeltingRecipes(LighterEndBlocks.CHARNIA_ORANGE, class_1802.field_8492,
            class_7800.field_40642);
        generateSmokingSmeltingRecipes(LighterEndBlocks.CHARNIA_PURPLE, class_1802.field_8296,
            class_7800.field_40642);
        generateSmokingSmeltingRecipes(LighterEndBlocks.CHARNIA_RED, class_1802.field_8264,
            class_7800.field_40642);

        method_62747(class_7800.field_40639, class_1802.field_8236, 4)
            .method_10439("X")
            .method_10439("#")
            .method_10439("Y")
            .method_10434('X', LighterEndItems.GLOW_BARB)
            .method_10434('#', class_1802.field_8600)
            .method_10433('Y', LighterEndTags.FLETCHINGS
            ).method_10429(
                method_32807(LighterEndItems.GLOW_BARB),
                method_10426(LighterEndItems.GLOW_BARB)
            ).method_17972(
                field_53721,
                class_5321.method_29179(
                    class_7924.field_52178,
                    LighterEnd.of("spectral_arrow")
                )
            );

        generateSmokingSmeltingRecipes(LighterEndItems.END_LILY_LEAF,
            LighterEndItems.DRIED_END_LILY_LEAF, class_7800.field_40642);

        method_62747(class_7800.field_40642, class_1802.field_8407, 3)
            .method_10439("###")
            .method_10434('#', LighterEndItems.DRIED_END_LILY_LEAF)
            .method_10429(
                method_32807(LighterEndItems.DRIED_END_LILY_LEAF),
                method_10426(LighterEndItems.DRIED_END_LILY_LEAF)
            ).method_17972(
                field_53721,
                class_5321.method_29179(
                    class_7924.field_52178,
                    LighterEnd.of("paper_from_dried_leaves")
                )
            );

        generateWoodRecipes(LighterEndBlocks.LOTUS, 4);
        method_47522(
            class_7800.field_40634,
            LighterEndBlocks.LOTUS.log,
            LighterEndBlocks.END_LOTUS_STEM
        );

        generateWoodRecipes(LighterEndBlocks.GLOWSHROOM);

        class_2454.method_17802(
                class_1856.method_8101(LighterEndItems.END_CREAM), class_7800.field_40641,
                LighterEndItems.END_POWDER, 0.1F, 200)
            .method_10469(method_32807(LighterEndItems.END_CREAM),
                method_10426(LighterEndItems.END_CREAM))
            .method_17972(
                field_53721,
                class_5321.method_29179(
                    class_7924.field_52178,
                    LighterEnd.of("end_powder_from_smelting_end_cream")
                )
            );

        method_62746(class_7800.field_40638, class_1802.field_8868)
            .method_10439(" #")
            .method_10439("# ")
            .method_10434('#', LighterEndItems.CRAB_CLAW)
            .method_10429(
                method_32807(LighterEndItems.CRAB_CLAW),
                method_10426(LighterEndItems.CRAB_CLAW)
            ).method_17972(
                field_53721,
                class_5321.method_29179(
                    class_7924.field_52178,
                    LighterEnd.of("shears_from_claws")
                )
            );
        generateCookingRecipes(LighterEndItems.CRAB_MEAT, LighterEndItems.CRAB_CAKE);

        method_62746(class_7800.field_40635, LighterEndBlocks.END_FURNACE)
            .method_10434('#', class_2246.field_10471)
            .method_10439("###")
            .method_10439("# #")
            .method_10439("###")
            .method_10429(method_32807(class_2246.field_10471), this.method_10426(class_2246.field_10471))
            .method_10431(field_53721);
        method_62749(class_7800.field_40637, class_1802.field_8063)
            .method_10454(LighterEndBlocks.END_FURNACE)
            .method_10454(class_1802.field_8045)
            .method_10442(
                method_32807(LighterEndBlocks.END_FURNACE),
                this.method_10426(LighterEndBlocks.END_FURNACE)
            ).method_17972(
                field_53721,
                class_5321.method_29179(
                    class_7924.field_52178,
                    LighterEnd.of("furnace_minecart_from_end_stone_furnace")
                )
            );
        method_62746(class_7800.field_40635, LighterEndBlocks.END_SMOKER)
            .method_10433('#', class_3489.field_15539)
            .method_10434('X', LighterEndBlocks.END_FURNACE)
            .method_10439(" # ")
            .method_10439("#X#")
            .method_10439(" # ")
            .method_10429(
                method_32807(LighterEndBlocks.END_FURNACE),
                this.method_10426(LighterEndBlocks.END_FURNACE)
            ).method_10431(field_53721);

        method_62746(class_7800.field_40636, LighterEndBlocks.END_LEVER)
            .method_10434('#', class_2246.field_10471)
            .method_10434('X', class_1802.field_8600)
            .method_10439("X")
            .method_10439("#")
            .method_10429(method_32807(class_2246.field_10471), this.method_10426(class_2246.field_10471))
            .method_10431(field_53721);

        method_62746(class_7800.field_40635, LighterEndBlocks.GOLD_CHANDELIER)
            .method_10434('r', LighterEndItems.LUMECORN_EAR)
            .method_10434('n', class_1802.field_8397)
            .method_10434('i', class_1802.field_8695)
            .method_10439("r r")
            .method_10439("n n")
            .method_10439(" i ")
            .method_10429(
                method_32807(LighterEndItems.LUMECORN_EAR),
                this.method_10426(LighterEndItems.LUMECORN_EAR)
            ).method_10431(field_53721);

        method_62746(class_7800.field_40635, LighterEndBlocks.IRON_CHANDELIER)
            .method_10434('r', LighterEndItems.LUMECORN_EAR)
            .method_10434('n', class_1802.field_8675)
            .method_10434('i', class_1802.field_8620)
            .method_10439("r r")
            .method_10439("n n")
            .method_10439(" i ")
            .method_10429(
                method_32807(LighterEndItems.LUMECORN_EAR),
                this.method_10426(LighterEndItems.LUMECORN_EAR)
            ).method_10431(field_53721);

        method_62746(class_7800.field_40635, LighterEndBlocks.COPPER_CHANDELIERS.comp_4576())
            .method_10434('r', LighterEndItems.LUMECORN_EAR)
            .method_10434('n', class_1802.field_61349)
            .method_10434('i', class_1802.field_27022)
            .method_10439("r r")
            .method_10439("n n")
            .method_10439(" i ")
            .method_10429(
                method_32807(LighterEndItems.LUMECORN_EAR),
                this.method_10426(LighterEndItems.LUMECORN_EAR)
            ).method_10431(field_53721);
        LighterEndBlocks.COPPER_CHANDELIERS.method_73126().forEach(
            (unwaxed, waxed) -> method_62749(class_7800.field_40635, waxed)
                .method_10454(unwaxed)
                .method_10454(class_1802.field_20414)
                .method_10442(method_32807(unwaxed), this.method_10426(unwaxed))
                .method_10431(field_53721)
        );

        class_2454.method_17802(
            class_1856.method_8101(LighterEndBlocks.FERROUS_ICE),
            class_7800.field_40642,
            class_1802.field_8675,
            0.1F,
            200
        ).method_10469(
            method_32807(LighterEndBlocks.FERROUS_ICE),
            method_10426(LighterEndBlocks.FERROUS_ICE)
        ).method_17972(
            field_53721,
            class_5321.method_29179(
                class_7924.field_52178,
                LighterEnd.of("smelting_iron_from_ice")
            )
        );

        class_2454.method_17802(
            class_1856.method_8101(LighterEndBlocks.EMERALD_ICE),
            class_7800.field_40642,
            class_1802.field_61349,
            0.1F,
            200
        ).method_10469(
            method_32807(LighterEndBlocks.EMERALD_ICE),
            method_10426(LighterEndBlocks.EMERALD_ICE)
        ).method_17972(
            field_53721,
            class_5321.method_29179(
                class_7924.field_52178,
                LighterEnd.of("smelting_copper_from_ice")
            )
        );

        method_36233(
            List.of(LighterEndBlocks.END_STONE_REDSTONE_ORE,
                LighterEndBlocks.UMBRALITH_REDSTONE_ORE),
            class_7800.field_40636,
            class_1802.field_8725,
            0.7F,
            200,
            "end_redstone"
        );
        method_36234(
            List.of(LighterEndBlocks.END_STONE_REDSTONE_ORE,
                LighterEndBlocks.UMBRALITH_REDSTONE_ORE),
            class_7800.field_40636,
            class_1802.field_8725,
            0.7F,
            100,
            "end_redstone"
        );

        method_62746(class_7800.field_40636, class_2246.field_10228)
            .method_10434('R', class_1802.field_8725)
            .method_10434('#', class_2246.field_10471)
            .method_10439("###")
            .method_10439("# #")
            .method_10439("#R#")
            .method_10429(method_32807(class_2246.field_10471), this.method_10426(class_2246.field_10471))
            .method_17972(this.field_53721,
                class_5321.method_29179(
                    class_7924.field_52178,
                    LighterEnd.of("dropper_using_end_stone")
                )
            );
        method_62746(class_7800.field_40636, class_2246.field_10200)
            .method_10434('R', class_1802.field_8725)
            .method_10434('#', class_2246.field_10471)
            .method_10434('X', class_1802.field_8102)
            .method_10439("###")
            .method_10439("#X#")
            .method_10439("#R#")
            .method_10429(method_32807(class_2246.field_10471), this.method_10426(class_2246.field_10471))
            .method_17972(this.field_53721,
                class_5321.method_29179(
                    class_7924.field_52178,
                    LighterEnd.of("dispenser_using_end_stone")
                )
            );
        method_62746(class_7800.field_40636, class_2246.field_10282)
            .method_10434('Q', class_1802.field_8155)
            .method_10434('R', class_1802.field_8725)
            .method_10434('#', class_2246.field_10471)
            .method_10439("###")
            .method_10439("RRQ")
            .method_10439("###")
            .method_10429(method_32807(class_2246.field_10471), this.method_10426(class_2246.field_10471))
            .method_17972(this.field_53721,
                class_5321.method_29179(
                    class_7924.field_52178,
                    LighterEnd.of("observer_using_end_stone")
                )
            );
        method_62746(class_7800.field_40636, class_2246.field_10560)
            .method_10434('R', class_1802.field_8725)
            .method_10434('#', class_2246.field_10471)
            .method_10433('T', class_3489.field_15537)
            .method_10434('X', class_1802.field_8620)
            .method_10439("TTT")
            .method_10439("#X#")
            .method_10439("#R#")
            .method_10429(method_32807(class_2246.field_10471), this.method_10426(class_2246.field_10471))
            .method_17972(this.field_53721,
                class_5321.method_29179(
                    class_7924.field_52178,
                    LighterEnd.of("piston_using_end_stone")
                )
            );

        generateMaterialRecipes(LighterEndBlocks.BORNITE);

        method_62747(class_7800.field_40635, LighterEndItems.MATCHSTICK, 4)
            .method_10434('#', class_1802.field_8600)
            .method_10434('X', LighterEndItems.CRYSTALLINE_SULPHUR)
            .method_10439("X")
            .method_10439("#")
            .method_10429(
                method_32807(LighterEndItems.CRYSTALLINE_SULPHUR),
                this.method_10426(LighterEndItems.CRYSTALLINE_SULPHUR)
            ).method_10431(this.field_53721);

        method_62750(class_7800.field_40642, class_1802.field_8054, 3)
            .method_10454(class_1802.field_8324)
            .method_10451(class_1856.method_8091(class_1802.field_8713, class_1802.field_8665))
            .method_10454(LighterEndItems.CRYSTALLINE_SULPHUR)
            .method_10442(
                method_32807(LighterEndItems.CRYSTALLINE_SULPHUR),
                this.method_10426(LighterEndItems.CRYSTALLINE_SULPHUR)
            ).method_17972(
                this.field_53721,
                class_5321.method_29179(
                    class_7924.field_52178,
                    LighterEnd.of("gunpowder_from_sulphur")
                )
            );

        method_62750(class_7800.field_40642, class_1802.field_8479, 3)
            .method_10454(LighterEndItems.UMBRELLA_JUICE)
            .method_10452("sugar")
            .method_10442(
                method_32807(LighterEndItems.UMBRELLA_JUICE),
                this.method_10426(LighterEndItems.UMBRELLA_JUICE)
            ).method_36443(this.field_53721, method_33714(class_1802.field_8479, LighterEndItems.UMBRELLA_JUICE));

        generateCookingRecipes(LighterEndItems.SHADOW_BERRY, LighterEndItems.SHADOW_BERRY_COOKED);
        method_62750(class_7800.field_40640, LighterEndItems.SHADOW_BERRY_JAM, 3)
            .method_10449(LighterEndItems.SHADOW_BERRY_COOKED, 3)
            .method_10449(class_1802.field_8479, 3)
            .method_10449(class_1802.field_8469, 3)
            .method_10442(
                method_32807(LighterEndItems.SHADOW_BERRY_COOKED),
                this.method_10426(LighterEndItems.SHADOW_BERRY_COOKED)
            ).method_10431(this.field_53721);

        method_62749(class_7800.field_40642, class_1802.field_8226)
            .method_10454(LighterEndBlocks.MURKWEED)
            .method_10442(
                method_32807(LighterEndBlocks.MURKWEED),
                method_10426(LighterEndBlocks.MURKWEED)
            ).method_17972(
                field_53721,
                class_5321.method_29179(
                    class_7924.field_52178,
                    LighterEnd.of("black_dye_from_murkweed")
                )
            );

        generateWoodRecipes(LighterEndBlocks.DRAGON);
      }

      public void generateMaterialRecipes(Material material) {

        method_32814(
            class_7800.field_40634, material.baseSlab, material.baseBlock
        );
        method_33715(
            class_7800.field_40634, material.baseSlab, material.baseBlock, 2
        );
        offerStairsRecipe(material.baseStairs, material.baseBlock);
        method_33717(
            class_7800.field_40634, material.baseStairs, material.baseBlock
        );
        method_32809(class_7800.field_40634, material.baseWall, material.baseBlock);
        method_33717(
            class_7800.field_40634, material.baseWall, material.baseBlock
        );
        method_62747(class_7800.field_40634, material.pillar, 1)
            .method_10439("s")
            .method_10439("s")
            .method_10434('s', material.baseSlab)
            .method_10429(
                method_32807(material.baseSlab),
                method_10426(material.baseSlab)
            ).method_10431(field_53721);
        method_33717(
            class_7800.field_40634, material.pillar, material.baseBlock
        );

        method_32810(
            class_7800.field_40634, material.polished, material.baseBlock
        );
        method_33717(
            class_7800.field_40634, material.polished, material.baseBlock
        );
        method_32814(
            class_7800.field_40634, material.polishedSlab, material.polished
        );
        offerStairsRecipe(material.polishedStairs, material.polished);
        method_32809(class_7800.field_40634, material.polishedWall, material.polished);
        offerButtonRecipe(material.button, material.polished);
        method_32813(material.pressurePlate, material.polished);
        for (class_1935 input : Arrays.asList(material.polished, material.baseBlock)) {
          method_33715(
              class_7800.field_40634, material.polishedSlab, input, 2
          );
          method_33717(
              class_7800.field_40634, material.polishedStairs, input
          );
          method_33717(
              class_7800.field_40634, material.polishedWall, input
          );
        }

        method_32810(
            class_7800.field_40634, material.bricks, material.polished
        );
        method_33717(class_7800.field_40634, material.bricks, material.polished);
        method_33717(
            class_7800.field_40634, material.bricks, material.baseBlock
        );
        method_32814(class_7800.field_40634, material.brickSlab, material.bricks);
        offerStairsRecipe(material.brickStairs, material.bricks);
        method_32809(class_7800.field_40634, material.brickWall, material.bricks);
        for (class_1935 input : Arrays.asList(
            material.bricks, material.polished, material.baseBlock
        )) {
          method_33715(
              class_7800.field_40634, material.brickSlab, input, 2
          );
          method_33717(
              class_7800.field_40634, material.brickStairs, input
          );
          method_33717(
              class_7800.field_40634, material.brickWall, input
          );
        }

        method_32810(class_7800.field_40634, material.tiles, material.bricks);
        method_33717(class_7800.field_40634, material.tiles, material.polished);
        method_33717(class_7800.field_40634, material.tiles, material.baseBlock);
        method_32814(
            class_7800.field_40634, material.tileSlab, material.tiles
        );
        offerStairsRecipe(material.tileStairs, material.tiles);
        method_32809(class_7800.field_40634, material.tileWall, material.tiles);
        for (class_1935 input : Arrays.asList(
            material.tiles, material.bricks, material.polished, material.baseBlock
        )) {
          method_33715(
              class_7800.field_40634, material.tileSlab, input, 2
          );
          method_33717(
              class_7800.field_40634, material.tileStairs, input
          );
          method_33717(
              class_7800.field_40634, material.tileWall, input
          );
        }

        method_62746(class_7800.field_40635, material.pedestal)
            .method_10439("s")
            .method_10439("#")
            .method_10439("s")
            .method_10434('s', material.polishedSlab)
            .method_10434('#', material.pillar)
            .method_10429(method_32807(material.pillar), method_10426(material.pillar))
            .method_10431(field_53721);
      }

      public void generateWoodRecipes(WoodSet wood) {
        generateWoodRecipes(wood, 4);
      }

      public void generateWoodRecipes(WoodSet wood, int planks_per_log) {
        method_62747(class_7800.field_40634, wood.wood, 3).method_10439("ll").method_10439("ll")
            .method_10434('l', wood.log).method_10429(
                method_32807(wood.log),
                method_10426(wood.log)
            ).method_10431(field_53721);
        method_62747(class_7800.field_40634, wood.strippedWood, 3).method_10439("ll")
            .method_10439("ll").method_10434('l', wood.log).method_10429(
                method_32807(wood.strippedLog),
                method_10426(wood.strippedLog)
            ).method_10431(field_53721);
        method_62750(class_7800.field_40634, wood.planks, planks_per_log)
            .method_10446(LighterEndTags.LOG_TAGS.get(wood.baseName))
            .method_10442(
                method_32807(wood.log),
                this.method_10420(LighterEndTags.LOG_TAGS.get(wood.baseName))
            ).method_10431(field_53721);
        method_32814(class_7800.field_40634, wood.slab, wood.planks);
        offerStairsRecipe(wood.stairs, wood.planks);
        method_33544(wood.door, class_1856.method_8101(wood.planks)).method_33530(method_32807(wood.planks),
            method_10426(wood.planks)).method_10431(field_53721);
        method_33553(wood.trapdoor, class_1856.method_8101(wood.planks)).method_33530(
            method_32807(wood.planks),
            method_10426(wood.planks)).method_10431(field_53721);
        method_33546(wood.fence, class_1856.method_8101(wood.planks)).method_33530(
            method_32807(wood.planks),
            method_10426(wood.planks)).method_10431(field_53721);
        method_33548(wood.gate, class_1856.method_8101(wood.planks)).method_33530(
            method_32807(wood.planks),
            method_10426(wood.planks)).method_10431(field_53721);
        offerButtonRecipe(wood.button, wood.planks);
        method_32813(wood.pressurePlate, wood.planks);
        method_62747(class_7800.field_40635, wood.ladder, 2)
            .method_10434('#', wood.slab)
            .method_10439("#")
            .method_10439("#")
            .method_10439("#")
            .method_10429(method_32807(wood.planks), this.method_10426(wood.planks))
            .method_10431(field_53721);
        method_33555(wood.sign, class_1856.method_8101(wood.planks)).method_33530(
            method_32807(wood.planks),
            method_10426(wood.planks)).method_10431(field_53721);
        method_62747(class_7800.field_40635, wood.hangingSign, 6)
            .method_10435("hanging_sign")
            .method_10433('#', LighterEndTags.STRIPPED_LOG_TAGS.get(wood.baseName))
            .method_10434('X', class_1802.field_23983)
            .method_10439("X X")
            .method_10439("###")
            .method_10439("###")
            .method_10429(
                method_32807(wood.strippedLog),
                this.method_10420(LighterEndTags.STRIPPED_LOG_TAGS.get(wood.baseName))
            ).method_10431(this.field_53721);

        method_62747(class_7800.field_40635, wood.shelf, 6)
            .method_10433('#', LighterEndTags.STRIPPED_LOG_TAGS.get(wood.baseName))
            .method_10439("###")
            .method_10439("   ")
            .method_10439("###")
            .method_10435("shelf")
            .method_10429(
                method_32807(wood.strippedLog),
                this.method_10420(LighterEndTags.STRIPPED_LOG_TAGS.get(wood.baseName))
            ).method_10431(this.field_53721);
      }

      // seems odd these aren't already implemented
      public void offerStairsRecipe(class_1935 output, class_1935 input) {
        method_32808(
            output, class_1856.method_8101(input)
        ).method_33530(method_32807(input), this.method_10426(input)).method_10431(field_53721);
      }

      public void offerButtonRecipe(class_1935 output, class_1935 input) {
        method_33542(
            output, class_1856.method_8101(input)
        ).method_33530(method_32807(input), this.method_10426(input)).method_10431(field_53721);
      }

      public void generateCookingRecipes(class_1935 input, class_1935 output) {
        generateSmokingSmeltingRecipes(input, output, class_7800.field_40640);

        class_2454.method_35916(
            class_1856.method_8101(input),
            class_7800.field_40640,
            output,
            0.35F,
            600
        ).method_10469(method_32807(input), this.method_10426(input)
        ).method_17972(
            field_53721,
            class_5321.method_29179(
                class_7924.field_52178,
                LighterEnd.of(
                    class_7923.field_41178.method_10221(output.method_8389()).method_12832()
                        + "_campfire_from_"
                        + class_7923.field_41178.method_10221(input.method_8389()).method_12832())
            )
        );
      }

      public void generateSmokingSmeltingRecipes(class_1935 input, class_1935 output,
          class_7800 category) {
        String output_key = class_7923.field_41178.method_10221(output.method_8389()).method_12832();
        class_2454.method_17802(
            class_1856.method_8101(input),
            category,
            output,
            0.35F,
            200
        ).method_10469(method_32807(input), this.method_10426(input)
        ).method_17972(
            field_53721,
            class_5321.method_29179(class_7924.field_52178,
                LighterEnd.of(
                    output_key
                        + "_smelting_"
                        + class_7923.field_41178.method_10221(input.method_8389()).method_12832()
                )
            )
        );
        class_2454.method_35918(
            class_1856.method_8101(input),
            category,
            output,
            0.35F,
            100
        ).method_10469(method_32807(input),
            method_10426(input)
        ).method_17972(
            field_53721,
            class_5321.method_29179(class_7924.field_52178,
                LighterEnd.of(
                    output_key
                        + "_smoking_"
                        + class_7923.field_41178.method_10221(input.method_8389()).method_12832()
                )
            )
        );
      }
    };
  }

  @Override
  public String method_10321() {
    return "LighterEndRecipeProvider";
  }
}
