package io.github.openbagtwo.lighterend.items;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.registries.LighterEndItems;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_7923;

public final class ItemGroups {

  public static final class_1761 LighterEndItemGroup = register("lighterend_items",
      FabricItemGroup.builder()
          .method_47320(() -> new class_1799(
              LighterEndItems.AURORA_CRYSTAL_SHARD))
          .method_47321(class_2561.method_43471("itemGroup.lighterend.lighterend_items"))
          /* Auto-registreation of all modded items cribbed from:
             https://github.com/DaRealTurtyWurty/1.21-Tutorial-Mod

             MIT License

             Copyright (c) 2024 TurtyWurty
           */
          .method_47317((displayContext, entries) -> class_7923.field_41178.method_10235()
              .stream()
              .sorted()
              .filter(key -> key.method_12836().equals(LighterEnd.MOD_ID) && !key.method_12832()
                  .endsWith("wall_sign") && !key.method_12832().endsWith("wall_hanging_sign"))
              .map(class_7923.field_41178::method_63535)
              .forEach(entries::method_45421))
          .method_47324());

  public static <T extends class_1761> T register(String name, T itemGroup) {
    return class_2378.method_10230(class_7923.field_44687, LighterEnd.of(name),
        itemGroup);
  }

  public static void initialize() {
  }

}
