package io.github.openbagtwo.lighterend.mixin;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.world.gen.LighterEndWorldGen;
import net.minecraft.class_1966;
import net.minecraft.class_2794;
import net.minecraft.class_3754;
import net.minecraft.class_4766;
import net.minecraft.class_5363;
import net.minecraft.class_7134;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(MinecraftServer.class)
public abstract class BiomeProvidingMixin {


  @ModifyArgs(method = "createWorlds", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/world/ServerWorld;<init>(Lnet/minecraft/server/MinecraftServer;Ljava/util/concurrent/Executor;Lnet/minecraft/world/level/storage/LevelStorage$Session;Lnet/minecraft/world/level/ServerWorldProperties;Lnet/minecraft/registry/RegistryKey;Lnet/minecraft/world/dimension/DimensionOptions;ZJLjava/util/List;ZLnet/minecraft/util/math/random/RandomSequencesState;)V"))
  private void addModdedBiomes(Args args) {
    if (LighterEnd.CONFIG.generateBiomes()) {
      MinecraftServer server = args.get(0);
      class_5363 dimensionOptions = args.get(5);
      if (class_7134.field_37668.equals(
          dimensionOptions.comp_1012().method_40230().orElse(null))) {
        class_2794 defaultChunkGen = dimensionOptions.comp_1013();
        class_1966 defaultBiomes = defaultChunkGen.method_12098();

        if (defaultBiomes instanceof class_4766 noiseBiomeSource
            && defaultChunkGen instanceof class_3754 noiseChunkGen) {
          class_1966 patchedBiomes = LighterEndWorldGen.addBiomesToNoiseSource(
              ((BiomeAccessor) noiseBiomeSource).accessBiomeEntries(),
              server.method_30611().method_30530(
                  class_7924.field_41236)
          );
          args.set(5, new class_5363(
              dimensionOptions.comp_1012(),
              new class_3754(patchedBiomes, noiseChunkGen.method_41541())
          ));
        }
      }
    }
  }


}
