package io.github.openbagtwo.lighterend.mixin;

import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_3233;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

/**
 * Silences the "Detected setBlock in a far chunk" complaints
 */
@Mixin(class_3233.class)
public class BlocksAreNotTooFarMixin {

  @Final
  @Shadow
  private class_2791 centerPos;

  @Inject(method = "isValidForSetBlock", at = @At("HEAD"), cancellable = true)
  private void alterBlockCheck(class_2338 blockPos, CallbackInfoReturnable<Boolean> cir) {
    int x = blockPos.method_10263() >> 4;
    int z = blockPos.method_10260() >> 4;
    cir.setReturnValue(
        Math.abs(x - centerPos.method_12004().field_9181) < 2 && Math.abs(z - centerPos.method_12004().field_9180) < 2);
  }
}
